/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.utils.ReflectionUtils;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumConverter
implements ObjectConverter {
    private String _name;
    private Object _default;
    private Class<?> _type;
    private Object[] _objects;
    private String[] _strings;
    private boolean _strict = true;
    private transient ConverterContext _context;

    public EnumConverter(Class<? extends Enum> enumType) {
        if (enumType == null || !enumType.isEnum()) {
            throw new IllegalArgumentException("To use this constructor, the type has to be an enum type.");
        }
        String name = enumType.getName();
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Empty enum type name.");
        }
        int index = name.lastIndexOf("$");
        this._name = index >= 0 ? name.substring(index + 1) : name;
        this._type = enumType;
        try {
            Object values = ReflectionUtils.callStatic(enumType, "values", null, null);
            if (!values.getClass().isArray()) {
                throw new IllegalArgumentException("Illegal enum type.");
            }
            int length = Array.getLength(values);
            this._objects = new Object[length];
            this._strings = new String[length];
            for (int i2 = 0; i2 < length; ++i2) {
                this._objects[i2] = Array.get(values, i2);
                this._strings[i2] = "" + this._objects[i2];
            }
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Illegal enum type.");
        }
    }

    public EnumConverter(String name, Object[] values, String[] strings) {
        this(name, values[0] == null ? (values.length > 1 ? values[1].getClass() : Object.class) : values[0].getClass(), values, strings);
    }

    public EnumConverter(String name, Class<?> type, Object[] values, String[] strings) {
        this(name, type, values, strings, null);
    }

    public EnumConverter(String name, Class<?> type, Object[] objects, String[] strings, Object defaultValue) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null or empty. Please use a unique string to represent the name of the converter.");
        }
        this._name = name;
        if (objects == null) {
            throw new IllegalArgumentException("The \"objects\" parameter cannot be null.");
        }
        if (strings == null) {
            throw new IllegalArgumentException("The \"strings\" parameter cannot be null.");
        }
        if (strings.length != objects.length) {
            throw new IllegalArgumentException("The \"objects\" and \"strings\" parameters should have the same length.");
        }
        this._type = type;
        this._objects = objects;
        this._strings = strings;
        this._default = defaultValue;
    }

    public ConverterContext getContext() {
        if (this._context == null) {
            this._context = new ConverterContext(this._name);
        }
        return this._context;
    }

    @Override
    public String toString(Object object, ConverterContext context) {
        for (int i2 = 0; i2 < this._objects.length; ++i2) {
            if ((this._objects[i2] != null || object != null) && (this._objects[i2] == null || !this._objects[i2].equals(object)) || i2 >= this._strings.length) continue;
            return this._strings[i2];
        }
        return this.isStrict() ? null : "" + object;
    }

    @Override
    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext context) {
        for (int i2 = 0; i2 < this._strings.length; ++i2) {
            if (!this._strings[i2].equals(string) || i2 >= this._objects.length) continue;
            return this._objects[i2];
        }
        return this.isStrict() ? this._default : string;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext context) {
        return true;
    }

    public String getName() {
        return this._name;
    }

    public Class<?> getType() {
        return this._type;
    }

    public Object getDefault() {
        return this._default;
    }

    public Object[] getObjects() {
        return this._objects;
    }

    public String[] getStrings() {
        return this._strings;
    }

    public static String[] toStrings(Object[] values) {
        return EnumConverter.toStrings(values, null);
    }

    public static String[] toStrings(Object[] values, ConverterContext converterContext) {
        String[] s2 = new String[values.length];
        for (int i2 = 0; i2 < s2.length; ++i2) {
            s2[i2] = ObjectConverterManager.toString(values[i2], values[i2].getClass(), converterContext);
        }
        return s2;
    }

    public boolean isStrict() {
        return this._strict;
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }
}

