/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.BinaryFunction;
import org.apache.commons.math.analysis.BivariateRealFunction;
import org.apache.commons.math.analysis.MultivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.util.FastMath;

public abstract class ComposableFunction
implements UnivariateRealFunction {
    public static final ComposableFunction ZERO = new ComposableFunction(){

        public double value(double d2) {
            return 0.0;
        }
    };
    public static final ComposableFunction ONE = new ComposableFunction(){

        public double value(double d2) {
            return 1.0;
        }
    };
    public static final ComposableFunction IDENTITY = new ComposableFunction(){

        public double value(double d2) {
            return d2;
        }
    };
    public static final ComposableFunction ABS = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.abs(d2);
        }
    };
    public static final ComposableFunction NEGATE = new ComposableFunction(){

        public double value(double d2) {
            return -d2;
        }
    };
    public static final ComposableFunction INVERT = new ComposableFunction(){

        public double value(double d2) {
            return 1.0 / d2;
        }
    };
    public static final ComposableFunction SIN = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.sin(d2);
        }
    };
    public static final ComposableFunction SQRT = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.sqrt(d2);
        }
    };
    public static final ComposableFunction SINH = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.sinh(d2);
        }
    };
    public static final ComposableFunction EXP = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.exp(d2);
        }
    };
    public static final ComposableFunction EXPM1 = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.expm1(d2);
        }
    };
    public static final ComposableFunction ASIN = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.asin(d2);
        }
    };
    public static final ComposableFunction ATAN = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.atan(d2);
        }
    };
    public static final ComposableFunction TAN = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.tan(d2);
        }
    };
    public static final ComposableFunction TANH = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.tanh(d2);
        }
    };
    public static final ComposableFunction CBRT = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.cbrt(d2);
        }
    };
    public static final ComposableFunction CEIL = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.ceil(d2);
        }
    };
    public static final ComposableFunction FLOOR = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.floor(d2);
        }
    };
    public static final ComposableFunction LOG = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.log(d2);
        }
    };
    public static final ComposableFunction LOG10 = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.log10(d2);
        }
    };
    public static final ComposableFunction LOG1P = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.log1p(d2);
        }
    };
    public static final ComposableFunction COS = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.cos(d2);
        }
    };
    public static final ComposableFunction ACOS = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.acos(d2);
        }
    };
    public static final ComposableFunction COSH = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.cosh(d2);
        }
    };
    public static final ComposableFunction RINT = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.rint(d2);
        }
    };
    public static final ComposableFunction SIGNUM = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.signum(d2);
        }
    };
    public static final ComposableFunction ULP = new ComposableFunction(){

        public double value(double d2) {
            return FastMath.ulp(d2);
        }
    };

    public ComposableFunction of(final UnivariateRealFunction f2) {
        return new ComposableFunction(){

            public double value(double x2) throws FunctionEvaluationException {
                return ComposableFunction.this.value(f2.value(x2));
            }
        };
    }

    public ComposableFunction postCompose(final UnivariateRealFunction f2) {
        return new ComposableFunction(){

            public double value(double x2) throws FunctionEvaluationException {
                return f2.value(ComposableFunction.this.value(x2));
            }
        };
    }

    public ComposableFunction combine(final UnivariateRealFunction f2, final BivariateRealFunction combiner) {
        return new ComposableFunction(){

            public double value(double x2) throws FunctionEvaluationException {
                return combiner.value(ComposableFunction.this.value(x2), f2.value(x2));
            }
        };
    }

    public ComposableFunction add(final UnivariateRealFunction f2) {
        return new ComposableFunction(){

            public double value(double x2) throws FunctionEvaluationException {
                return ComposableFunction.this.value(x2) + f2.value(x2);
            }
        };
    }

    public ComposableFunction add(final double a2) {
        return new ComposableFunction(){

            public double value(double x2) throws FunctionEvaluationException {
                return ComposableFunction.this.value(x2) + a2;
            }
        };
    }

    public ComposableFunction subtract(final UnivariateRealFunction f2) {
        return new ComposableFunction(){

            public double value(double x2) throws FunctionEvaluationException {
                return ComposableFunction.this.value(x2) - f2.value(x2);
            }
        };
    }

    public ComposableFunction multiply(final UnivariateRealFunction f2) {
        return new ComposableFunction(){

            public double value(double x2) throws FunctionEvaluationException {
                return ComposableFunction.this.value(x2) * f2.value(x2);
            }
        };
    }

    public ComposableFunction multiply(final double scaleFactor) {
        return new ComposableFunction(){

            public double value(double x2) throws FunctionEvaluationException {
                return ComposableFunction.this.value(x2) * scaleFactor;
            }
        };
    }

    public ComposableFunction divide(final UnivariateRealFunction f2) {
        return new ComposableFunction(){

            public double value(double x2) throws FunctionEvaluationException {
                return ComposableFunction.this.value(x2) / f2.value(x2);
            }
        };
    }

    public MultivariateRealFunction asCollector(final BivariateRealFunction combiner, final double initialValue) {
        return new MultivariateRealFunction(){

            public double value(double[] point) throws FunctionEvaluationException, IllegalArgumentException {
                double result = initialValue;
                for (double entry : point) {
                    result = combiner.value(result, ComposableFunction.this.value(entry));
                }
                return result;
            }
        };
    }

    public MultivariateRealFunction asCollector(BivariateRealFunction combiner) {
        return this.asCollector(combiner, 0.0);
    }

    public MultivariateRealFunction asCollector(double initialValue) {
        return this.asCollector(BinaryFunction.ADD, initialValue);
    }

    public MultivariateRealFunction asCollector() {
        return this.asCollector(BinaryFunction.ADD, 0.0);
    }

    public abstract double value(double var1) throws FunctionEvaluationException;
}

