/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.broad.igv.PreferenceManager;
import org.broad.igv.data.seg.FreqData;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;

@XmlType(factoryMethod="getNextTrack")
public class CNFreqTrack
extends AbstractTrack {
    FreqData data;
    BarChartRenderer renderer;
    @XmlAttribute
    float ampThreshold;
    @XmlAttribute
    float delThreshold;

    public CNFreqTrack() {
    }

    public CNFreqTrack(ResourceLocator rl, String id, String name, FreqData fd) {
        super(rl, id, name);
        this.data = fd;
        this.ampThreshold = PreferenceManager.getInstance().getAsFloat("CN_FREQ.AMP_THRESHOLD");
        this.delThreshold = PreferenceManager.getInstance().getAsFloat("CN_FREQ.DEL_THRESHOLD");
        float nSamples = this.data.getNumberOfSamples();
        this.setDataRange(new DataRange(-nSamples, 0.0f, nSamples));
        this.posColor = Color.red;
        this.altColor = Color.blue;
        this.renderer = new BarChartRenderer();
        this.setMinimumHeight(25);
        this.setHeight(50);
        this.setSortable(false);
    }

    public void setAmpThreshold(float ampThreshold) {
        this.ampThreshold = ampThreshold;
    }

    public void setDelThreshold(float delThreshold) {
        this.delThreshold = delThreshold;
    }

    public float getAmpThreshold() {
        return this.ampThreshold;
    }

    public float getDelThreshold() {
        return this.delThreshold;
    }

    @Override
    public Map<String, String> getPersistentState() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ampThreshold", String.valueOf(this.ampThreshold));
        map.put("delThreshold", String.valueOf(this.delThreshold));
        return map;
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        this.data.compute(this.ampThreshold, this.delThreshold);
        this.renderer.render(this.data.getDelCounts(context.getChr()), context, rect, (Track)this);
        this.renderer.render(this.data.getAmpCounts(context.getChr()), context, rect, (Track)this);
        this.renderer.setMarginFraction(0.0);
        this.renderer.renderBorder(this, context, rect);
        context.getGraphic2DForColor(Color.black).drawRect(rect.x, rect.y, rect.width, rect.height - 1);
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        int startIdx;
        List<LocusScore> ampScores = this.data.getAmpCounts(chr);
        List<LocusScore> delScores = this.data.getDelCounts(chr);
        StringBuffer buf = new StringBuffer();
        for (int i2 = startIdx = Math.max(0, FeatureUtils.getIndexBefore(position, ampScores)); i2 < ampScores.size(); ++i2) {
            LocusScore ampScore = ampScores.get(i2);
            if (!(position >= (double)ampScore.getStart()) || !(position <= (double)ampScore.getEnd())) continue;
            buf.append("# of samples with log2(cn/2) &gt; &nbsp; " + this.ampThreshold + ": ");
            buf.append(ampScore.getValueString(position, null));
            buf.append("<br># of samples with log2(cn/2) &lt;  " + this.delThreshold + ":  ");
            buf.append(delScores.get(i2).getValueString(position, null));
        }
        return buf.length() == 0 ? null : buf.toString();
    }

    @Override
    public Renderer getRenderer() {
        return this.renderer;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return -2.1474836E9f;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu menu = new IGVPopupMenu();
        JMenuItem ampThresholdItem = new JMenuItem("Set amplification threshold (" + this.ampThreshold + ")");
        ampThresholdItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String t2 = MessageUtils.showInputDialog("Amplification threshold  (log2(cn)/2)", String.valueOf(CNFreqTrack.this.ampThreshold));
                try {
                    float threshold = Float.parseFloat(t2);
                    CNFreqTrack.this.setAmpThreshold(threshold);
                    IGV.getInstance().repaintDataPanels();
                }
                catch (NumberFormatException e1) {
                    MessageUtils.showErrorMessage("Amplification threshold must be a number", e1);
                }
            }
        });
        menu.add(ampThresholdItem);
        JMenuItem delThresholdItem = new JMenuItem("Set deletion threshold (" + this.delThreshold + ")");
        delThresholdItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String t2 = MessageUtils.showInputDialog("Deletion threshold  (log2(cn)/2)", String.valueOf(CNFreqTrack.this.delThreshold));
                try {
                    float threshold = Float.parseFloat(t2);
                    CNFreqTrack.this.setDelThreshold(threshold);
                    IGV.getInstance().repaintDataPanels();
                }
                catch (NumberFormatException e1) {
                    MessageUtils.showErrorMessage("Deletion threshold must be a number", e1);
                }
            }
        });
        menu.add(delThresholdItem);
        menu.addSeparator();
        List<Track> selfAsList = Arrays.asList(this);
        TrackMenuUtils.addSharedItems(menu, selfAsList, false, false);
        return menu;
    }

    private static CNFreqTrack getNextTrack() {
        return (CNFreqTrack)IGVSessionReader.getNextTrack();
    }
}

