/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.analysis.BivariateRealFunction;
import org.apache.commons.math.exception.OutOfRangeException;

class BicubicSplineFunction
implements BivariateRealFunction {
    private static final short N = 4;
    private final double[][] a = new double[4][4];
    private BivariateRealFunction partialDerivativeX;
    private BivariateRealFunction partialDerivativeY;
    private BivariateRealFunction partialDerivativeXX;
    private BivariateRealFunction partialDerivativeYY;
    private BivariateRealFunction partialDerivativeXY;

    public BicubicSplineFunction(double[] a2) {
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j2 = 0; j2 < 4; ++j2) {
                this.a[i2][j2] = a2[i2 + 4 * j2];
            }
        }
    }

    public double value(double x2, double y) {
        if (x2 < 0.0 || x2 > 1.0) {
            throw new OutOfRangeException(x2, (Number)0, 1);
        }
        if (y < 0.0 || y > 1.0) {
            throw new OutOfRangeException(y, (Number)0, 1);
        }
        double x22 = x2 * x2;
        double x3 = x22 * x2;
        double[] pX = new double[]{1.0, x2, x22, x3};
        double y2 = y * y;
        double y3 = y2 * y;
        double[] pY = new double[]{1.0, y, y2, y3};
        return this.apply(pX, pY, this.a);
    }

    private double apply(double[] pX, double[] pY, double[][] coeff) {
        double result = 0.0;
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j2 = 0; j2 < 4; ++j2) {
                result += coeff[i2][j2] * pX[i2] * pY[j2];
            }
        }
        return result;
    }

    public BivariateRealFunction partialDerivativeX() {
        if (this.partialDerivativeX == null) {
            this.computePartialDerivatives();
        }
        return this.partialDerivativeX;
    }

    public BivariateRealFunction partialDerivativeY() {
        if (this.partialDerivativeY == null) {
            this.computePartialDerivatives();
        }
        return this.partialDerivativeY;
    }

    public BivariateRealFunction partialDerivativeXX() {
        if (this.partialDerivativeXX == null) {
            this.computePartialDerivatives();
        }
        return this.partialDerivativeXX;
    }

    public BivariateRealFunction partialDerivativeYY() {
        if (this.partialDerivativeYY == null) {
            this.computePartialDerivatives();
        }
        return this.partialDerivativeYY;
    }

    public BivariateRealFunction partialDerivativeXY() {
        if (this.partialDerivativeXY == null) {
            this.computePartialDerivatives();
        }
        return this.partialDerivativeXY;
    }

    private void computePartialDerivatives() {
        final double[][] aX = new double[4][4];
        final double[][] aY = new double[4][4];
        final double[][] aXX = new double[4][4];
        final double[][] aYY = new double[4][4];
        final double[][] aXY = new double[4][4];
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j2 = 0; j2 < 4; ++j2) {
                double c2 = this.a[i2][j2];
                aX[i2][j2] = (double)i2 * c2;
                aY[i2][j2] = (double)j2 * c2;
                aXX[i2][j2] = (double)(i2 - 1) * aX[i2][j2];
                aYY[i2][j2] = (double)(j2 - 1) * aY[i2][j2];
                aXY[i2][j2] = (double)j2 * aX[i2][j2];
            }
        }
        this.partialDerivativeX = new BivariateRealFunction(){

            public double value(double x2, double y) {
                double x22 = x2 * x2;
                double[] pX = new double[]{0.0, 1.0, x2, x22};
                double y2 = y * y;
                double y3 = y2 * y;
                double[] pY = new double[]{1.0, y, y2, y3};
                return BicubicSplineFunction.this.apply(pX, pY, aX);
            }
        };
        this.partialDerivativeY = new BivariateRealFunction(){

            public double value(double x2, double y) {
                double x22 = x2 * x2;
                double x3 = x22 * x2;
                double[] pX = new double[]{1.0, x2, x22, x3};
                double y2 = y * y;
                double[] pY = new double[]{0.0, 1.0, y, y2};
                return BicubicSplineFunction.this.apply(pX, pY, aY);
            }
        };
        this.partialDerivativeXX = new BivariateRealFunction(){

            public double value(double x2, double y) {
                double[] pX = new double[]{0.0, 0.0, 1.0, x2};
                double y2 = y * y;
                double y3 = y2 * y;
                double[] pY = new double[]{1.0, y, y2, y3};
                return BicubicSplineFunction.this.apply(pX, pY, aXX);
            }
        };
        this.partialDerivativeYY = new BivariateRealFunction(){

            public double value(double x2, double y) {
                double x22 = x2 * x2;
                double x3 = x22 * x2;
                double[] pX = new double[]{1.0, x2, x22, x3};
                double[] pY = new double[]{0.0, 0.0, 1.0, y};
                return BicubicSplineFunction.this.apply(pX, pY, aYY);
            }
        };
        this.partialDerivativeXY = new BivariateRealFunction(){

            public double value(double x2, double y) {
                double x22 = x2 * x2;
                double[] pX = new double[]{0.0, 1.0, x2, x22};
                double y2 = y * y;
                double[] pY = new double[]{0.0, 1.0, y, y2};
                return BicubicSplineFunction.this.apply(pX, pY, aXY);
            }
        };
    }
}

