/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.BinaryTagCodec;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.io.CramArray;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.io.LTF8;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

class SliceIO {
    private static final Log log = Log.getInstance(SliceIO.class);

    SliceIO() {
    }

    private static void readSliceHeadBlock(int major, Slice slice, InputStream inputStream) throws IOException {
        slice.headerBlock = Block.readFromInputStream(major, inputStream);
        SliceIO.parseSliceHeaderBlock(major, slice);
    }

    private static void parseSliceHeaderBlock(int major, Slice slice) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(slice.headerBlock.getRawContent());
        slice.sequenceId = ITF8.readUnsignedITF8(inputStream);
        slice.alignmentStart = ITF8.readUnsignedITF8(inputStream);
        slice.alignmentSpan = ITF8.readUnsignedITF8(inputStream);
        slice.nofRecords = ITF8.readUnsignedITF8(inputStream);
        slice.globalRecordCounter = LTF8.readUnsignedLTF8(inputStream);
        slice.nofBlocks = ITF8.readUnsignedITF8(inputStream);
        slice.contentIDs = CramArray.array(inputStream);
        slice.embeddedRefBlockContentID = ITF8.readUnsignedITF8(inputStream);
        slice.refMD5 = new byte[16];
        InputStreamUtils.readFully(inputStream, slice.refMD5, 0, slice.refMD5.length);
        byte[] bytes = InputStreamUtils.readFully(inputStream);
        if (major >= CramVersions.CRAM_v3.major) {
            for (SAMBinaryTagAndValue tags = slice.sliceTags = BinaryTagCodec.readTags(bytes, 0, bytes.length, ValidationStringency.DEFAULT_STRINGENCY); tags != null; tags = tags.getNext()) {
                log.debug(String.format("Found slice tag: %s", SAMTagUtil.getSingleton().makeStringTag(tags.tag)));
            }
        }
    }

    private static byte[] createSliceHeaderBlockContent(int major, Slice slice) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ITF8.writeUnsignedITF8(slice.sequenceId, byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.alignmentStart, byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.alignmentSpan, byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.nofRecords, byteArrayOutputStream);
        LTF8.writeUnsignedLTF8(slice.globalRecordCounter, byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.nofBlocks, byteArrayOutputStream);
        slice.contentIDs = new int[slice.external.size()];
        int i2 = 0;
        for (int id : slice.external.keySet()) {
            slice.contentIDs[i2++] = id;
        }
        CramArray.write(slice.contentIDs, byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.embeddedRefBlockContentID, byteArrayOutputStream);
        byteArrayOutputStream.write(slice.refMD5 == null ? new byte[16] : slice.refMD5);
        if (major >= CramVersions.CRAM_v3.major && slice.sliceTags != null) {
            BinaryCodec binaryCoded = new BinaryCodec(byteArrayOutputStream);
            BinaryTagCodec binaryTagCodec = new BinaryTagCodec(binaryCoded);
            SAMBinaryTagAndValue samBinaryTagAndValue = slice.sliceTags;
            do {
                log.debug("Writing slice tag: " + SAMTagUtil.getSingleton().makeStringTag(samBinaryTagAndValue.tag));
                binaryTagCodec.writeTag(samBinaryTagAndValue.tag, samBinaryTagAndValue.value, samBinaryTagAndValue.isUnsignedArray());
            } while ((samBinaryTagAndValue = samBinaryTagAndValue.getNext()) != null);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static void readSliceBlocks(int major, Slice slice, InputStream inputStream) throws IOException {
        slice.external = new HashMap<Integer, Block>();
        block4: for (int i2 = 0; i2 < slice.nofBlocks; ++i2) {
            Block block = Block.readFromInputStream(major, inputStream);
            switch (block.getContentType()) {
                case CORE: {
                    slice.coreBlock = block;
                    continue block4;
                }
                case EXTERNAL: {
                    if (slice.embeddedRefBlockContentID == block.getContentId()) {
                        slice.embeddedRefBlock = block;
                    }
                    slice.external.put(block.getContentId(), block);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Not a slice block, content type id " + block.getContentType().name());
                }
            }
        }
    }

    public static void write(int major, Slice slice, OutputStream outputStream) throws IOException {
        slice.nofBlocks = 1 + slice.external.size() + (slice.embeddedRefBlock == null ? 0 : 1);
        slice.contentIDs = new int[slice.external.size()];
        boolean i2 = false;
        Iterator<Integer> iterator = slice.external.keySet().iterator();
        while (iterator.hasNext()) {
            int id;
            slice.contentIDs[0] = id = iterator.next().intValue();
        }
        slice.headerBlock = Block.buildNewSliceHeaderBlock(SliceIO.createSliceHeaderBlockContent(major, slice));
        slice.headerBlock.write(major, outputStream);
        slice.coreBlock.write(major, outputStream);
        for (Block block : slice.external.values()) {
            block.write(major, outputStream);
        }
    }

    public static void read(int major, Slice slice, InputStream inputStream) throws IOException {
        SliceIO.readSliceHeadBlock(major, slice, inputStream);
        SliceIO.readSliceBlocks(major, slice, inputStream);
    }
}

