/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import java.util.Arrays;
import org.bson.util.annotations.Immutable;

@Immutable
public final class MongoCredential {
    public static final String GSSAPI_MECHANISM = "GSSAPI";
    public static final String MONGODB_CR_MECHANISM = "MONGODB-CR";
    private final String mechanism;
    private final String userName;
    private final String source;
    private final char[] password;

    public static MongoCredential createMongoCRCredential(String userName, String database, char[] password) {
        return new MongoCredential(MONGODB_CR_MECHANISM, userName, database, password);
    }

    public static MongoCredential createGSSAPICredential(String userName) {
        return new MongoCredential(GSSAPI_MECHANISM, userName, "$external", null);
    }

    MongoCredential(String mechanism, String userName, String source, char[] password) {
        if (mechanism == null) {
            throw new IllegalArgumentException("mechanism can not be null");
        }
        if (userName == null) {
            throw new IllegalArgumentException("username can not be null");
        }
        if (mechanism.equals(MONGODB_CR_MECHANISM) && password == null) {
            throw new IllegalArgumentException("Password can not be null for MONGODB-CR mechanism");
        }
        if (mechanism.equals(GSSAPI_MECHANISM) && password != null) {
            throw new IllegalArgumentException("Password must be null for the GSSAPI mechanism");
        }
        this.mechanism = mechanism;
        this.userName = userName;
        this.source = source;
        this.password = password != null ? (char[])password.clone() : null;
    }

    public String getMechanism() {
        return this.mechanism;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSource() {
        return this.source;
    }

    public char[] getPassword() {
        if (this.password == null) {
            return null;
        }
        return (char[])this.password.clone();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        MongoCredential that = (MongoCredential)o2;
        if (!this.mechanism.equals(that.mechanism)) {
            return false;
        }
        if (!Arrays.equals(this.password, that.password)) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        return this.userName.equals(that.userName);
    }

    public int hashCode() {
        int result = this.mechanism.hashCode();
        result = 31 * result + this.userName.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + (this.password != null ? Arrays.hashCode(this.password) : 0);
        return result;
    }

    public String toString() {
        return "MongoCredential{mechanism='" + this.mechanism + '\'' + ", userName='" + this.userName + '\'' + ", source='" + this.source + '\'' + ", password=<hidden>" + '}';
    }
}

