/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.Arrays;
import org.broad.igv.sam.FlowSignalContext;
import org.broad.igv.sam.SAMAlignment;

public class FlowSignalContextBuilder {
    private short[] flowSignals = null;
    private String flowOrder = null;
    private int flowSignalsIndex = -1;
    private int flowOrderIndex = -1;
    private int prevFlowSignalsStart = -1;
    private int prevFlowSignalsEnd = -1;
    private int flowOrderStart = -1;
    private boolean readNegativeStrandFlag;
    private boolean[] incorporations = null;
    public static final int PREV = 0;
    public static final int CURR = 1;
    public static final int NEXT = 2;

    public FlowSignalContextBuilder(short[] flowSignals, String flowOrder, int flowOrderStart, byte[] readBases, int fromIdx, boolean readNegativeStrandFlag) {
        if (null == flowSignals || null == flowOrder || flowOrderStart < 0) {
            return;
        }
        this.flowSignals = flowSignals;
        this.flowOrder = flowOrder;
        this.flowOrderIndex = this.flowOrderStart = flowOrderStart;
        this.flowSignalsIndex = 0;
        this.readNegativeStrandFlag = readNegativeStrandFlag;
        if (this.readNegativeStrandFlag) {
            this.incorporations = new boolean[this.flowSignals.length];
            for (int i2 = readBases.length - 1; 0 <= i2; --i2) {
                while (this.flowOrder.charAt(this.flowOrderIndex) != SAMAlignment.NT2COMP[readBases[i2]]) {
                    ++this.flowOrderIndex;
                    ++this.flowSignalsIndex;
                    this.incorporations[this.flowSignalsIndex] = false;
                    if (this.flowOrder.length() > this.flowOrderIndex) continue;
                    this.flowOrderIndex = 0;
                }
                this.incorporations[this.flowSignalsIndex] = true;
            }
            this.prevFlowSignalsStart = this.flowSignalsIndex + 1;
            this.prevFlowSignalsEnd = this.flowSignals.length - 1;
        } else {
            this.prevFlowSignalsEnd = 0;
            this.prevFlowSignalsStart = 0;
            while (this.flowOrder.charAt(this.flowOrderIndex) != readBases[0]) {
                ++this.flowOrderIndex;
                ++this.flowSignalsIndex;
                if (this.flowOrder.length() > this.flowOrderIndex) continue;
                this.flowOrderIndex = 0;
            }
            this.prevFlowSignalsEnd = this.flowSignalsIndex - 1;
        }
    }

    public FlowSignalContext getFlowSignalContext(byte[] readBases, int fromIdx, int nBases) {
        Object blockFlowSignals = null;
        Object blockFlowOrder = null;
        if (null == this.flowSignals) {
            return null;
        }
        blockFlowSignals = new short[nBases][][];
        blockFlowOrder = new char[nBases][][];
        Arrays.fill((Object[])blockFlowSignals, null);
        Arrays.fill((Object[])blockFlowOrder, null);
        int i2 = fromIdx;
        int idx = 0;
        int[] flowOrderIndices = new int[nBases];
        while (0 <= this.flowSignalsIndex && this.flowSignalsIndex < this.flowSignals.length && i2 < fromIdx + nBases) {
            int flowpos;
            short s2 = this.flowSignals[this.flowSignalsIndex];
            char f2 = this.flowOrder.charAt((this.flowSignalsIndex + this.flowOrderStart) % this.flowOrder.length());
            flowOrderIndices[idx] = this.flowSignalsIndex + this.flowOrderStart;
            int nextFlowSignalsStart = -1;
            int nextFlowSignalsEnd = -1;
            int basepos = i2 + 1;
            if (basepos < readBases.length) {
                if (this.readNegativeStrandFlag) {
                    nextFlowSignalsEnd = this.flowSignalsIndex - 1;
                    while (!this.incorporations[this.flowSignalsIndex] || this.flowOrder.charAt(this.flowOrderIndex) != SAMAlignment.NT2COMP[readBases[basepos]]) {
                        --this.flowOrderIndex;
                        --this.flowSignalsIndex;
                        if (this.flowOrderIndex >= 0) continue;
                        this.flowOrderIndex = this.flowOrder.length() - 1;
                    }
                    nextFlowSignalsStart = this.flowSignalsIndex + 1;
                } else {
                    nextFlowSignalsStart = this.flowSignalsIndex + 1;
                    while (this.flowOrder.charAt(this.flowOrderIndex) != readBases[basepos]) {
                        ++this.flowOrderIndex;
                        ++this.flowSignalsIndex;
                        if (this.flowOrder.length() > this.flowOrderIndex) continue;
                        this.flowOrderIndex = 0;
                    }
                    nextFlowSignalsEnd = this.flowSignalsIndex - 1;
                }
            }
            blockFlowSignals[idx] = new short[3][];
            blockFlowOrder[idx] = new char[3][];
            if (0 <= this.prevFlowSignalsStart && this.prevFlowSignalsStart <= this.prevFlowSignalsEnd && this.prevFlowSignalsEnd < this.flowSignals.length) {
                blockFlowSignals[idx][0] = new short[this.prevFlowSignalsEnd - this.prevFlowSignalsStart + 1];
                blockFlowOrder[idx][0] = new char[this.prevFlowSignalsEnd - this.prevFlowSignalsStart + 1];
                if (this.readNegativeStrandFlag) {
                    for (flowpos = this.prevFlowSignalsEnd; this.prevFlowSignalsStart <= flowpos; --flowpos) {
                        blockFlowSignals[idx][0][this.prevFlowSignalsEnd - flowpos] = this.flowSignals[flowpos];
                        blockFlowOrder[idx][0][this.prevFlowSignalsEnd - flowpos] = this.flowOrder.charAt((flowpos + this.flowOrderStart) % this.flowOrder.length());
                    }
                } else {
                    for (flowpos = this.prevFlowSignalsStart; flowpos <= this.prevFlowSignalsEnd; ++flowpos) {
                        blockFlowSignals[idx][0][flowpos - this.prevFlowSignalsStart] = this.flowSignals[flowpos];
                        blockFlowOrder[idx][0][flowpos - this.prevFlowSignalsStart] = this.flowOrder.charAt((flowpos + this.flowOrderStart) % this.flowOrder.length());
                    }
                }
            } else {
                blockFlowSignals[idx][0] = null;
                blockFlowOrder[idx][0] = null;
            }
            blockFlowSignals[idx][1] = new short[1];
            blockFlowOrder[idx][1] = new char[1];
            blockFlowSignals[idx][1][0] = s2;
            blockFlowOrder[idx][1][0] = f2;
            if (0 <= nextFlowSignalsStart && nextFlowSignalsStart <= nextFlowSignalsEnd && nextFlowSignalsEnd < this.flowSignals.length) {
                blockFlowSignals[idx][2] = new short[nextFlowSignalsEnd - nextFlowSignalsStart + 1];
                blockFlowOrder[idx][2] = new char[nextFlowSignalsEnd - nextFlowSignalsStart + 1];
                if (this.readNegativeStrandFlag) {
                    for (flowpos = nextFlowSignalsEnd; nextFlowSignalsStart <= flowpos; --flowpos) {
                        blockFlowSignals[idx][2][nextFlowSignalsEnd - flowpos] = this.flowSignals[flowpos];
                        blockFlowOrder[idx][2][nextFlowSignalsEnd - flowpos] = this.flowOrder.charAt((flowpos + this.flowOrderStart) % this.flowOrder.length());
                    }
                } else {
                    for (flowpos = nextFlowSignalsStart; flowpos <= nextFlowSignalsEnd; ++flowpos) {
                        blockFlowSignals[idx][2][flowpos - nextFlowSignalsStart] = this.flowSignals[flowpos];
                        blockFlowOrder[idx][2][flowpos - nextFlowSignalsStart] = this.flowOrder.charAt((flowpos + this.flowOrderStart) % this.flowOrder.length());
                    }
                }
            } else {
                blockFlowSignals[idx][2] = null;
                blockFlowOrder[idx][2] = null;
            }
            this.prevFlowSignalsStart = nextFlowSignalsStart;
            this.prevFlowSignalsEnd = nextFlowSignalsEnd;
            ++i2;
            ++idx;
        }
        return new FlowSignalContext((short[][][])blockFlowSignals, (char[][][])blockFlowOrder, flowOrderIndices);
    }
}

