/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import org.broad.igv.feature.IGVFeature;

public class ExpressionProbe
implements Comparable {
    private String featureName;
    private String probe;
    private String chr = "";
    private int start = 0;
    private int end = 0;

    public ExpressionProbe(String probe) {
        this.probe = probe;
        this.featureName = probe;
    }

    public ExpressionProbe(String probe, String feature) {
        this.probe = probe;
        this.featureName = feature;
    }

    public ExpressionProbe(IGVFeature feature) {
        this(feature.getName());
        this.chr = feature.getChr();
        this.start = feature.getStart();
        this.end = feature.getEnd();
    }

    public String getFeature() {
        return this.featureName;
    }

    public String getName() {
        return this.probe;
    }

    public void setProbe(String probe) {
        this.probe = probe;
    }

    public String getChr() {
        return this.chr;
    }

    public void setChr(String chr) {
        this.chr = chr;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String toString() {
        return this.probe + " " + this.chr + ":" + this.start + "-" + this.end;
    }

    public int compareTo(Object anotherProbe) {
        if (anotherProbe instanceof ExpressionProbe) {
            return this.getStart() - ((ExpressionProbe)anotherProbe).getStart();
        }
        return 0;
    }
}

