/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BPTreeChildNode;
import org.broad.igv.bbfile.BPTreeChildNodeItem;
import org.broad.igv.bbfile.BPTreeHeader;
import org.broad.igv.bbfile.BPTreeLeafNode;
import org.broad.igv.bbfile.BPTreeLeafNodeItem;
import org.broad.igv.bbfile.BPTreeNode;

public class BPTree {
    private static Logger log = Logger.getLogger(BPTree.class);
    public static final int BPTREE_NODE_FORMAT_SIZE = 4;
    public static final int BPTREE_NODE_ITEM_SIZE = 8;
    private SeekableStream fis;
    private long treeOffset;
    private BPTreeHeader treeHeader;
    private int blockSize;
    private int keySize;
    private int valueSize;
    private long itemCount;
    private BPTreeNode rootNode;
    private long nodeCount;
    private long leafCount;
    Map<String, String> chromosomeKeyCache = new HashMap<String, String>();

    public BPTree(SeekableStream fis, long fileOffset, boolean isLowToHigh) {
        this.fis = fis;
        this.treeOffset = fileOffset;
        this.treeHeader = new BPTreeHeader(this.fis, this.treeOffset, isLowToHigh);
        if (!this.treeHeader.isHeaderOK()) {
            int badMagic = this.treeHeader.getMagic();
            log.error("Error reading B+ tree header: bad magic = " + badMagic);
            throw new RuntimeException("Error reading B+ tree header: bad magic = " + badMagic);
        }
        this.blockSize = this.treeHeader.getBlockSize();
        this.keySize = this.treeHeader.getKeySize();
        this.valueSize = this.treeHeader.getValSize();
        this.itemCount = this.treeHeader.getItemCount();
        long nodeOffset = this.treeOffset + 32L;
        BPTreeNode parentNode = null;
        this.rootNode = this.readBPTreeNode(this.fis, nodeOffset, parentNode, isLowToHigh);
    }

    public SeekableStream getFis() {
        return this.fis;
    }

    public long getBPTreeOffset() {
        return this.treeOffset;
    }

    public BPTreeHeader getTreeHeader() {
        return this.treeHeader;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getValueSize() {
        return this.valueSize;
    }

    public long getItemCount() {
        return this.itemCount;
    }

    public long getNodeCount() {
        return this.nodeCount;
    }

    public BPTreeNode getRootNode() {
        return this.rootNode;
    }

    public String getChromosomeKey(String chromosome) {
        String key = this.chromosomeKeyCache.get(chromosome);
        if (key == null) {
            key = chromosome.length() <= this.keySize ? chromosome : chromosome.substring(0, this.keySize);
            this.chromosomeKeyCache.put(chromosome, key);
        }
        return key;
    }

    public int getChromosomeID(String chromKey) {
        BPTreeNode thisNode = this.rootNode;
        int chromosomeID = this.findChromosomeID(thisNode, chromKey);
        return chromosomeID;
    }

    public String getChromosomeName(int chromID) {
        BPTreeNode thisNode = this.rootNode;
        String chromKey = this.findChromosomeName(thisNode, chromID);
        return chromKey;
    }

    public ArrayList<String> getChromosomeNames() {
        BPTreeNode thisNode = this.rootNode;
        ArrayList<String> chromosomeList = new ArrayList<String>();
        this.findAllChromosomeNames(thisNode, chromosomeList);
        return chromosomeList;
    }

    public HashMap<Integer, String> getChromosomeIDMap(int startChromID, int endChromID) {
        BPTreeNode thisNode = this.rootNode;
        HashMap<Integer, String> chromosomeIDMap = new HashMap<Integer, String>();
        this.findChromosomeMap(thisNode, startChromID, endChromID, chromosomeIDMap);
        return chromosomeIDMap;
    }

    public void print() {
        if (!this.treeHeader.isHeaderOK()) {
            int badMagic = this.treeHeader.getMagic();
            log.error("Error reading B+ tree header: bad magic = " + badMagic);
            return;
        }
        this.treeHeader.print();
        if (this.rootNode != null) {
            this.rootNode.printItems();
        }
    }

    private int findChromosomeID(BPTreeNode thisNode, String chromKey) {
        int chromID = -1;
        if (thisNode.isLeaf()) {
            int nLeaves = thisNode.getItemCount();
            for (int index = 0; index < nLeaves; ++index) {
                BPTreeLeafNodeItem leaf = (BPTreeLeafNodeItem)thisNode.getItem(index);
                if (leaf == null) {
                    log.error("Error finding B+ tree leaf nodes, corruption suspected");
                    throw new RuntimeException("Error reading B+ tree leaf nodes, corruption suspected");
                }
                if (!leaf.chromKeysMatch(chromKey)) continue;
                chromID = leaf.getChromID();
                break;
            }
        } else {
            int nNodes = thisNode.getItemCount();
            for (int index = 0; index < nNodes; ++index) {
                BPTreeChildNodeItem childItem = (BPTreeChildNodeItem)thisNode.getItem(index);
                BPTreeNode childNode = childItem.getChildNode();
                String lowestKey = childNode.getLowestChromKey();
                String highestKey = childNode.getHighestChromKey();
                if (chromKey.compareTo(lowestKey) < 0 || chromKey.compareTo(highestKey) > 0 || (chromID = this.findChromosomeID(childNode, chromKey)) < 0) {
                    continue;
                }
                break;
            }
        }
        return chromID;
    }

    private String findChromosomeName(BPTreeNode thisNode, int chromID) {
        String chromKey = null;
        if (thisNode.isLeaf()) {
            int nLeaves = thisNode.getItemCount();
            for (int index = 0; index < nLeaves; ++index) {
                BPTreeLeafNodeItem leaf = (BPTreeLeafNodeItem)thisNode.getItem(index);
                if (leaf.getChromID() != chromID) continue;
                chromKey = leaf.getChromKey();
                break;
            }
        } else {
            int nNodes = thisNode.getItemCount();
            for (int index = 0; index < nNodes; ++index) {
                BPTreeChildNodeItem childItem = (BPTreeChildNodeItem)thisNode.getItem(index);
                BPTreeNode childNode = childItem.getChildNode();
                int lowestID = childNode.getLowestChromID();
                int highestID = childNode.getHighestChromID();
                if (chromID < lowestID || chromID > highestID || (chromKey = this.findChromosomeName(childNode, chromID)) == null) {
                    continue;
                }
                break;
            }
        }
        return chromKey;
    }

    public void findAllChromosomeNames(BPTreeNode thisNode, ArrayList<String> chromosomeList) {
        if (thisNode.isLeaf()) {
            int nLeaves = thisNode.getItemCount();
            for (int index = 0; index < nLeaves; ++index) {
                BPTreeLeafNodeItem leaf = (BPTreeLeafNodeItem)thisNode.getItem(index);
                chromosomeList.add(leaf.getChromKey());
            }
        } else {
            int nNodes = thisNode.getItemCount();
            for (int index = 0; index < nNodes; ++index) {
                BPTreeChildNodeItem childItem = (BPTreeChildNodeItem)thisNode.getItem(index);
                BPTreeNode childNode = childItem.getChildNode();
                this.findAllChromosomeNames(childNode, chromosomeList);
            }
        }
    }

    private void findChromosomeMap(BPTreeNode thisNode, int startChromID, int endChromID, HashMap<Integer, String> chromosomeMap) {
        int lowestID = thisNode.getLowestChromID();
        if (lowestID > endChromID) {
            return;
        }
        int highestID = thisNode.getHighestChromID();
        if (highestID < startChromID) {
            return;
        }
        if (thisNode.isLeaf()) {
            int nLeaves = thisNode.getItemCount();
            for (int index = 0; index < nLeaves; ++index) {
                BPTreeLeafNodeItem leaf = (BPTreeLeafNodeItem)thisNode.getItem(index);
                int chromID = leaf.getChromID();
                if (chromID >= startChromID && chromID <= endChromID) {
                    chromosomeMap.put(chromID, leaf.getChromKey());
                    continue;
                }
                if (chromID <= endChromID) {
                    continue;
                }
                break;
            }
        } else {
            int nNodes = thisNode.getItemCount();
            for (int index = 0; index < nNodes; ++index) {
                BPTreeChildNodeItem childItem = (BPTreeChildNodeItem)thisNode.getItem(index);
                BPTreeNode childNode = childItem.getChildNode();
                lowestID = childNode.getLowestChromID();
                highestID = childNode.getHighestChromID();
                if (lowestID <= endChromID && highestID >= startChromID) {
                    this.findChromosomeMap(childNode, startChromID, endChromID, chromosomeMap);
                    continue;
                }
                if (lowestID <= endChromID) {
                    continue;
                }
                break;
            }
        }
    }

    private BPTreeNode readBPTreeNode(SeekableStream fis, long fileOffset, BPTreeNode parent, boolean isLowToHigh) {
        LittleEndianInputStream lbdis = null;
        DataInputStream bdis = null;
        byte[] buffer = new byte[4];
        BPTreeNode thisNode = null;
        BPTreeNode childNode = null;
        try {
            int itemCount;
            byte bval;
            boolean isLeaf;
            fis.seek(fileOffset);
            fis.readFully(buffer);
            if (isLowToHigh) {
                lbdis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
            } else {
                bdis = new DataInputStream(new ByteArrayInputStream(buffer));
            }
            byte type = isLowToHigh ? lbdis.readByte() : bdis.readByte();
            if (type == 1) {
                isLeaf = true;
                thisNode = new BPTreeLeafNode(++this.nodeCount);
            } else {
                isLeaf = false;
                thisNode = new BPTreeChildNode(++this.nodeCount);
            }
            if (isLowToHigh) {
                bval = lbdis.readByte();
                itemCount = lbdis.readShort();
            } else {
                bval = bdis.readByte();
                itemCount = bdis.readShort();
            }
            int itemSize = 8 + this.keySize;
            int totalSize = itemSize * itemCount;
            byte[] itemBuffer = new byte[totalSize];
            fis.readFully(itemBuffer);
            if (isLowToHigh) {
                lbdis = new LittleEndianInputStream(new ByteArrayInputStream(itemBuffer));
            } else {
                bdis = new DataInputStream(new ByteArrayInputStream(itemBuffer));
            }
            for (int item = 0; item < itemCount; ++item) {
                char[] keychars = new char[this.keySize];
                for (int index = 0; index < this.keySize; ++index) {
                    bval = isLowToHigh ? lbdis.readByte() : bdis.readByte();
                    keychars[index] = (char)bval;
                }
                String key = new String(keychars).trim();
                if (isLeaf) {
                    int chromSize;
                    int chromID;
                    if (isLowToHigh) {
                        chromID = lbdis.readInt();
                        chromSize = lbdis.readInt();
                    } else {
                        chromID = bdis.readInt();
                        chromSize = bdis.readInt();
                    }
                    BPTreeLeafNodeItem leafItem = new BPTreeLeafNodeItem(++this.leafCount, key, chromID, chromSize);
                    thisNode.insertItem(leafItem);
                } else {
                    long childOffset = isLowToHigh ? lbdis.readLong() : bdis.readLong();
                    childNode = this.readBPTreeNode(this.fis, childOffset, thisNode, isLowToHigh);
                    BPTreeChildNodeItem childItem = new BPTreeChildNodeItem(item, key, childNode);
                    thisNode.insertItem(childItem);
                }
                fileOffset += (long)itemSize;
            }
        }
        catch (IOException ex) {
            log.error("Error reading B+ tree node " + ex);
            throw new RuntimeException("Error reading B+ tree node \n ", ex);
        }
        return thisNode;
    }
}

