/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.transform;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.transform.FastFourierTransformer;
import org.apache.commons.math.transform.RealTransformer;

public class FastHadamardTransformer
implements RealTransformer {
    public double[] transform(double[] f2) throws IllegalArgumentException {
        return this.fht(f2);
    }

    public double[] transform(UnivariateRealFunction f2, double min, double max, int n2) throws FunctionEvaluationException, IllegalArgumentException {
        return this.fht(FastFourierTransformer.sample(f2, min, max, n2));
    }

    public double[] inversetransform(double[] f2) throws IllegalArgumentException {
        return FastFourierTransformer.scaleArray(this.fht(f2), 1.0 / (double)f2.length);
    }

    public double[] inversetransform(UnivariateRealFunction f2, double min, double max, int n2) throws FunctionEvaluationException, IllegalArgumentException {
        double[] unscaled = this.fht(FastFourierTransformer.sample(f2, min, max, n2));
        return FastFourierTransformer.scaleArray(unscaled, 1.0 / (double)n2);
    }

    public int[] transform(int[] f2) throws IllegalArgumentException {
        return this.fht(f2);
    }

    protected double[] fht(double[] x2) throws IllegalArgumentException {
        int n2 = x2.length;
        int halfN = n2 / 2;
        if (!FastFourierTransformer.isPowerOf2(n2)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO, n2);
        }
        double[] yPrevious = new double[n2];
        double[] yCurrent = (double[])x2.clone();
        for (int j2 = 1; j2 < n2; j2 <<= 1) {
            int twoI;
            int i2;
            double[] yTmp = yCurrent;
            yCurrent = yPrevious;
            yPrevious = yTmp;
            for (i2 = 0; i2 < halfN; ++i2) {
                twoI = 2 * i2;
                yCurrent[i2] = yPrevious[twoI] + yPrevious[twoI + 1];
            }
            for (i2 = halfN; i2 < n2; ++i2) {
                twoI = 2 * i2;
                yCurrent[i2] = yPrevious[twoI - n2] - yPrevious[twoI - n2 + 1];
            }
        }
        return yCurrent;
    }

    protected int[] fht(int[] x2) throws IllegalArgumentException {
        int n2 = x2.length;
        int halfN = n2 / 2;
        if (!FastFourierTransformer.isPowerOf2(n2)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO, n2);
        }
        int[] yPrevious = new int[n2];
        int[] yCurrent = (int[])x2.clone();
        for (int j2 = 1; j2 < n2; j2 <<= 1) {
            int twoI;
            int i2;
            int[] yTmp = yCurrent;
            yCurrent = yPrevious;
            yPrevious = yTmp;
            for (i2 = 0; i2 < halfN; ++i2) {
                twoI = 2 * i2;
                yCurrent[i2] = yPrevious[twoI] + yPrevious[twoI + 1];
            }
            for (i2 = halfN; i2 < n2; ++i2) {
                twoI = 2 * i2;
                yCurrent[i2] = yPrevious[twoI - n2] - yPrevious[twoI - n2 + 1];
            }
        }
        return yCurrent;
    }
}

