/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.linear;

import htsjdk.tribble.index.AbstractIndex;
import htsjdk.tribble.index.Block;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.util.LittleEndianInputStream;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LinearIndex
extends AbstractIndex {
    public static final double MAX_FEATURES_PER_BIN = Double.valueOf(System.getProperty("MAX_FEATURES_PER_BIN", "100"));
    public static final int INDEX_TYPE = AbstractIndex.IndexType.LINEAR.fileHeaderTypeIdentifier;
    private static final int MAX_BIN_WIDTH = 1000000000;
    private static final long MAX_BIN_WIDTH_FOR_OCCUPIED_CHR_INDEX = Long.valueOf(System.getProperty("MAX_BIN_WIDTH_FOR_OCCUPIED_CHR_INDEX", "1024000"));
    public static boolean enableAdaptiveIndexing = true;

    public LinearIndex(List<ChrIndex> indices, File featureFile) {
        super(featureFile.getAbsolutePath());
        for (ChrIndex index : indices) {
            this.chrIndices.put(index.getName(), index);
        }
    }

    private LinearIndex(LinearIndex parent, List<ChrIndex> indices) {
        super(parent);
        for (ChrIndex index : indices) {
            this.chrIndices.put(index.getName(), index);
        }
    }

    public LinearIndex(String featureFile) {
        super(featureFile);
    }

    public LinearIndex(InputStream inputStream) throws IOException {
        LittleEndianInputStream dis = new LittleEndianInputStream(inputStream);
        this.validateIndexHeader(INDEX_TYPE, dis);
        this.read(dis);
    }

    @Override
    public boolean isCurrentVersion() {
        if (!super.isCurrentVersion()) {
            return false;
        }
        for (htsjdk.tribble.index.ChrIndex chrIndex : this.chrIndices.values()) {
            if (!((ChrIndex)chrIndex).OLD_V3_INDEX) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int getType() {
        return INDEX_TYPE;
    }

    @Override
    public List<String> getSequenceNames() {
        return this.chrIndices == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(new ArrayList(this.chrIndices.keySet()));
    }

    @Override
    public Class getChrIndexClass() {
        return ChrIndex.class;
    }

    public Index optimize(double threshold) {
        if (enableAdaptiveIndexing) {
            ArrayList<ChrIndex> newIndices = new ArrayList<ChrIndex>(this.chrIndices.size());
            for (String name : this.chrIndices.keySet()) {
                ChrIndex oldIdx = (ChrIndex)this.chrIndices.get(name);
                ChrIndex newIdx = oldIdx.optimize(threshold);
                newIndices.add(newIdx);
            }
            return new LinearIndex(this, newIndices);
        }
        return this;
    }

    public Index optimize() {
        return this.optimize(MAX_FEATURES_PER_BIN);
    }

    public void writeTable(PrintStream out) {
        out.printf("chr binWidth avg.feature.size nFeatures.total block.id start.pos size nFeatures%n", new Object[0]);
        for (String name : this.chrIndices.keySet()) {
            ChrIndex chrIdx = (ChrIndex)this.chrIndices.get(name);
            int blockCount = 0;
            for (Block b2 : chrIdx.getBlocks()) {
                out.printf("%s %d %.2f %d %d %d %d %d%n", name, chrIdx.binWidth, chrIdx.getAverageFeatureSize(), chrIdx.getNFeatures(), blockCount, blockCount * chrIdx.binWidth, b2.getSize(), (int)((double)b2.getSize() / chrIdx.getAverageFeatureSize()));
                ++blockCount;
            }
        }
    }

    protected final void setTS(long ts) {
        this.indexedFileTS = ts;
    }

    public static class ChrIndex
    implements htsjdk.tribble.index.ChrIndex {
        private String name = "";
        private int binWidth;
        private int longestFeature;
        private int nFeatures;
        private List<Block> blocks;
        private boolean OLD_V3_INDEX = false;

        public ChrIndex() {
        }

        ChrIndex(String name, int binWidth) {
            this.name = name;
            this.binWidth = binWidth;
            this.blocks = new ArrayList<Block>(100);
            this.longestFeature = 0;
            this.nFeatures = 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        void addBlock(Block block) {
            this.blocks.add(block);
        }

        public int getNBlocks() {
            return this.blocks.size();
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }

        @Override
        public List<Block> getBlocks(int start, int end) {
            if (this.blocks.isEmpty()) {
                return Collections.emptyList();
            }
            int adjustedPosition = Math.max(start - this.longestFeature, 0);
            int startBinNumber = adjustedPosition / this.binWidth;
            if (startBinNumber >= this.blocks.size()) {
                return Collections.emptyList();
            }
            int endBinNumber = Math.min((end - 1) / this.binWidth, this.blocks.size() - 1);
            long startPos = this.blocks.get(startBinNumber).getStartPosition();
            long endPos = this.blocks.get(endBinNumber).getStartPosition() + this.blocks.get(endBinNumber).getSize();
            long size = endPos - startPos;
            if (size == 0L) {
                return Collections.EMPTY_LIST;
            }
            Block mergedBlock = new Block(startPos, size);
            return Arrays.asList(mergedBlock);
        }

        public void updateLongestFeature(int featureLength) {
            this.longestFeature = Math.max(this.longestFeature, featureLength);
        }

        public int getNFeatures() {
            return this.nFeatures;
        }

        public void incrementFeatureCount() {
            ++this.nFeatures;
        }

        @Override
        public void write(LittleEndianOutputStream dos) throws IOException {
            dos.writeString(this.name);
            dos.writeInt(this.binWidth);
            dos.writeInt(this.blocks.size());
            dos.writeInt(this.longestFeature);
            dos.writeInt(0);
            dos.writeInt(this.nFeatures);
            long pos = 0L;
            long size = 0L;
            for (Block block : this.blocks) {
                pos = block.getStartPosition();
                size = block.getSize();
                dos.writeLong(pos);
            }
            dos.writeLong(pos + size);
        }

        @Override
        public void read(LittleEndianInputStream dis) throws IOException {
            this.name = dis.readString();
            this.binWidth = dis.readInt();
            int nBins = dis.readInt();
            this.longestFeature = dis.readInt();
            this.OLD_V3_INDEX = dis.readInt() > 0;
            this.nFeatures = dis.readInt();
            this.blocks = new ArrayList<Block>(nBins);
            long pos = dis.readLong();
            for (int binNumber = 0; binNumber < nBins; ++binNumber) {
                long nextPos = dis.readLong();
                long size = nextPos - pos;
                this.blocks.add(new Block(pos, size));
                pos = nextPos;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ChrIndex)) {
                return false;
            }
            ChrIndex other = (ChrIndex)obj;
            return this.binWidth == other.binWidth && this.longestFeature == other.longestFeature && this.nFeatures == other.nFeatures && this.name.equals(other.name) && this.blocks.equals(other.blocks);
        }

        public long getTotalSize() {
            long n2 = 0L;
            for (Block b2 : this.getBlocks()) {
                n2 += b2.getSize();
            }
            return n2;
        }

        public double getAverageFeatureSize() {
            return 1.0 * (double)this.getTotalSize() / (double)this.getNFeatures();
        }

        public double getFeaturesPerBlock() {
            return 1.0 * (double)this.getNFeatures() / (double)this.getNBlocks();
        }

        private double getNFeaturesOfMostDenseBlock(double featureSize) {
            double m2 = -1.0;
            for (Block b2 : this.getBlocks()) {
                double n2 = (double)b2.getSize() / featureSize;
                if (m2 != -1.0 && !(n2 > m2)) continue;
                m2 = n2;
            }
            return m2;
        }

        private double optimizeScore() {
            return this.getNFeaturesOfMostDenseBlock(this.getAverageFeatureSize());
        }

        public ChrIndex optimize(double threshold) {
            return ChrIndex.optimize(this, threshold, 0);
        }

        private static boolean badBinWidth(ChrIndex idx) {
            if (idx.binWidth > 1000000000 || idx.binWidth < 0) {
                return true;
            }
            return MAX_BIN_WIDTH_FOR_OCCUPIED_CHR_INDEX != 0L && idx.getNFeatures() > 1 && (long)idx.binWidth > MAX_BIN_WIDTH_FOR_OCCUPIED_CHR_INDEX;
        }

        private static ChrIndex optimize(ChrIndex idx, double threshold, int level) {
            double score;
            ChrIndex best = idx;
            while (!((score = idx.optimizeScore()) > threshold) && idx.getNBlocks() != 1 && !ChrIndex.badBinWidth(idx)) {
                best = idx;
                idx = ChrIndex.mergeBlocks(idx);
                if (++level <= 30) continue;
                throw new IllegalStateException("Too many iterations");
            }
            return best;
        }

        private static ChrIndex mergeBlocks(ChrIndex idx) {
            ChrIndex merged = new ChrIndex(idx.name, idx.binWidth * 2);
            merged.longestFeature = idx.longestFeature;
            merged.nFeatures = idx.nFeatures;
            Iterator<Block> blocks = idx.getBlocks().iterator();
            if (!blocks.hasNext()) {
                throw new IllegalStateException("Block iterator cannot be empty at the start for " + idx.getName());
            }
            while (blocks.hasNext()) {
                Block b2;
                Block b1 = blocks.next();
                Block block = b2 = blocks.hasNext() ? blocks.next() : null;
                if (b2 == null) {
                    merged.addBlock(b1);
                    continue;
                }
                merged.addBlock(new Block(b1.getStartPosition(), b1.getSize() + b2.getSize()));
            }
            return merged;
        }

        private static String dupString(char c2, int nCopies) {
            char[] chars = new char[nCopies];
            Arrays.fill(chars, c2);
            return new String(chars);
        }
    }
}

