/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.SQTagUtil;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;

public class SAMRecordUtil {
    private static final short[] STRING_TAGS_TO_REVERSE = new short[]{SAMTagUtil.getSingleton().U2, SAMTagUtil.getSingleton().OQ};

    public static void reverseComplement(SAMRecord rec) {
        String e2TagValue;
        byte[] readBases = rec.getReadBases();
        SequenceUtil.reverseComplement(readBases);
        rec.setReadBases(readBases);
        byte[] qualities = rec.getBaseQualities();
        SAMRecordUtil.reverseArray(qualities);
        rec.setBaseQualities(qualities);
        byte[] sqTagValue = (byte[])rec.getAttribute(SAMTagUtil.getSingleton().SQ);
        if (sqTagValue != null) {
            SQTagUtil.reverseComplementSqArray(sqTagValue);
            rec.setAttribute(SAMTagUtil.getSingleton().SQ, (Object)sqTagValue);
        }
        if ((e2TagValue = (String)rec.getAttribute(SAMTagUtil.getSingleton().E2)) != null) {
            byte[] secondaryBases = StringUtil.stringToBytes(e2TagValue);
            SequenceUtil.reverseComplement(secondaryBases);
            rec.setAttribute(SAMTagUtil.getSingleton().E2, (Object)StringUtil.bytesToString(secondaryBases));
        }
        for (short stringTag : STRING_TAGS_TO_REVERSE) {
            String value = (String)rec.getAttribute(stringTag);
            if (value == null) continue;
            rec.setAttribute(stringTag, (Object)StringUtil.reverseString(value));
        }
    }

    public static void reverseArray(byte[] array) {
        int lastIndex = array.length - 1;
        int i2 = 0;
        for (int j2 = lastIndex; i2 < j2; ++i2, --j2) {
            byte tmp = array[i2];
            array[i2] = array[j2];
            array[j2] = tmp;
        }
    }
}

