/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBPort;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.io.IOException;

public class WriteResult {
    private long _lastCall;
    private WriteConcern _lastConcern;
    private CommandResult _lastErrorResult;
    private final DB _db;
    private final DBPort _port;
    private final boolean _lazy;

    WriteResult(CommandResult o2, WriteConcern concern) {
        this._lastErrorResult = o2;
        this._lastConcern = concern;
        this._lazy = false;
        this._port = null;
        this._db = null;
    }

    WriteResult(DB db, DBPort p2, WriteConcern concern) {
        this._db = db;
        this._port = p2;
        this._lastCall = p2._calls.get();
        this._lastConcern = concern;
        this._lazy = true;
    }

    public CommandResult getCachedLastError() {
        return this._lastErrorResult;
    }

    public WriteConcern getLastConcern() {
        return this._lastConcern;
    }

    public synchronized CommandResult getLastError() {
        return this.getLastError(null);
    }

    public synchronized CommandResult getLastError(WriteConcern concern) {
        if (this._lastErrorResult != null && (concern == null || this._lastConcern != null && this._lastConcern.getW() >= concern.getW())) {
            return this._lastErrorResult;
        }
        if (this._port != null) {
            try {
                this._lastErrorResult = this._port.tryGetLastError(this._db, this._lastCall, concern == null ? new WriteConcern() : concern);
            }
            catch (IOException ioe) {
                throw new MongoException.Network(ioe.getMessage(), ioe);
            }
            if (this._lastErrorResult == null) {
                throw new IllegalStateException("The connection may have been used since this write, cannot obtain a result");
            }
            this._lastConcern = concern;
            ++this._lastCall;
        } else {
            throw new IllegalStateException("Don't have a port to obtain a write result, and existing one is not good enough.");
        }
        return this._lastErrorResult;
    }

    public String getError() {
        Object foo = this.getField("err");
        if (foo == null) {
            return null;
        }
        return foo.toString();
    }

    public int getN() {
        return this.getLastError().getInt("n");
    }

    public Object getField(String name) {
        return this.getLastError().get(name);
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public String toString() {
        CommandResult res = this.getCachedLastError();
        if (res != null) {
            return res.toString();
        }
        return "N/A";
    }
}

