/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picard.PicardException;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.fakers.FileFaker;

public abstract class ParameterizedFileUtil {
    public static final String PER_TILE_PATTERN_STRING = "s_(\\d+)_(\\d{1,5})";
    protected final String extension;
    protected Pattern matchPattern;
    protected final int lane;
    protected List<Integer> tiles;
    protected final File base;
    protected final FileFaker faker;

    public ParameterizedFileUtil(boolean laneTileRegex, String extension, File base, FileFaker faker, int lane) {
        this(extension, base, faker, lane);
        this.matchPattern = laneTileRegex ? Pattern.compile(this.escapePeriods(ParameterizedFileUtil.makeLaneTileRegex(this.processTxtExtension(extension), lane))) : Pattern.compile(this.escapePeriods(this.makeLaneRegex(extension, lane)));
    }

    public ParameterizedFileUtil(String pattern, String extension, File base, FileFaker faker, int lane) {
        this(extension, base, faker, lane);
        this.matchPattern = Pattern.compile(pattern);
    }

    private ParameterizedFileUtil(String extension, File base, FileFaker faker, int lane) {
        this.faker = faker;
        this.extension = extension;
        this.base = base;
        this.lane = lane;
    }

    public abstract boolean filesAvailable();

    public List<Integer> getTiles() {
        return this.tiles;
    }

    public abstract List<String> verify(List<Integer> var1, int[] var2);

    public abstract List<String> fakeFiles(List<Integer> var1, int[] var2, IlluminaFileUtil.SupportedIlluminaFormat var3);

    protected Integer fileToTile(String fileName) {
        Matcher matcher = this.matchPattern.matcher(fileName);
        if (!matcher.matches()) {
            return null;
        }
        return Integer.parseInt(matcher.group(1));
    }

    public static String makeLaneTileRegex(String fileNameEndPattern, int lane) {
        if (lane < 0) {
            throw new PicardException("Lane (" + lane + ") cannot be negative");
        }
        return "^s_" + lane + "_(\\d{1,5})" + fileNameEndPattern + "$";
    }

    private String makeLaneRegex(String fileNameEndPattern, int lane) {
        return "^s_" + lane + fileNameEndPattern + "$";
    }

    private String escapePeriods(String preEscaped) {
        return preEscaped.replaceAll("\\.", "\\.");
    }

    private String processTxtExtension(String fileNameEndPattern) {
        if (fileNameEndPattern.endsWith(".txt")) {
            return fileNameEndPattern + "(\\.gz|\\.bz2)?";
        }
        return fileNameEndPattern;
    }

    protected IlluminaFileMap getTiledFiles(File baseDirectory, Pattern pattern) {
        IlluminaFileMap fileMap = new IlluminaFileMap();
        if (baseDirectory.exists()) {
            File[] files;
            IOUtil.assertDirectoryIsReadable(baseDirectory);
            for (File file : files = IOUtil.getFilesMatchingRegexp(baseDirectory, pattern)) {
                if (file.length() <= 0L) continue;
                fileMap.put(this.fileToTile(file.getName()), file);
            }
        }
        return fileMap;
    }
}

