/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.text.DecimalFormat;
import java.util.SortedMap;
import java.util.TreeMap;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Illumina;
import picard.illumina.IlluminaBasecallingMetrics;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaDataProvider;
import picard.illumina.parser.IlluminaDataProviderFactory;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.TabbedTextFileWithHeaderParser;

@CommandLineProgramProperties(usage="Given an Illumina basecalling and a lane, produces per-lane-barcode basecalling metrics", usageShort="Given an Illumina basecalling and a lane, produces per-lane-barcode basecalling metrics", programGroup=Illumina.class)
public class CollectIlluminaBasecallingMetrics
extends CommandLineProgram {
    static final String USAGE = "Given an Illumina basecalling and a lane, produces per-lane-barcode basecalling metrics";
    @Option(doc="The Illumina basecalls output directory from which data are read", shortName="B")
    public File BASECALLS_DIR;
    @Option(doc="The lane whose data will be read", shortName="L")
    public Integer LANE;
    @Option(doc="The file containing barcodes to expect from the run - barcodeData.#", shortName="I", optional=true)
    public File INPUT;
    @Option(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"36T8B8S28T\" then, before being converted to SAM records those bases will be split into 4 reads where read one consists of 36 cycles of template, read two consists of 8 cycles of barcode, read three will be an 8 base read of skipped cycles and read four is another 28 cycle template read.  The read consisting of skipped cycles would NOT be included in output SAM/BAM file read groups.", shortName="RS")
    public String READ_STRUCTURE;
    @Option(doc="The file to which the collected metrics are written", shortName="O", optional=true)
    public File OUTPUT;
    private int barcodeLength = 0;
    private String unmatched_barcode;
    private final SortedMap<String, IlluminaMetricCounts> barcodeToMetricCounts = new TreeMap<String, IlluminaMetricCounts>();
    private static final String BARCODE_NAME_COLUMN = "barcode_name";
    private static final String BARCODE_SEQUENCE_COLUMN_NAME_STUB = "barcode_sequence_";

    @Override
    protected int doWork() {
        IlluminaDataProviderFactory factory;
        IOUtil.assertDirectoryIsReadable(this.BASECALLS_DIR);
        if (this.OUTPUT == null) {
            this.OUTPUT = new File(this.BASECALLS_DIR, String.format("LANE%s_basecalling_metrics", this.LANE));
        }
        IOUtil.assertFileIsWritable(this.OUTPUT);
        ReadStructure readStructure = new ReadStructure(this.READ_STRUCTURE);
        BclQualityEvaluationStrategy bclQualityEvaluationStrategy = new BclQualityEvaluationStrategy(2);
        if (this.INPUT == null) {
            factory = new IlluminaDataProviderFactory(this.BASECALLS_DIR, this.LANE, readStructure, bclQualityEvaluationStrategy, IlluminaDataType.PF, IlluminaDataType.Position);
        } else {
            IOUtil.assertFileIsReadable(this.INPUT);
            TabbedTextFileWithHeaderParser barcodesParser = new TabbedTextFileWithHeaderParser(this.INPUT);
            for (TabbedTextFileWithHeaderParser.Row row : barcodesParser) {
                String barcodeName = row.getField(BARCODE_NAME_COLUMN);
                StringBuilder barcode = new StringBuilder();
                for (int i2 = 1; i2 <= readStructure.barcodes.length(); ++i2) {
                    barcode.append(row.getField(BARCODE_SEQUENCE_COLUMN_NAME_STUB + i2));
                    if (this.barcodeLength != 0) continue;
                    this.barcodeLength = barcode.length();
                }
                if (barcode.length() <= 0) continue;
                this.barcodeToMetricCounts.put(barcode.toString(), new IlluminaMetricCounts(barcode.toString(), barcodeName, this.LANE));
            }
            factory = this.barcodeToMetricCounts.isEmpty() ? new IlluminaDataProviderFactory(this.BASECALLS_DIR, this.LANE, readStructure, bclQualityEvaluationStrategy, IlluminaDataType.PF, IlluminaDataType.Position) : new IlluminaDataProviderFactory(this.BASECALLS_DIR, this.LANE, readStructure, bclQualityEvaluationStrategy, IlluminaDataType.PF, IlluminaDataType.Position, IlluminaDataType.Barcodes);
        }
        this.unmatched_barcode = StringUtil.repeatCharNTimes('N', this.barcodeLength);
        IlluminaDataProvider provider = factory.makeDataProvider();
        while (provider.hasNext()) {
            ClusterData cluster = provider.next();
            this.addCluster(cluster);
        }
        this.onComplete();
        return 0;
    }

    private void addCluster(ClusterData cluster) {
        IlluminaMetricCounts counters;
        String barcode = cluster.getMatchedBarcode();
        if (barcode == null) {
            barcode = this.unmatched_barcode;
        }
        if ((counters = (IlluminaMetricCounts)this.barcodeToMetricCounts.get(barcode)) == null) {
            counters = new IlluminaMetricCounts(barcode, null, this.LANE);
            this.barcodeToMetricCounts.put(barcode, counters);
        }
        int tileNumber = cluster.getTile();
        counters.incrementClusterCount(tileNumber, cluster.isPf());
    }

    private void onComplete() {
        try {
            MetricsFile<IlluminaBasecallingMetrics, Comparable<?>> file = this.getMetricsFile();
            IlluminaMetricCounts allLaneCounts = new IlluminaMetricCounts(null, null, this.LANE);
            for (String s2 : this.barcodeToMetricCounts.keySet()) {
                IlluminaMetricCounts counts = (IlluminaMetricCounts)this.barcodeToMetricCounts.get(s2);
                counts.addMetricsToFile(file);
                allLaneCounts.addIlluminaMetricCounts(counts);
            }
            if (!this.barcodeToMetricCounts.keySet().contains("")) {
                allLaneCounts.addMetricsToFile(file);
            }
            file.write(this.OUTPUT);
        }
        catch (Exception ex) {
            throw new PicardException("Error writing output file " + this.OUTPUT.getPath(), ex);
        }
    }

    public static void main(String[] argv) {
        new CollectIlluminaBasecallingMetrics().instanceMainWithExit(argv);
    }

    private class IlluminaMetricCounts {
        private final Histogram<Integer> tileToClusterHistogram = new Histogram();
        private final Histogram<Integer> tileToPfClusterHistogram = new Histogram();
        final IlluminaBasecallingMetrics metrics = new IlluminaBasecallingMetrics();

        public IlluminaMetricCounts(String barcode, String barcodeName, Integer laneNumber) {
            this.metrics.MOLECULAR_BARCODE_SEQUENCE_1 = barcode;
            this.metrics.MOLECULAR_BARCODE_NAME = barcodeName;
            this.metrics.LANE = Integer.toString(laneNumber);
        }

        public void incrementClusterCount(int tileNumber, boolean isPf) {
            this.incrementClusterCount(tileNumber, 1.0, isPf);
        }

        public void incrementClusterCount(int tileNumber, double incrementAmount, boolean isPf) {
            this.incrementClusterCount((Integer)tileNumber, incrementAmount, isPf ? 1.0 : 0.0);
        }

        public void incrementClusterCount(Integer tileNumber, double incrementAmount, double pfIncrementAmount) {
            this.tileToClusterHistogram.increment(tileNumber, incrementAmount);
            this.tileToPfClusterHistogram.increment(tileNumber, pfIncrementAmount);
        }

        private void onComplete() {
            double meanClustersPerTile = this.tileToClusterHistogram.getMeanBinSize();
            this.metrics.MEAN_CLUSTERS_PER_TILE = Math.round(meanClustersPerTile);
            this.metrics.SD_CLUSTERS_PER_TILE = Math.round(this.tileToClusterHistogram.getStandardDeviationBinSize(meanClustersPerTile));
            double meanPfClustersPerTile = this.tileToPfClusterHistogram.getMeanBinSize();
            this.metrics.MEAN_PF_CLUSTERS_PER_TILE = Math.round(meanPfClustersPerTile);
            this.metrics.SD_PF_CLUSTERS_PER_TILE = Math.round(this.tileToPfClusterHistogram.getStandardDeviationBinSize(meanPfClustersPerTile));
            DecimalFormat decFormat = new DecimalFormat("#.##");
            Histogram<Integer> laneToPctPfClusterHistogram = this.tileToPfClusterHistogram.divideByHistogram(this.tileToClusterHistogram);
            double meanPctPfClustersPerTile = laneToPctPfClusterHistogram.getMeanBinSize();
            this.metrics.MEAN_PCT_PF_CLUSTERS_PER_TILE = Double.isNaN(meanPctPfClustersPerTile) ? 0.0 : Double.valueOf(decFormat.format(meanPctPfClustersPerTile * 100.0));
            this.metrics.SD_PCT_PF_CLUSTERS_PER_TILE = Double.valueOf(decFormat.format(laneToPctPfClusterHistogram.getStandardDeviationBinSize(meanPctPfClustersPerTile) * 100.0));
            this.metrics.TOTAL_CLUSTERS = (long)this.tileToClusterHistogram.getSumOfValues();
            this.metrics.PF_CLUSTERS = (long)this.tileToPfClusterHistogram.getSumOfValues();
            ReadStructure readStructure = new ReadStructure(CollectIlluminaBasecallingMetrics.this.READ_STRUCTURE);
            int templateBaseCountPerCluster = 0;
            for (int i2 = 0; i2 < readStructure.templates.length(); ++i2) {
                templateBaseCountPerCluster += readStructure.templates.get((int)i2).length;
            }
            this.metrics.TOTAL_READS = this.metrics.TOTAL_CLUSTERS * (long)readStructure.templates.length();
            this.metrics.PF_READS = this.metrics.PF_CLUSTERS * (long)readStructure.templates.length();
            this.metrics.TOTAL_BASES = this.metrics.TOTAL_CLUSTERS * (long)templateBaseCountPerCluster;
            this.metrics.PF_BASES = this.metrics.PF_CLUSTERS * (long)templateBaseCountPerCluster;
        }

        public void addMetricsToFile(MetricsFile<IlluminaBasecallingMetrics, Comparable<?>> file) {
            this.onComplete();
            file.addMetric(this.metrics);
        }

        public void addIlluminaMetricCounts(IlluminaMetricCounts counts) {
            this.tileToClusterHistogram.addHistogram(counts.tileToClusterHistogram);
            this.tileToPfClusterHistogram.addHistogram(counts.tileToPfClusterHistogram);
        }
    }
}

