/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;

public class GridGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    public static final String CORNER_VERTEX = "Corner Vertex";
    private int rows;
    private int cols;

    public GridGraphGenerator(int n2, int n3) {
        if (n2 < 2) {
            throw new IllegalArgumentException("illegal number of rows (" + n2 + "). there must be at least two.");
        }
        if (n3 < 2) {
            throw new IllegalArgumentException("illegal number of columns (" + n3 + "). there must be at least two.");
        }
        this.rows = n2;
        this.cols = n3;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, V> map) {
        TreeMap<Integer, V> treeMap = new TreeMap<Integer, V>();
        int n2 = 0;
        for (int i2 = 0; i2 < this.rows * this.cols; ++i2) {
            boolean bl;
            V v2 = vertexFactory.createVertex();
            graph.addVertex(v2);
            treeMap.put(i2 + 1, v2);
            boolean bl2 = bl = i2 == 0 || i2 == this.cols - 1 || i2 == this.cols * (this.rows - 1) || i2 == this.rows * this.cols - 1;
            if (!bl || map == null) continue;
            map.put("Corner Vertex " + ++n2, v2);
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            Iterator iterator2 = treeMap.keySet().iterator();
            while (iterator2.hasNext()) {
                int n4 = (Integer)iterator2.next();
                if ((n3 % this.cols <= 0 || n3 + 1 != Integer.valueOf(n4)) && n3 + this.cols != n4) continue;
                graph.addEdge(treeMap.get(n3), treeMap.get(n4));
                graph.addEdge(treeMap.get(n4), treeMap.get(n3));
            }
        }
    }
}

