/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;

public class BronKerboschCliqueFinder<V, E> {
    private final Graph<V, E> graph;
    private Collection<Set<V>> cliques;

    public BronKerboschCliqueFinder(Graph<V, E> graph) {
        this.graph = graph;
    }

    public Collection<Set<V>> getAllMaximalCliques() {
        this.cliques = new ArrayList<Set<V>>();
        ArrayList arrayList = new ArrayList();
        ArrayList<V> arrayList2 = new ArrayList<V>();
        ArrayList arrayList3 = new ArrayList();
        arrayList2.addAll(this.graph.vertexSet());
        this.findCliques(arrayList, arrayList2, arrayList3);
        return this.cliques;
    }

    public Collection<Set<V>> getBiggestMaximalCliques() {
        this.getAllMaximalCliques();
        int n2 = 0;
        ArrayList<Set<V>> arrayList = new ArrayList<Set<V>>();
        for (Set<V> set : this.cliques) {
            if (n2 >= set.size()) continue;
            n2 = set.size();
        }
        for (Set<V> set : this.cliques) {
            if (n2 != set.size()) continue;
            arrayList.add(set);
        }
        return arrayList;
    }

    private void findCliques(List<V> list, List<V> list2, List<V> list3) {
        ArrayList<V> arrayList = new ArrayList<V>(list2);
        if (!this.end(list2, list3)) {
            for (Object e2 : arrayList) {
                ArrayList<V> arrayList2 = new ArrayList<V>();
                ArrayList<V> arrayList3 = new ArrayList<V>();
                list.add(e2);
                list2.remove(e2);
                for (V v2 : list2) {
                    if (!this.graph.containsEdge(e2, v2)) continue;
                    arrayList2.add(v2);
                }
                for (V v2 : list3) {
                    if (!this.graph.containsEdge(e2, v2)) continue;
                    arrayList3.add(v2);
                }
                if (arrayList2.isEmpty() && arrayList3.isEmpty()) {
                    this.cliques.add(new HashSet<V>(list));
                } else {
                    this.findCliques(list, arrayList2, arrayList3);
                }
                list3.add(e2);
                list.remove(e2);
            }
        }
    }

    private boolean end(List<V> list, List<V> list2) {
        boolean bl = false;
        for (V v2 : list2) {
            int n2 = 0;
            for (V v3 : list) {
                if (!this.graph.containsEdge(v2, v3)) continue;
                ++n2;
            }
            if (n2 != list.size()) continue;
            bl = true;
        }
        return bl;
    }
}

