/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.graph.AsUndirectedGraph;

public abstract class Graphs {
    public static <V, E> E addEdge(Graph<V, E> graph, V v2, V v3, double d2) {
        EdgeFactory<V, E> edgeFactory = graph.getEdgeFactory();
        E e2 = edgeFactory.createEdge(v2, v3);
        assert (graph instanceof WeightedGraph) : graph.getClass();
        ((WeightedGraph)graph).setEdgeWeight(e2, d2);
        return (E)(graph.addEdge(v2, v3, e2) ? e2 : null);
    }

    public static <V, E> E addEdgeWithVertices(Graph<V, E> graph, V v2, V v3) {
        graph.addVertex(v2);
        graph.addVertex(v3);
        return graph.addEdge(v2, v3);
    }

    public static <V, E> boolean addEdgeWithVertices(Graph<V, E> graph, Graph<V, E> graph2, E e2) {
        V v2 = graph2.getEdgeSource(e2);
        V v3 = graph2.getEdgeTarget(e2);
        graph.addVertex(v2);
        graph.addVertex(v3);
        return graph.addEdge(v2, v3, e2);
    }

    public static <V, E> E addEdgeWithVertices(Graph<V, E> graph, V v2, V v3, double d2) {
        graph.addVertex(v2);
        graph.addVertex(v3);
        return Graphs.addEdge(graph, v2, v3, d2);
    }

    public static <V, E> boolean addGraph(Graph<? super V, ? super E> graph, Graph<V, E> graph2) {
        boolean bl = Graphs.addAllVertices(graph, graph2.vertexSet());
        return bl |= Graphs.addAllEdges(graph, graph2, graph2.edgeSet());
    }

    public static <V, E> void addGraphReversed(DirectedGraph<? super V, ? super E> directedGraph, DirectedGraph<V, E> directedGraph2) {
        Graphs.addAllVertices(directedGraph, directedGraph2.vertexSet());
        for (Object e2 : directedGraph2.edgeSet()) {
            directedGraph.addEdge(directedGraph2.getEdgeTarget(e2), directedGraph2.getEdgeSource(e2));
        }
    }

    public static <V, E> boolean addAllEdges(Graph<? super V, ? super E> graph, Graph<V, E> graph2, Collection<? extends E> collection) {
        boolean bl = false;
        for (E e2 : collection) {
            V v2 = graph2.getEdgeSource(e2);
            V v3 = graph2.getEdgeTarget(e2);
            graph.addVertex(v2);
            graph.addVertex(v3);
            bl |= graph.addEdge(v2, v3, e2);
        }
        return bl;
    }

    public static <V, E> boolean addAllVertices(Graph<? super V, ? super E> graph, Collection<? extends V> collection) {
        boolean bl = false;
        for (V v2 : collection) {
            bl |= graph.addVertex(v2);
        }
        return bl;
    }

    public static <V, E> List<V> neighborListOf(Graph<V, E> graph, V v2) {
        ArrayList<V> arrayList = new ArrayList<V>();
        for (E e2 : graph.edgesOf(v2)) {
            arrayList.add(Graphs.getOppositeVertex(graph, e2, v2));
        }
        return arrayList;
    }

    public static <V, E> List<V> predecessorListOf(DirectedGraph<V, E> directedGraph, V v2) {
        ArrayList<V> arrayList = new ArrayList<V>();
        Set<E> set = directedGraph.incomingEdgesOf(v2);
        for (E e2 : set) {
            arrayList.add(Graphs.getOppositeVertex(directedGraph, e2, v2));
        }
        return arrayList;
    }

    public static <V, E> List<V> successorListOf(DirectedGraph<V, E> directedGraph, V v2) {
        ArrayList<V> arrayList = new ArrayList<V>();
        Set<E> set = directedGraph.outgoingEdgesOf(v2);
        for (E e2 : set) {
            arrayList.add(Graphs.getOppositeVertex(directedGraph, e2, v2));
        }
        return arrayList;
    }

    public static <V, E> UndirectedGraph<V, E> undirectedGraph(Graph<V, E> graph) {
        if (graph instanceof DirectedGraph) {
            return new AsUndirectedGraph((DirectedGraph)graph);
        }
        if (graph instanceof UndirectedGraph) {
            return (UndirectedGraph)graph;
        }
        throw new IllegalArgumentException("Graph must be either DirectedGraph or UndirectedGraph");
    }

    public static <V, E> boolean testIncidence(Graph<V, E> graph, E e2, V v2) {
        return graph.getEdgeSource(e2).equals(v2) || graph.getEdgeTarget(e2).equals(v2);
    }

    public static <V, E> V getOppositeVertex(Graph<V, E> graph, E e2, V v2) {
        V v3 = graph.getEdgeSource(e2);
        V v4 = graph.getEdgeTarget(e2);
        if (v2.equals(v3)) {
            return v4;
        }
        if (v2.equals(v4)) {
            return v3;
        }
        throw new IllegalArgumentException("no such vertex");
    }

    public static <V, E> List<V> getPathVertexList(GraphPath<V, E> graphPath) {
        Graph<V, E> graph = graphPath.getGraph();
        ArrayList<V> arrayList = new ArrayList<V>();
        V v2 = graphPath.getStartVertex();
        arrayList.add(v2);
        for (E e2 : graphPath.getEdgeList()) {
            v2 = Graphs.getOppositeVertex(graph, e2, v2);
            arrayList.add(v2);
        }
        return arrayList;
    }
}

