/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.progressmeter;

import org.broadinstitute.gatk.utils.progressmeter.ProgressMeter;

public final class ProgressMeterDaemon
extends Thread {
    public static final long DEFAULT_POLL_FREQUENCY_MILLISECONDS = 10000L;
    private final long pollFrequencyMilliseconds;
    boolean done = false;
    final ProgressMeter meter;

    private long getPollFrequencyMilliseconds() {
        return this.pollFrequencyMilliseconds;
    }

    public ProgressMeterDaemon(ProgressMeter meter, long pollFrequencyMilliseconds) {
        if (meter == null) {
            throw new IllegalArgumentException("meter cannot be null");
        }
        if (pollFrequencyMilliseconds <= 0L) {
            throw new IllegalArgumentException("pollFrequencyMilliseconds must be greater than 0 but got " + pollFrequencyMilliseconds);
        }
        this.meter = meter;
        this.pollFrequencyMilliseconds = pollFrequencyMilliseconds;
        this.setDaemon(true);
        this.setName("ProgressMeterDaemon");
    }

    public ProgressMeterDaemon(ProgressMeter meter) {
        this(meter, 10000L);
    }

    public final void done() {
        this.done = true;
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void run() {
        while (!this.done) {
            this.meter.printProgress(false);
            this.meter.updateElapsedTimeInNanoseconds();
            try {
                Thread.sleep(this.getPollFrequencyMilliseconds());
            }
            catch (InterruptedException e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

