/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.renderer.AbstractColorScale;
import org.broad.igv.ui.color.ColorUtilities;

public class MappedColorScale
extends AbstractColorScale {
    public static String serializationClassId = "MappedColorScale";
    Map<String, Color> colorMap = new HashMap<String, Color>();
    boolean defaultCS = false;

    public MappedColorScale(String serializedInstance) {
        String[] tokens = serializedInstance.split(";");
        for (int i2 = 1; i2 < tokens.length; ++i2) {
            String[] keyValue = tokens[i2].split(" ");
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim();
            Color c2 = ColorUtilities.stringToColor(keyValue[1]);
            this.colorMap.put(key, c2);
        }
    }

    public MappedColorScale(Map<String, Color> colorMap) {
        this.colorMap.putAll(colorMap);
    }

    @Override
    public boolean isDefault() {
        return this.defaultCS;
    }

    @Override
    public String asString() {
        StringBuffer buf = new StringBuffer();
        buf.append(serializationClassId);
        for (Map.Entry<String, Color> mapEntry : this.colorMap.entrySet()) {
            buf.append(";");
            buf.append(mapEntry.getKey() + " ");
            buf.append(ColorUtilities.colorToString(mapEntry.getValue()));
        }
        return buf.toString();
    }

    public int getSize() {
        return this.colorMap.size();
    }

    public boolean isSame(MappedColorScale anotherCS) {
        if (this.getSize() != anotherCS.getSize()) {
            return false;
        }
        for (String key : this.colorMap.keySet()) {
            if (this.getColor(key).equals(anotherCS.getColor(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Color getColor(String key) {
        return this.colorMap.containsKey(key) ? this.colorMap.get(key) : defaultColor;
    }

    @Override
    public Color getNoDataColor() {
        return this.noDataColor;
    }
}

