/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.peaks.Peak;
import org.broad.igv.peaks.PeakTrack;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.color.ColorUtilities;

public class PeakRenderer
implements Renderer<LocusScore> {
    BarChartRenderer chartRenderer = new BarChartRenderer();
    public static final int SIGNAL_CHART_HEIGHT = 15;

    @Override
    public void render(List<LocusScore> peakList, RenderContext context, Rectangle rect, Track t2) {
        int h2;
        PeakTrack track = (PeakTrack)t2;
        double locScale = context.getScale();
        double origin = context.getOrigin();
        int lastPX = -1;
        double pXMin = rect.getMinX();
        double pXMax = rect.getMaxX();
        Color fgColor = track.getColor();
        Graphics2D borderGraphics = context.getGraphic2DForColor(Color.black);
        String chr = context.getChr();
        int contextStart = (int)context.getOrigin();
        int contextEnd = (int)context.getEndLocation();
        int zoom = context.getZoom();
        if (PeakTrack.isShowPeaks()) {
            h2 = track.bandHeight;
            int peakHeight = PeakTrack.isShowSignals() ? track.peakHeight : h2;
            for (LocusScore ls : peakList) {
                int end;
                int dX;
                Peak peak = (Peak)ls;
                int start = peak.getStart();
                int pX = (int)(((double)start - origin) / locScale);
                if ((double)(pX + (dX = (int)Math.max(2.0, (double)((end = peak.getEnd()) - start) / locScale))) < pXMin) continue;
                if ((double)pX > pXMax) break;
                float score = peak.getCombinedScore();
                if (PeakTrack.getColorOption() == PeakTrack.ColorOption.FOLD_CHANGE) {
                    score = peak.getDynamicScore();
                }
                int top = rect.y + 1;
                if (PeakTrack.isShowSignals()) {
                    top += track.signalHeight;
                }
                if (PeakTrack.animate) {
                    int step = track.getTimeStep();
                    float[] timeScores = peak.getTimeScores();
                    int idx = Math.min(step, timeScores.length - 1);
                    score = timeScores[idx];
                    this.drawPeak(context, fgColor, pX, dX, top, peakHeight, score, PeakTrack.getColorOption());
                    continue;
                }
                if (track.getDisplayMode() == Track.DisplayMode.EXPANDED) {
                    float[] timeScores = peak.getTimeScores();
                    for (int i2 = 0; i2 < timeScores.length; ++i2) {
                        score = timeScores[i2];
                        this.drawPeak(context, fgColor, pX, dX, top, peakHeight, score, PeakTrack.getColorOption());
                        top += h2;
                    }
                    continue;
                }
                this.drawPeak(context, fgColor, pX, dX, top, peakHeight, score, PeakTrack.getColorOption());
            }
        }
        if (PeakTrack.isShowSignals() && track.getSignalPath() != null) {
            int signalHeight;
            h2 = track.bandHeight;
            int n2 = signalHeight = PeakTrack.isShowPeaks() ? track.signalHeight : h2;
            if (PeakTrack.animate) {
                int idx;
                int step = track.getTimeStep();
                DataSource[] timeSignalSources = track.getTimeSignalSources();
                DataSource src = timeSignalSources[idx = Math.min(step, timeSignalSources.length - 1)];
                if (src != null) {
                    int top = rect.y + 2;
                    List<LocusScore> timeSignals = src.getSummaryScoresForRange(chr, contextStart, contextEnd, zoom);
                    Rectangle timeSignalRect = new Rectangle(rect.x, top, rect.width, signalHeight - 1);
                    this.chartRenderer.render(timeSignals, context, timeSignalRect, (Track)track);
                }
            } else if (track.getDisplayMode() == Track.DisplayMode.EXPANDED) {
                DataSource[] timeSignalSources = track.getTimeSignalSources();
                if (timeSignalSources != null) {
                    int top = rect.y + 2;
                    for (int i3 = 0; i3 < timeSignalSources.length; ++i3) {
                        DataSource src = timeSignalSources[i3];
                        if (src != null) {
                            List<LocusScore> timeSignals = src.getSummaryScoresForRange(chr, contextStart, contextEnd, zoom);
                            Rectangle timeSignalRect = new Rectangle(rect.x, top, rect.width, signalHeight - 1);
                            this.chartRenderer.render(timeSignals, context, timeSignalRect, (Track)track);
                        }
                        top += h2;
                    }
                }
            } else {
                PeakTrack.WrappedDataSource signalSource = track.getSignalSource(chr, contextStart, contextEnd, zoom);
                if (signalSource != null) {
                    List<LocusScore> signals = signalSource.getSummaryScoresForRange(chr, contextStart, contextEnd, zoom);
                    Rectangle signalRect = new Rectangle(rect.x, rect.y + 1, rect.width, signalHeight - 1);
                    this.chartRenderer.render(signals, context, signalRect, (Track)track);
                }
            }
        }
        if (track.getDisplayMode() == Track.DisplayMode.EXPANDED) {
            borderGraphics.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
            borderGraphics.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
        }
    }

    private void drawPeak(RenderContext context, Color fgColor, int pX, int dX, int top, int h2, float score, PeakTrack.ColorOption option) {
        Color c2 = this.getColor(fgColor, score, option);
        Graphics2D g2 = context.getGraphic2DForColor(c2);
        g2.fillRect(pX, top + 1, dX, h2 - 2);
    }

    private Color getColor(Color fgColor, float score, PeakTrack.ColorOption option) {
        Color c2 = null;
        float alpha = 1.0f;
        if (option == PeakTrack.ColorOption.SCORE) {
            int shadeStep = (int)(score / 10.0f);
            alpha = Math.max(0.2f, Math.min(1.0f, (float)shadeStep * 0.1f));
        } else if (option == PeakTrack.ColorOption.FOLD_CHANGE) {
            if ((double)Math.abs(score) < 1.58) {
                alpha = 1.0f;
                fgColor = Color.gray;
            } else {
                int shadeStep = (int)(((double)Math.abs(score) - 1.58) / 1.7199999999999998 * 10.0);
                alpha = Math.max(0.3f, Math.min(1.0f, 0.3f + (float)shadeStep * 0.1f));
                fgColor = score < 0.0f ? Color.blue : Color.red;
            }
        }
        c2 = ColorUtilities.getCompositeColor(fgColor, alpha);
        return c2;
    }
}

