/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ClassFileUtilities {
    public static final byte CONSTANT_UTF8_INFO = 1;
    public static final byte CONSTANT_INTEGER_INFO = 3;
    public static final byte CONSTANT_FLOAT_INFO = 4;
    public static final byte CONSTANT_LONG_INFO = 5;
    public static final byte CONSTANT_DOUBLE_INFO = 6;
    public static final byte CONSTANT_CLASS_INFO = 7;
    public static final byte CONSTANT_STRING_INFO = 8;
    public static final byte CONSTANT_FIELDREF_INFO = 9;
    public static final byte CONSTANT_METHODREF_INFO = 10;
    public static final byte CONSTANT_INTERFACEMETHODREF_INFO = 11;
    public static final byte CONSTANT_NAMEANDTYPE_INFO = 12;

    protected ClassFileUtilities() {
    }

    public static void main(String[] args) {
        boolean showFiles = false;
        if (args.length == 1 && args[0].equals("-f")) {
            showFiles = true;
        } else if (args.length != 0) {
            System.err.println("usage: org.apache.batik.util.ClassFileUtilities [-f]");
            System.err.println();
            System.err.println("  -f    list files that cause each jar file dependency");
            System.exit(1);
        }
        File cwd = new File(".");
        File buildDir = null;
        String[] cwdFiles = cwd.list();
        int i2 = 0;
        while (i2 < cwdFiles.length) {
            if (cwdFiles[i2].startsWith("batik-")) {
                buildDir = new File(cwdFiles[i2]);
                if (buildDir.isDirectory()) break;
                buildDir = null;
            }
            ++i2;
        }
        if (buildDir == null || !buildDir.isDirectory()) {
            System.out.println("Directory 'batik-xxx' not found in current directory!");
            return;
        }
        try {
            Iterator<Object> j2;
            ClassFile fromFile;
            HashMap cs = new HashMap();
            HashMap js = new HashMap();
            ClassFileUtilities.collectJars(buildDir, js, cs);
            HashSet<JarFile> classpath = new HashSet<JarFile>();
            Iterator<Object> i3 = js.values().iterator();
            while (i3.hasNext()) {
                classpath.add(((Jar)i3.next()).jarFile);
            }
            i3 = cs.values().iterator();
            while (i3.hasNext()) {
                fromFile = (ClassFile)i3.next();
                Set result = ClassFileUtilities.getClassDependencies(fromFile.getInputStream(), classpath, false);
                j2 = result.iterator();
                while (j2.hasNext()) {
                    ClassFile toFile = (ClassFile)cs.get(j2.next());
                    if (fromFile == toFile || toFile == null) continue;
                    fromFile.deps.add(toFile);
                }
            }
            i3 = cs.values().iterator();
            while (i3.hasNext()) {
                fromFile = (ClassFile)i3.next();
                Iterator j3 = fromFile.deps.iterator();
                while (j3.hasNext()) {
                    ClassFile toFile = (ClassFile)j3.next();
                    Jar fromJar = fromFile.jar;
                    Jar toJar = toFile.jar;
                    if (fromFile.name.equals(toFile.name) || toJar == fromJar || fromJar.files.contains(toFile.name)) continue;
                    Integer n2 = (Integer)fromJar.deps.get(toJar);
                    if (n2 == null) {
                        fromJar.deps.put(toJar, new Integer(1));
                        continue;
                    }
                    fromJar.deps.put(toJar, new Integer(n2 + 1));
                }
            }
            ArrayList<Triple> triples = new ArrayList<Triple>(10);
            i3 = js.values().iterator();
            while (i3.hasNext()) {
                Jar fromJar = (Jar)i3.next();
                j2 = fromJar.deps.keySet().iterator();
                while (j2.hasNext()) {
                    Jar toJar = (Jar)j2.next();
                    Triple t2 = new Triple();
                    t2.from = fromJar;
                    t2.to = toJar;
                    t2.count = (Integer)fromJar.deps.get(toJar);
                    triples.add(t2);
                }
            }
            Collections.sort(triples);
            i3 = triples.iterator();
            while (i3.hasNext()) {
                Triple t3 = (Triple)i3.next();
                System.out.println(t3.count + "," + t3.from.name + "," + t3.to.name);
                if (!showFiles) continue;
                j2 = t3.from.files.iterator();
                while (j2.hasNext()) {
                    ClassFile fromFile2 = (ClassFile)j2.next();
                    Iterator k2 = fromFile2.deps.iterator();
                    while (k2.hasNext()) {
                        ClassFile toFile = (ClassFile)k2.next();
                        if (toFile.jar != t3.to || t3.from.files.contains(toFile.name)) continue;
                        System.out.println("\t" + fromFile2.name + " --> " + toFile.name);
                    }
                }
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static void collectJars(File dir, Map jars, Map classFiles) throws IOException {
        File[] files = dir.listFiles();
        int i2 = 0;
        while (i2 < files.length) {
            String n2 = files[i2].getName();
            if (n2.endsWith(".jar") && files[i2].isFile()) {
                Jar j2 = new Jar();
                j2.name = files[i2].getPath();
                j2.file = files[i2];
                j2.jarFile = new JarFile(files[i2]);
                jars.put(j2.name, j2);
                Enumeration<JarEntry> entries = j2.jarFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry ze = entries.nextElement();
                    String name = ze.getName();
                    if (!name.endsWith(".class")) continue;
                    ClassFile cf = new ClassFile();
                    cf.name = name;
                    cf.jar = j2;
                    classFiles.put(j2.name + '!' + cf.name, cf);
                    j2.files.add(cf);
                }
            } else if (files[i2].isDirectory()) {
                ClassFileUtilities.collectJars(files[i2], jars, classFiles);
            }
            ++i2;
        }
    }

    public static Set getClassDependencies(String path, Set classpath, boolean rec) throws IOException {
        return ClassFileUtilities.getClassDependencies(new FileInputStream(path), classpath, rec);
    }

    public static Set getClassDependencies(InputStream is, Set classpath, boolean rec) throws IOException {
        HashSet result = new HashSet();
        HashSet done = new HashSet();
        ClassFileUtilities.computeClassDependencies(is, classpath, done, result, rec);
        return result;
    }

    private static void computeClassDependencies(InputStream is, Set classpath, Set done, Set result, boolean rec) throws IOException {
        Iterator it = ClassFileUtilities.getClassDependencies(is).iterator();
        while (it.hasNext()) {
            String s2 = (String)it.next();
            if (done.contains(s2)) continue;
            done.add(s2);
            Iterator cpit = classpath.iterator();
            while (cpit.hasNext()) {
                InputStream depis = null;
                String path = null;
                Object cpEntry = cpit.next();
                if (cpEntry instanceof JarFile) {
                    JarFile jarFile = (JarFile)cpEntry;
                    String classFileName = s2 + ".class";
                    ZipEntry ze = jarFile.getEntry(classFileName);
                    if (ze != null) {
                        path = jarFile.getName() + '!' + classFileName;
                        depis = jarFile.getInputStream(ze);
                    }
                } else {
                    path = (String)cpEntry + '/' + s2 + ".class";
                    File f2 = new File(path);
                    if (f2.isFile()) {
                        depis = new FileInputStream(f2);
                    }
                }
                if (depis == null) continue;
                result.add(path);
                if (!rec) continue;
                ClassFileUtilities.computeClassDependencies(depis, classpath, done, result, rec);
            }
        }
    }

    public static Set getClassDependencies(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        if (dis.readInt() != -889275714) {
            throw new IOException("Invalid classfile");
        }
        dis.readInt();
        int len = dis.readShort();
        String[] strs = new String[len];
        HashSet<Integer> classes = new HashSet<Integer>();
        HashSet<Integer> desc = new HashSet<Integer>();
        int i2 = 1;
        while (i2 < len) {
            int constCode = dis.readByte() & 0xFF;
            switch (constCode) {
                case 5: 
                case 6: {
                    dis.readLong();
                    ++i2;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    dis.readInt();
                    break;
                }
                case 7: {
                    classes.add(new Integer(dis.readShort() & 0xFFFF));
                    break;
                }
                case 8: {
                    dis.readShort();
                    break;
                }
                case 12: {
                    dis.readShort();
                    desc.add(new Integer(dis.readShort() & 0xFFFF));
                    break;
                }
                case 1: {
                    strs[i2] = dis.readUTF();
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected data in constant-pool:" + constCode);
                }
            }
            ++i2;
        }
        HashSet<String> result = new HashSet<String>();
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            result.add(strs[(Integer)it.next()]);
        }
        it = desc.iterator();
        while (it.hasNext()) {
            result.addAll(ClassFileUtilities.getDescriptorClasses(strs[(Integer)it.next()]));
        }
        return result;
    }

    protected static Set getDescriptorClasses(String desc) {
        HashSet<String> result = new HashSet<String>();
        int i2 = 0;
        char c2 = desc.charAt(i2);
        block0 : switch (c2) {
            case '(': {
                StringBuffer sb;
                block14: while (true) {
                    c2 = desc.charAt(++i2);
                    switch (c2) {
                        case '[': {
                            while ((c2 = desc.charAt(++i2)) == '[') {
                            }
                            if (c2 != 'L') continue block14;
                        }
                        case 'L': {
                            c2 = desc.charAt(++i2);
                            sb = new StringBuffer();
                            while (c2 != ';') {
                                sb.append(c2);
                                c2 = desc.charAt(++i2);
                            }
                            result.add(sb.toString());
                            break;
                        }
                        default: {
                            break;
                        }
                        case ')': {
                            break block14;
                        }
                    }
                }
                c2 = desc.charAt(++i2);
                switch (c2) {
                    case '[': {
                        while ((c2 = desc.charAt(++i2)) == '[') {
                        }
                        if (c2 != 'L') break block0;
                    }
                    case 'L': {
                        c2 = desc.charAt(++i2);
                        sb = new StringBuffer();
                        while (c2 != ';') {
                            sb.append(c2);
                            c2 = desc.charAt(++i2);
                        }
                        result.add(sb.toString());
                        break;
                    }
                }
                break;
            }
            case '[': {
                while ((c2 = desc.charAt(++i2)) == '[') {
                }
                if (c2 != 'L') break;
            }
            case 'L': {
                c2 = desc.charAt(++i2);
                StringBuffer sb = new StringBuffer();
                while (c2 != ';') {
                    sb.append(c2);
                    c2 = desc.charAt(++i2);
                }
                result.add(sb.toString());
                break;
            }
        }
        return result;
    }

    protected static class Triple
    implements Comparable {
        public Jar from;
        public Jar to;
        public int count;

        protected Triple() {
        }

        public int compareTo(Object o2) {
            return ((Triple)o2).count - this.count;
        }
    }

    protected static class Jar {
        public String name;
        public File file;
        public JarFile jarFile;
        public Map deps = new HashMap();
        public Set files = new HashSet();

        protected Jar() {
        }
    }

    protected static class ClassFile {
        public String name;
        public List deps = new ArrayList(10);
        public Jar jar;

        protected ClassFile() {
        }

        public InputStream getInputStream() throws IOException {
            return this.jar.jarFile.getInputStream(this.jar.jarFile.getEntry(this.name));
        }
    }
}

