/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.BinaryCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class StringUtil {
    private static final byte UPPER_CASE_OFFSET = -32;
    public static final String EMPTY_STRING = "";

    public static <T> String join(String separator, Collection<T> objs) {
        if (objs.size() == 0) {
            return EMPTY_STRING;
        }
        boolean notFirst = false;
        StringBuilder ret = new StringBuilder();
        for (T obj : objs) {
            if (notFirst) {
                ret.append(separator);
            }
            ret.append(obj.toString());
            notFirst = true;
        }
        return ret.toString();
    }

    public static <T> String join(String separator, T ... objs) {
        List<T> values = Arrays.asList(objs);
        return StringUtil.join(separator, values);
    }

    public static int split(String aString, String[] tokens, char delim) {
        String trailingString;
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end >= 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        if (nTokens < maxTokens && (trailingString = aString.substring(start)).length() > 0) {
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static int splitConcatenateExcessTokens(String aString, String[] tokens, char delim) {
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end >= 0 && nTokens < maxTokens - 1) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        String trailingString = aString.substring(start);
        if (trailingString.length() > 0) {
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static byte toLowerCase(byte b2) {
        if (b2 < 65 || b2 > 90) {
            return b2;
        }
        return (byte)(b2 - -32);
    }

    public static byte toUpperCase(byte b2) {
        if (b2 < 97 || b2 > 122) {
            return b2;
        }
        return (byte)(b2 + -32);
    }

    public static void toUpperCase(byte[] bytes) {
        int length = bytes.length;
        for (int i2 = 0; i2 < length; ++i2) {
            if (bytes[i2] < 97 || bytes[i2] > 122) continue;
            bytes[i2] = (byte)(bytes[i2] + -32);
        }
    }

    public static String assertCharactersNotInString(String illegalChars, char ... chars) {
        for (char illegalChar : illegalChars.toCharArray()) {
            for (char ch : chars) {
                if (illegalChar != ch) continue;
                throw new IllegalArgumentException("Supplied String contains illegal character '" + illegalChar + "'.");
            }
        }
        return illegalChars;
    }

    public static String wordWrap(String s2, int maxLineLength) {
        String[] lines = s2.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(StringUtil.wordWrapSingleLine(line, maxLineLength));
        }
        if (s2.endsWith("\n")) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String wordWrapSingleLine(String s2, int maxLineLength) {
        if (s2.length() <= maxLineLength) {
            return s2;
        }
        StringBuilder sb = new StringBuilder();
        int startCopyFrom = 0;
        while (startCopyFrom < s2.length()) {
            int i2;
            int lastSpaceIndex = startCopyFrom;
            for (i2 = startCopyFrom; i2 < s2.length() && i2 - startCopyFrom < maxLineLength; ++i2) {
                if (!Character.isWhitespace(s2.charAt(i2))) continue;
                lastSpaceIndex = i2;
            }
            if (i2 - startCopyFrom < maxLineLength) {
                lastSpaceIndex = i2;
            }
            while (lastSpaceIndex < s2.length() && Character.isWhitespace(s2.charAt(lastSpaceIndex))) {
                ++lastSpaceIndex;
            }
            if (sb.length() > 0) {
                sb.append("\n");
            }
            if (lastSpaceIndex == startCopyFrom) {
                lastSpaceIndex = i2;
            }
            sb.append(s2.substring(startCopyFrom, lastSpaceIndex));
            startCopyFrom = lastSpaceIndex;
        }
        return sb.toString();
    }

    public static String intValuesToString(int[] intVals) {
        StringBuilder sb = new StringBuilder(intVals.length);
        if (intVals.length > 0) {
            sb.append(String.valueOf(intVals[0]));
            for (int i2 = 1; i2 < intVals.length; ++i2) {
                sb.append(", ");
                sb.append(String.valueOf(intVals[i2]));
            }
        }
        return sb.toString();
    }

    public static String intValuesToString(short[] shortVals) {
        StringBuilder sb = new StringBuilder(shortVals.length);
        if (shortVals.length > 0) {
            sb.append(String.valueOf(shortVals[0]));
            for (int i2 = 1; i2 < shortVals.length; ++i2) {
                sb.append(", ");
                sb.append(String.valueOf(shortVals[i2]));
            }
        }
        return sb.toString();
    }

    public static String bytesToString(byte[] data) {
        if (data == null) {
            return null;
        }
        return StringUtil.bytesToString(data, 0, data.length);
    }

    public static String bytesToString(byte[] buffer, int offset, int length) {
        return new String(buffer, 0, offset, length);
    }

    public static byte[] stringToBytes(String s2) {
        byte[] byteBuffer = new byte[s2.length()];
        s2.getBytes(0, byteBuffer.length, byteBuffer, 0);
        return byteBuffer;
    }

    public static byte[] stringToBytes(String s2, int offset, int length) {
        byte[] byteBuffer = new byte[length];
        s2.getBytes(offset, offset + length, byteBuffer, 0);
        return byteBuffer;
    }

    public static String readNullTerminatedString(BinaryCodec binaryCodec) {
        StringBuilder ret = new StringBuilder();
        byte b2 = binaryCodec.readByte();
        while (b2 != 0) {
            ret.append((char)(b2 & 0xFF));
            b2 = binaryCodec.readByte();
        }
        return ret.toString();
    }

    public static void charsToBytes(char[] chars, int charOffset, int length, byte[] bytes, int byteOffset) {
        for (int i2 = 0; i2 < length; ++i2) {
            bytes[byteOffset + i2] = (byte)chars[charOffset + i2];
        }
    }

    public static byte charToByte(char c2) {
        return (byte)c2;
    }

    public static char byteToChar(byte b2) {
        return (char)(b2 & 0xFF);
    }

    public static String bytesToHexString(byte[] data) {
        char[] chars = new char[2 * data.length];
        for (int i2 = 0; i2 < data.length; ++i2) {
            byte b2 = data[i2];
            chars[2 * i2] = StringUtil.toHexDigit(b2 >> 4 & 0xF);
            chars[2 * i2 + 1] = StringUtil.toHexDigit(b2 & 0xF);
        }
        return new String(chars);
    }

    public static byte[] hexStringToBytes(String s2) throws NumberFormatException {
        if (s2.length() % 2 != 0) {
            throw new NumberFormatException("Hex representation of byte string does not have even number of hex chars: " + s2);
        }
        byte[] ret = new byte[s2.length() / 2];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = (byte)(StringUtil.fromHexDigit(s2.charAt(i2 * 2)) << 4 | StringUtil.fromHexDigit(s2.charAt(i2 * 2 + 1)));
        }
        return ret;
    }

    public static char toHexDigit(int value) {
        return (char)(value < 10 ? 48 + value : 65 + value - 10);
    }

    public static int fromHexDigit(char c2) throws NumberFormatException {
        int ret = Character.digit(c2, 16);
        if (ret == -1) {
            throw new NumberFormatException("Not a valid hex digit: " + c2);
        }
        return ret;
    }

    public static String reverseString(String s2) {
        StringBuilder sb = new StringBuilder(s2);
        sb.reverse();
        return sb.toString();
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < strLen; ++i2) {
            if (Character.isWhitespace(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static String repeatCharNTimes(char c2, int repeatNumber) {
        char[] output = new char[repeatNumber];
        Arrays.fill(output, c2);
        return String.valueOf(output);
    }

    public static String asEmptyIfNull(Object string) {
        return string == null ? EMPTY_STRING : string.toString();
    }

    public static int levenshteinDistance(String string1, String string2, int swap, int substitution, int insertion, int deletion) {
        int i2;
        int j2;
        int[] row0 = new int[string2.length() + 1];
        int[] row1 = new int[string2.length() + 1];
        int[] row2 = new int[string2.length() + 1];
        byte[] str1 = string1.getBytes();
        byte[] str2 = string2.getBytes();
        for (j2 = 0; j2 < str2.length; ++j2) {
            row1[j2] = j2 * insertion;
        }
        for (i2 = 0; i2 < str1.length; ++i2) {
            row2[0] = (i2 + 1) * deletion;
            for (j2 = 0; j2 < str2.length; ++j2) {
                row2[j2 + 1] = row1[j2];
                if (str1[i2] != str2[j2]) {
                    int n2 = j2 + 1;
                    row2[n2] = row2[n2] + substitution;
                }
                if (i2 > 0 && j2 > 0 && str1[i2 - 1] == str2[j2] && str1[i2] == str2[j2 - 1] && row2[j2 + 1] > row0[j2 - 1] + swap) {
                    row2[j2 + 1] = row0[j2 - 1] + swap;
                }
                if (row2[j2 + 1] > row1[j2 + 1] + deletion) {
                    row2[j2 + 1] = row1[j2 + 1] + deletion;
                }
                if (row2[j2 + 1] <= row2[j2] + insertion) continue;
                row2[j2 + 1] = row2[j2] + insertion;
            }
            int[] dummy = row0;
            row0 = row1;
            row1 = row2;
            row2 = dummy;
        }
        i2 = row1[str2.length];
        return i2;
    }
}

