/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DefaultBitOutputStream
extends OutputStream
implements BitOutputStream {
    private static final byte[] bitMasks = new byte[8];
    private final OutputStream out;
    private int bufferByte = 0;
    private int bufferedNumberOfBits = 0;

    public DefaultBitOutputStream(OutputStream delegate) {
        this.out = delegate;
    }

    public void write(byte b2) throws IOException {
        this.out.write(b2);
    }

    @Override
    public void write(int value) throws IOException {
        this.out.write(value);
    }

    public String toString() {
        return "DefaultBitOutputStream: " + Integer.toBinaryString(this.bufferByte).substring(0, this.bufferedNumberOfBits);
    }

    @Override
    public void write(long bitContainer, int nofBits) throws IOException {
        if (nofBits == 0) {
            return;
        }
        if (nofBits < 1 || nofBits > 64) {
            throw new IOException("Expecting 1 to 64 bits, got: value=" + bitContainer + ", nofBits=" + nofBits);
        }
        if (nofBits <= 8) {
            this.write((byte)bitContainer, nofBits);
        } else {
            for (int i2 = nofBits - 8; i2 >= 0; i2 -= 8) {
                byte v2 = (byte)(bitContainer >>> i2);
                this.writeByte(v2);
            }
            if (nofBits % 8 != 0) {
                byte v3 = (byte)bitContainer;
                this.write(v3, nofBits % 8);
            }
        }
    }

    void write_int_LSB_0(int value, int nofBitsToWrite) throws IOException {
        if (nofBitsToWrite == 0) {
            return;
        }
        if (nofBitsToWrite < 1 || nofBitsToWrite > 32) {
            throw new IOException("Expecting 1 to 32 bits.");
        }
        if (nofBitsToWrite <= 8) {
            this.write((byte)value, nofBitsToWrite);
        } else {
            for (int i2 = nofBitsToWrite - 8; i2 >= 0; i2 -= 8) {
                byte v2 = (byte)(value >>> i2);
                this.writeByte(v2);
            }
            if (nofBitsToWrite % 8 != 0) {
                byte v3 = (byte)value;
                this.write(v3, nofBitsToWrite % 8);
            }
        }
    }

    @Override
    public void write(int bitContainer, int nofBits) throws IOException {
        this.write_int_LSB_0(bitContainer, nofBits);
    }

    private void writeByte(int value) throws IOException {
        if (this.bufferedNumberOfBits == 0) {
            this.out.write(value);
        } else {
            this.bufferByte = (value & 0xFF) >>> this.bufferedNumberOfBits | this.bufferByte;
            this.out.write(this.bufferByte);
            this.bufferByte = value << 8 - this.bufferedNumberOfBits & 0xFF;
        }
    }

    @Override
    public void write(byte bitContainer, int nofBits) throws IOException {
        if (nofBits < 0 || nofBits > 8) {
            throw new IOException("Expecting 0 to 8 bits.");
        }
        if (nofBits == 8) {
            this.writeByte(bitContainer);
        } else if (this.bufferedNumberOfBits == 0) {
            this.bufferByte = bitContainer << 8 - nofBits & 0xFF;
            this.bufferedNumberOfBits = nofBits;
        } else {
            bitContainer = (byte)(bitContainer & ~bitMasks[8 - nofBits]);
            int bits = 8 - this.bufferedNumberOfBits - nofBits;
            if (bits < 0) {
                bits = -bits;
                this.bufferByte |= bitContainer >>> bits;
                this.out.write(this.bufferByte);
                this.bufferByte = bitContainer << 8 - bits & 0xFF;
                this.bufferedNumberOfBits = bits;
            } else if (bits == 0) {
                this.bufferByte |= bitContainer;
                this.out.write(this.bufferByte);
                this.bufferedNumberOfBits = 0;
            } else {
                this.bufferByte |= bitContainer << bits;
                this.bufferedNumberOfBits = 8 - bits;
            }
        }
    }

    @Override
    public void write(boolean bit) throws IOException {
        this.write(bit ? (byte)1 : 0, 1);
    }

    @Override
    public void write(boolean bit, long repeat) throws IOException {
        for (long i2 = 0L; i2 < repeat; ++i2) {
            this.write(bit);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.bufferedNumberOfBits > 0) {
            this.out.write(this.bufferByte);
        }
        this.bufferedNumberOfBits = 0;
        this.out.flush();
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.out.write(b2);
    }

    @Override
    public void write(byte[] b2, int off, int length) throws IOException {
        this.out.write(b2, off, length);
    }

    static {
        for (int i2 = 0; i2 < 8; i2 = (int)((byte)(i2 + 1))) {
            DefaultBitOutputStream.bitMasks[i2] = (byte)(~(255 >>> i2));
        }
    }
}

