/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffman;

import htsjdk.samtools.cram.encoding.huffman.HuffmanLeaf;
import htsjdk.samtools.cram.encoding.huffman.HuffmanNode;
import htsjdk.samtools.cram.encoding.huffman.HuffmanTree;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HuffmanCode {
    public static <T> HuffmanTree<T> buildTree(int[] charFrequencies, T[] values) {
        LinkedList<HuffmanTree> list = new LinkedList<HuffmanTree>();
        for (int i2 = 0; i2 < charFrequencies.length; ++i2) {
            if (charFrequencies[i2] <= 0) continue;
            list.add(new HuffmanLeaf<T>(charFrequencies[i2], values[i2]));
        }
        Comparator comparator = new Comparator<HuffmanTree<T>>(){

            @Override
            public int compare(HuffmanTree<T> o1, HuffmanTree<T> o2) {
                return o1.frequency - o2.frequency;
            }
        };
        while (list.size() > 1) {
            Collections.sort(list, comparator);
            HuffmanTree left = (HuffmanTree)list.remove();
            HuffmanTree right = (HuffmanTree)list.remove();
            list.add(new HuffmanNode(left, right));
        }
        return list.isEmpty() ? null : (HuffmanTree)list.remove();
    }

    public static <T> void getValuesAndBitLengths(List<T> values, List<Integer> lens, HuffmanTree<T> tree) {
        TreeMap codes = new TreeMap();
        HuffmanCode.getBitCode(tree, new HuffmanBitCode(), codes);
        for (Object value : codes.keySet()) {
            HuffmanBitCode code = (HuffmanBitCode)codes.get(value);
            values.add(value);
            lens.add(code.bitLength);
        }
    }

    private static <T> void getBitCode(HuffmanTree<T> tree, HuffmanBitCode<T> code, Map<T, HuffmanBitCode<T>> codes) {
        if (tree instanceof HuffmanLeaf) {
            HuffmanLeaf leaf = (HuffmanLeaf)tree;
            HuffmanBitCode readyCode = new HuffmanBitCode();
            readyCode.bitCode = code.bitCode;
            readyCode.bitLength = code.bitLength;
            codes.put(leaf.value, readyCode);
        } else if (tree instanceof HuffmanNode) {
            HuffmanNode node = (HuffmanNode)tree;
            code.bitCode <<= 1;
            ++code.bitLength;
            HuffmanCode.getBitCode(node.left, code, codes);
            code.bitCode >>>= 1;
            --code.bitLength;
            code.bitCode = code.bitCode << 1 | 1L;
            ++code.bitLength;
            HuffmanCode.getBitCode(node.right, code, codes);
            code.bitCode >>>= 1;
            --code.bitLength;
        }
    }

    private static class HuffmanBitCode<T> {
        long bitCode;
        int bitLength;

        private HuffmanBitCode() {
        }
    }
}

