/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.SingleByteCharsetConverter;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class StringUtils {
    private static final int BYTE_RANGE = 256;
    private static byte[] allBytes = new byte[256];
    private static char[] byteToChars = new char[256];
    private static Method toPlainStringMethod;
    static final int WILD_COMPARE_MATCH_NO_WILD = 0;
    static final int WILD_COMPARE_MATCH_WITH_WILD = 1;
    static final int WILD_COMPARE_NO_MATCH = -1;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public static String consistentToString(BigDecimal decimal) {
        if (decimal == null) {
            return null;
        }
        if (toPlainStringMethod != null) {
            try {
                return (String)toPlainStringMethod.invoke((Object)decimal, null);
            }
            catch (InvocationTargetException invokeEx) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return decimal.toString();
    }

    public static final String dumpAsHex(byte[] byteBuffer, int length) {
        int i2;
        StringBuffer outputBuf = new StringBuffer(length * 4);
        int p2 = 0;
        int rows = length / 8;
        for (int i3 = 0; i3 < rows && p2 < length; ++i3) {
            int j2;
            int ptemp = p2;
            for (j2 = 0; j2 < 8; ++j2) {
                String hexVal = Integer.toHexString(byteBuffer[ptemp] & 0xFF);
                if (hexVal.length() == 1) {
                    hexVal = "0" + hexVal;
                }
                outputBuf.append(hexVal + " ");
                ++ptemp;
            }
            outputBuf.append("    ");
            for (j2 = 0; j2 < 8; ++j2) {
                if (byteBuffer[p2] > 32 && byteBuffer[p2] < 127) {
                    outputBuf.append((char)byteBuffer[p2] + " ");
                } else {
                    outputBuf.append(". ");
                }
                ++p2;
            }
            outputBuf.append("\n");
        }
        int n2 = 0;
        for (i2 = p2; i2 < length; ++i2) {
            String hexVal = Integer.toHexString(byteBuffer[i2] & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            outputBuf.append(hexVal + " ");
            ++n2;
        }
        for (i2 = n2; i2 < 8; ++i2) {
            outputBuf.append("   ");
        }
        outputBuf.append("    ");
        for (i2 = p2; i2 < length; ++i2) {
            if (byteBuffer[i2] > 32 && byteBuffer[i2] < 127) {
                outputBuf.append((char)byteBuffer[i2] + " ");
                continue;
            }
            outputBuf.append(". ");
        }
        outputBuf.append("\n");
        return outputBuf.toString();
    }

    private static boolean endsWith(byte[] dataFrom, String suffix) {
        for (int i2 = 1; i2 <= suffix.length(); ++i2) {
            int dfOffset = dataFrom.length - i2;
            int suffixOffset = suffix.length() - i2;
            if (dataFrom[dfOffset] == suffix.charAt(suffixOffset)) continue;
            return false;
        }
        return true;
    }

    public static byte[] escapeEasternUnicodeByteStream(byte[] origBytes, String origString, int offset, int length) {
        if (origBytes == null || origBytes.length == 0) {
            return origBytes;
        }
        int bytesLen = origBytes.length;
        int bufIndex = 0;
        int strIndex = 0;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(bytesLen);
        while (true) {
            if (origString.charAt(strIndex) == '\\') {
                bytesOut.write(origBytes[bufIndex++]);
            } else {
                int hiByte;
                int loByte = origBytes[bufIndex];
                if (loByte < 0) {
                    loByte += 256;
                }
                bytesOut.write(loByte);
                if (loByte >= 128) {
                    if (bufIndex < bytesLen - 1) {
                        hiByte = origBytes[bufIndex + 1];
                        if (hiByte < 0) {
                            hiByte += 256;
                        }
                        bytesOut.write(hiByte);
                        ++bufIndex;
                        if (hiByte == 92) {
                            bytesOut.write(hiByte);
                        }
                    }
                } else if (loByte == 92 && bufIndex < bytesLen - 1) {
                    hiByte = origBytes[bufIndex + 1];
                    if (hiByte < 0) {
                        hiByte += 256;
                    }
                    if (hiByte == 98) {
                        bytesOut.write(92);
                        bytesOut.write(98);
                        ++bufIndex;
                    }
                }
                ++bufIndex;
            }
            if (bufIndex >= bytesLen) break;
            ++strIndex;
        }
        return bytesOut.toByteArray();
    }

    public static char firstNonWsCharUc(String searchIn) {
        if (searchIn == null) {
            return '\u0000';
        }
        int length = searchIn.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = searchIn.charAt(i2);
            if (Character.isWhitespace(c2)) continue;
            return Character.toUpperCase(c2);
        }
        return '\u0000';
    }

    public static final String fixDecimalExponent(String dString) {
        char maybeMinusChar;
        int ePos = dString.indexOf("E");
        if (ePos == -1) {
            ePos = dString.indexOf("e");
        }
        if (ePos != -1 && dString.length() > ePos + 1 && (maybeMinusChar = dString.charAt(ePos + 1)) != '-' && maybeMinusChar != '+') {
            StringBuffer buf = new StringBuffer(dString.length() + 1);
            buf.append(dString.substring(0, ePos + 1));
            buf.append('+');
            buf.append(dString.substring(ePos + 1, dString.length()));
            dString = buf.toString();
        }
        return dString;
    }

    public static final byte[] getBytes(char[] c2, SingleByteCharsetConverter converter, String encoding, String serverEncoding, boolean parserKnowsUnicode) throws SQLException {
        try {
            byte[] b2 = null;
            if (converter != null) {
                b2 = converter.toBytes(c2);
            } else if (encoding == null) {
                b2 = new String(c2).getBytes();
            } else {
                String s2 = new String(c2);
                b2 = s2.getBytes(encoding);
                if (!parserKnowsUnicode && (encoding.equalsIgnoreCase("SJIS") || encoding.equalsIgnoreCase("BIG5") || encoding.equalsIgnoreCase("GBK")) && !encoding.equalsIgnoreCase(serverEncoding)) {
                    b2 = StringUtils.escapeEasternUnicodeByteStream(b2, s2, 0, s2.length());
                }
            }
            return b2;
        }
        catch (UnsupportedEncodingException uee) {
            throw new SQLException(Messages.getString("StringUtils.5") + encoding + Messages.getString("StringUtils.6"), "S1009");
        }
    }

    public static final byte[] getBytes(char[] c2, SingleByteCharsetConverter converter, String encoding, String serverEncoding, int offset, int length, boolean parserKnowsUnicode) throws SQLException {
        try {
            byte[] b2 = null;
            if (converter != null) {
                b2 = converter.toBytes(c2, offset, length);
            } else if (encoding == null) {
                byte[] temp = new String(c2, offset, length).getBytes();
                length = temp.length;
                b2 = new byte[length];
                System.arraycopy(temp, 0, b2, 0, length);
            } else {
                String s2 = new String(c2, offset, length);
                byte[] temp = s2.getBytes(encoding);
                length = temp.length;
                b2 = new byte[length];
                System.arraycopy(temp, 0, b2, 0, length);
                if (!parserKnowsUnicode && (encoding.equalsIgnoreCase("SJIS") || encoding.equalsIgnoreCase("BIG5") || encoding.equalsIgnoreCase("GBK")) && !encoding.equalsIgnoreCase(serverEncoding)) {
                    b2 = StringUtils.escapeEasternUnicodeByteStream(b2, s2, offset, length);
                }
            }
            return b2;
        }
        catch (UnsupportedEncodingException uee) {
            throw new SQLException(Messages.getString("StringUtils.10") + encoding + Messages.getString("StringUtils.11"), "S1009");
        }
    }

    public static final byte[] getBytes(char[] c2, String encoding, String serverEncoding, boolean parserKnowsUnicode) throws SQLException {
        try {
            SingleByteCharsetConverter converter = SingleByteCharsetConverter.getInstance(encoding, null);
            return StringUtils.getBytes(c2, converter, encoding, serverEncoding, parserKnowsUnicode);
        }
        catch (UnsupportedEncodingException uee) {
            throw new SQLException(Messages.getString("StringUtils.0") + encoding + Messages.getString("StringUtils.1"), "S1009");
        }
    }

    public static final byte[] getBytes(String s2, SingleByteCharsetConverter converter, String encoding, String serverEncoding, boolean parserKnowsUnicode) throws SQLException {
        try {
            byte[] b2 = null;
            if (converter != null) {
                b2 = converter.toBytes(s2);
            } else if (encoding == null) {
                b2 = s2.getBytes();
            } else {
                b2 = s2.getBytes(encoding);
                if (!parserKnowsUnicode && (encoding.equalsIgnoreCase("SJIS") || encoding.equalsIgnoreCase("BIG5") || encoding.equalsIgnoreCase("GBK")) && !encoding.equalsIgnoreCase(serverEncoding)) {
                    b2 = StringUtils.escapeEasternUnicodeByteStream(b2, s2, 0, s2.length());
                }
            }
            return b2;
        }
        catch (UnsupportedEncodingException uee) {
            throw new SQLException(Messages.getString("StringUtils.5") + encoding + Messages.getString("StringUtils.6"), "S1009");
        }
    }

    public static final byte[] getBytes(String s2, SingleByteCharsetConverter converter, String encoding, String serverEncoding, int offset, int length, boolean parserKnowsUnicode) throws SQLException {
        try {
            byte[] b2 = null;
            if (converter != null) {
                b2 = converter.toBytes(s2, offset, length);
            } else if (encoding == null) {
                byte[] temp = s2.substring(offset, offset + length).getBytes();
                length = temp.length;
                b2 = new byte[length];
                System.arraycopy(temp, 0, b2, 0, length);
            } else {
                byte[] temp = s2.substring(offset, offset + length).getBytes(encoding);
                length = temp.length;
                b2 = new byte[length];
                System.arraycopy(temp, 0, b2, 0, length);
                if (!parserKnowsUnicode && (encoding.equalsIgnoreCase("SJIS") || encoding.equalsIgnoreCase("BIG5") || encoding.equalsIgnoreCase("GBK")) && !encoding.equalsIgnoreCase(serverEncoding)) {
                    b2 = StringUtils.escapeEasternUnicodeByteStream(b2, s2, offset, length);
                }
            }
            return b2;
        }
        catch (UnsupportedEncodingException uee) {
            throw new SQLException(Messages.getString("StringUtils.10") + encoding + Messages.getString("StringUtils.11"), "S1009");
        }
    }

    public static final byte[] getBytes(String s2, String encoding, String serverEncoding, boolean parserKnowsUnicode) throws SQLException {
        try {
            SingleByteCharsetConverter converter = SingleByteCharsetConverter.getInstance(encoding, null);
            return StringUtils.getBytes(s2, converter, encoding, serverEncoding, parserKnowsUnicode);
        }
        catch (UnsupportedEncodingException uee) {
            throw new SQLException(Messages.getString("StringUtils.0") + encoding + Messages.getString("StringUtils.1"), "S1009");
        }
    }

    public static int getInt(byte[] buf) throws NumberFormatException {
        int s2;
        char base = '\n';
        for (s2 = 0; Character.isWhitespace((char)buf[s2]) && s2 < buf.length; ++s2) {
        }
        if (s2 == buf.length) {
            throw new NumberFormatException(new String(buf));
        }
        boolean negative = false;
        if ((char)buf[s2] == '-') {
            negative = true;
            ++s2;
        } else if ((char)buf[s2] == '+') {
            ++s2;
        }
        int save = s2;
        int cutoff = Integer.MAX_VALUE / base;
        int cutlim = Integer.MAX_VALUE % base;
        if (negative) {
            ++cutlim;
        }
        boolean overflow = false;
        int i2 = 0;
        while (s2 < buf.length) {
            char c2 = (char)buf[s2];
            if (Character.isDigit(c2)) {
                c2 = (char)(c2 - 48);
            } else {
                if (!Character.isLetter(c2)) break;
                c2 = (char)(Character.toUpperCase(c2) - 65 + 10);
            }
            if (c2 >= base) break;
            if (i2 > cutoff || i2 == cutoff && c2 > cutlim) {
                overflow = true;
            } else {
                i2 *= base;
                i2 += c2;
            }
            ++s2;
        }
        if (s2 == save) {
            throw new NumberFormatException(new String(buf));
        }
        if (overflow) {
            throw new NumberFormatException(new String(buf));
        }
        return negative ? -i2 : i2;
    }

    public static long getLong(byte[] buf) throws NumberFormatException {
        int s2;
        char base = '\n';
        for (s2 = 0; Character.isWhitespace((char)buf[s2]) && s2 < buf.length; ++s2) {
        }
        if (s2 == buf.length) {
            throw new NumberFormatException(new String(buf));
        }
        boolean negative = false;
        if ((char)buf[s2] == '-') {
            negative = true;
            ++s2;
        } else if ((char)buf[s2] == '+') {
            ++s2;
        }
        int save = s2;
        long cutoff = Long.MAX_VALUE / (long)base;
        long cutlim = (int)(Long.MAX_VALUE % (long)base);
        if (negative) {
            ++cutlim;
        }
        boolean overflow = false;
        long i2 = 0L;
        while (s2 < buf.length) {
            char c2 = (char)buf[s2];
            if (Character.isDigit(c2)) {
                c2 = (char)(c2 - 48);
            } else {
                if (!Character.isLetter(c2)) break;
                c2 = (char)(Character.toUpperCase(c2) - 65 + 10);
            }
            if (c2 >= base) break;
            if (i2 > cutoff || i2 == cutoff && (long)c2 > cutlim) {
                overflow = true;
            } else {
                i2 *= (long)base;
                i2 += (long)c2;
            }
            ++s2;
        }
        if (s2 == save) {
            throw new NumberFormatException(new String(buf));
        }
        if (overflow) {
            throw new NumberFormatException(new String(buf));
        }
        return negative ? -i2 : i2;
    }

    public static short getShort(byte[] buf) throws NumberFormatException {
        int s2;
        char base = '\n';
        for (s2 = 0; Character.isWhitespace((char)buf[s2]) && s2 < buf.length; ++s2) {
        }
        if (s2 == buf.length) {
            throw new NumberFormatException(new String(buf));
        }
        boolean negative = false;
        if ((char)buf[s2] == '-') {
            negative = true;
            ++s2;
        } else if ((char)buf[s2] == '+') {
            ++s2;
        }
        int save = s2;
        short cutoff = (short)(Short.MAX_VALUE / base);
        short cutlim = (short)(Short.MAX_VALUE % base);
        if (negative) {
            cutlim = (short)(cutlim + 1);
        }
        boolean overflow = false;
        short i2 = 0;
        while (s2 < buf.length) {
            char c2 = (char)buf[s2];
            if (Character.isDigit(c2)) {
                c2 = (char)(c2 - 48);
            } else {
                if (!Character.isLetter(c2)) break;
                c2 = (char)(Character.toUpperCase(c2) - 65 + 10);
            }
            if (c2 >= base) break;
            if (i2 > cutoff || i2 == cutoff && c2 > cutlim) {
                overflow = true;
            } else {
                i2 = (short)(i2 * base);
                i2 = (short)(i2 + c2);
            }
            ++s2;
        }
        if (s2 == save) {
            throw new NumberFormatException(new String(buf));
        }
        if (overflow) {
            throw new NumberFormatException(new String(buf));
        }
        return negative ? (short)(-i2) : i2;
    }

    public static final int indexOfIgnoreCase(int startingPosition, String searchIn, String searchFor) {
        if (searchIn == null || searchFor == null || startingPosition > searchIn.length()) {
            return -1;
        }
        int patternLength = searchFor.length();
        int stringLength = searchIn.length();
        int stopSearchingAt = stringLength - patternLength;
        int i2 = startingPosition;
        if (patternLength == 0) {
            return -1;
        }
        char firstCharOfPatternUc = Character.toUpperCase(searchFor.charAt(0));
        char firstCharOfPatternLc = Character.toLowerCase(searchFor.charAt(0));
        block0: while (true) {
            if (i2 < stopSearchingAt && Character.toUpperCase(searchIn.charAt(i2)) != firstCharOfPatternUc && Character.toLowerCase(searchIn.charAt(i2)) != firstCharOfPatternLc) {
                ++i2;
                continue;
            }
            if (i2 > stopSearchingAt) {
                return -1;
            }
            int j2 = i2 + 1;
            int end = j2 + patternLength - 1;
            int k2 = 1;
            while (j2 < end) {
                int searchInPos = j2++;
                int searchForPos = k2++;
                if (Character.toUpperCase(searchIn.charAt(searchInPos)) != Character.toUpperCase(searchFor.charAt(searchForPos))) {
                    ++i2;
                    continue block0;
                }
                if (Character.toLowerCase(searchIn.charAt(searchInPos)) == Character.toLowerCase(searchFor.charAt(searchForPos))) continue;
                ++i2;
                continue block0;
            }
            break;
        }
        return i2;
    }

    public static final int indexOfIgnoreCase(String searchIn, String searchFor) {
        return StringUtils.indexOfIgnoreCase(0, searchIn, searchFor);
    }

    public static int indexOfIgnoreCaseRespectMarker(int startAt, String src, String target, String marker, String markerCloses, boolean allowBackslashEscapes) {
        char contextMarker = '\u0000';
        boolean escaped = false;
        int markerTypeFound = 0;
        int srcLength = src.length();
        int ind = 0;
        for (int i2 = startAt; i2 < srcLength; ++i2) {
            char c2 = src.charAt(i2);
            if (allowBackslashEscapes && c2 == '\\') {
                escaped = !escaped;
                continue;
            }
            if (c2 == markerCloses.charAt(markerTypeFound) && !escaped) {
                contextMarker = '\u0000';
                continue;
            }
            ind = marker.indexOf(c2);
            if (ind != -1 && !escaped && contextMarker == '\u0000') {
                markerTypeFound = ind;
                contextMarker = c2;
                continue;
            }
            if (c2 != target.charAt(0) || escaped || contextMarker != '\u0000' || StringUtils.indexOfIgnoreCase(i2, src, target) == -1) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOfIgnoreCaseRespectQuotes(int startAt, String src, String target, char quoteChar, boolean allowBackslashEscapes) {
        char contextMarker = '\u0000';
        boolean escaped = false;
        int srcLength = src.length();
        for (int i2 = startAt; i2 < srcLength; ++i2) {
            char c2 = src.charAt(i2);
            if (allowBackslashEscapes && c2 == '\\') {
                escaped = !escaped;
                continue;
            }
            if (c2 == contextMarker && !escaped) {
                contextMarker = '\u0000';
                continue;
            }
            if (c2 == quoteChar && !escaped && contextMarker == '\u0000') {
                contextMarker = c2;
                continue;
            }
            if (c2 != target.charAt(0) || escaped || contextMarker != '\u0000' || !StringUtils.startsWithIgnoreCase(src, i2, target)) continue;
            return i2;
        }
        return -1;
    }

    public static final List split(String stringToSplit, String delimitter, boolean trim) {
        if (stringToSplit == null) {
            return new ArrayList();
        }
        if (delimitter == null) {
            throw new IllegalArgumentException();
        }
        StringTokenizer tokenizer = new StringTokenizer(stringToSplit, delimitter, false);
        ArrayList<String> splitTokens = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (trim) {
                token = token.trim();
            }
            splitTokens.add(token);
        }
        return splitTokens;
    }

    public static final List split(String stringToSplit, String delimiter, String markers, String markerCloses, boolean trim) {
        String token;
        if (stringToSplit == null) {
            return new ArrayList();
        }
        if (delimiter == null) {
            throw new IllegalArgumentException();
        }
        int delimPos = 0;
        int currentPos = 0;
        ArrayList<String> splitTokens = new ArrayList<String>();
        while ((delimPos = StringUtils.indexOfIgnoreCaseRespectMarker(currentPos, stringToSplit, delimiter, markers, markerCloses, false)) != -1) {
            token = stringToSplit.substring(currentPos, delimPos);
            if (trim) {
                token = token.trim();
            }
            splitTokens.add(token);
            currentPos = delimPos + 1;
        }
        if (currentPos < stringToSplit.length()) {
            token = stringToSplit.substring(currentPos);
            if (trim) {
                token = token.trim();
            }
            splitTokens.add(token);
        }
        return splitTokens;
    }

    private static boolean startsWith(byte[] dataFrom, String chars) {
        for (int i2 = 0; i2 < chars.length(); ++i2) {
            if (dataFrom[i2] == chars.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(String searchIn, int startAt, String searchFor) {
        return searchIn.regionMatches(true, startAt, searchFor, 0, searchFor.length());
    }

    public static boolean startsWithIgnoreCase(String searchIn, String searchFor) {
        return StringUtils.startsWithIgnoreCase(searchIn, 0, searchFor);
    }

    public static boolean startsWithIgnoreCaseAndNonAlphaNumeric(String searchIn, String searchFor) {
        char c2;
        if (searchIn == null) {
            return searchFor == null;
        }
        int beginPos = 0;
        int inLength = searchIn.length();
        for (beginPos = 0; beginPos < inLength && !Character.isLetterOrDigit(c2 = searchIn.charAt(beginPos)); ++beginPos) {
        }
        return StringUtils.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    public static boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor) {
        if (searchIn == null) {
            return searchFor == null;
        }
        int beginPos = 0;
        int inLength = searchIn.length();
        for (beginPos = 0; beginPos < inLength && Character.isWhitespace(searchIn.charAt(beginPos)); ++beginPos) {
        }
        return StringUtils.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    public static byte[] stripEnclosure(byte[] source, String prefix, String suffix) {
        if (source.length >= prefix.length() + suffix.length() && StringUtils.startsWith(source, prefix) && StringUtils.endsWith(source, suffix)) {
            int totalToStrip = prefix.length() + suffix.length();
            int enclosedLength = source.length - totalToStrip;
            byte[] enclosed = new byte[enclosedLength];
            int startPos = prefix.length();
            int numToCopy = enclosed.length;
            System.arraycopy(source, startPos, enclosed, 0, numToCopy);
            return enclosed;
        }
        return source;
    }

    public static final String toAsciiString(byte[] buffer) {
        return StringUtils.toAsciiString(buffer, 0, buffer.length);
    }

    public static final String toAsciiString(byte[] buffer, int startPos, int length) {
        char[] charArray = new char[length];
        int readpoint = startPos;
        for (int i2 = 0; i2 < length; ++i2) {
            charArray[i2] = (char)buffer[readpoint];
            ++readpoint;
        }
        return new String(charArray);
    }

    public static int wildCompare(String searchIn, String searchForWildcard) {
        if (searchIn == null || searchForWildcard == null) {
            return -1;
        }
        if (searchForWildcard.equals("%")) {
            return 1;
        }
        int result = -1;
        char wildcardMany = '%';
        char wildcardOne = '_';
        char wildcardEscape = '\\';
        int searchForPos = 0;
        int searchForEnd = searchForWildcard.length();
        int searchInPos = 0;
        int searchInEnd = searchIn.length();
        while (searchForPos != searchForEnd) {
            char wildstrChar = searchForWildcard.charAt(searchForPos);
            while (searchForWildcard.charAt(searchForPos) != wildcardMany && wildstrChar != wildcardOne) {
                if (searchForWildcard.charAt(searchForPos) == wildcardEscape && searchForPos + 1 != searchForEnd) {
                    ++searchForPos;
                }
                if (searchInPos == searchInEnd || Character.toUpperCase(searchForWildcard.charAt(searchForPos++)) != Character.toUpperCase(searchIn.charAt(searchInPos++))) {
                    return 1;
                }
                if (searchForPos == searchForEnd) {
                    return searchInPos != searchInEnd ? 1 : 0;
                }
                result = 1;
            }
            if (searchForWildcard.charAt(searchForPos) == wildcardOne) {
                do {
                    if (searchInPos == searchInEnd) {
                        return result;
                    }
                    ++searchInPos;
                } while (++searchForPos < searchForEnd && searchForWildcard.charAt(searchForPos) == wildcardOne);
                if (searchForPos == searchForEnd) break;
            }
            if (searchForWildcard.charAt(searchForPos) != wildcardMany) continue;
            ++searchForPos;
            while (searchForPos != searchForEnd) {
                if (searchForWildcard.charAt(searchForPos) != wildcardMany) {
                    if (searchForWildcard.charAt(searchForPos) != wildcardOne) break;
                    if (searchInPos == searchInEnd) {
                        return -1;
                    }
                    ++searchInPos;
                }
                ++searchForPos;
            }
            if (searchForPos == searchForEnd) {
                return 0;
            }
            if (searchInPos == searchInEnd) {
                return -1;
            }
            char cmp = searchForWildcard.charAt(searchForPos);
            if (cmp == wildcardEscape && searchForPos + 1 != searchForEnd) {
                cmp = searchForWildcard.charAt(++searchForPos);
            }
            ++searchForPos;
            while (true) {
                if (searchInPos != searchInEnd && Character.toUpperCase(searchIn.charAt(searchInPos)) != Character.toUpperCase(cmp)) {
                    ++searchInPos;
                    continue;
                }
                if (searchInPos++ == searchInEnd) {
                    return -1;
                }
                int tmp = StringUtils.wildCompare(searchIn, searchForWildcard);
                if (tmp <= 0) {
                    return tmp;
                }
                if (searchInPos == searchInEnd || searchForWildcard.charAt(0) == wildcardMany) break;
            }
            return -1;
        }
        return searchInPos != searchInEnd ? 1 : 0;
    }

    static byte[] s2b(String s2, Connection conn) throws SQLException {
        if (s2 == null) {
            return null;
        }
        if (conn != null && conn.getUseUnicode()) {
            try {
                String encoding = conn.getEncoding();
                if (encoding == null) {
                    return s2.getBytes();
                }
                SingleByteCharsetConverter converter = conn.getCharsetConverter(encoding);
                if (converter != null) {
                    return converter.toBytes(s2);
                }
                return s2.getBytes(encoding);
            }
            catch (UnsupportedEncodingException E) {
                return s2.getBytes();
            }
        }
        return s2.getBytes();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        for (int i2 = -128; i2 <= 127; ++i2) {
            StringUtils.allBytes[i2 - -128] = (byte)i2;
        }
        String allBytesString = new String(allBytes, 0, 255);
        int allBytesStringLen = allBytesString.length();
        for (int i3 = 0; i3 < 255 && i3 < allBytesStringLen; ++i3) {
            StringUtils.byteToChars[i3] = allBytesString.charAt(i3);
        }
        try {
            toPlainStringMethod = (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = StringUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getMethod("toPlainString", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

