/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.MysqlParameterMetadata;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.ResultSetMetaData;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.TimeUtil;
import com.mysql.jdbc.profiler.ProfileEventSink;
import com.mysql.jdbc.profiler.ProfilerEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;

public class ServerPreparedStatement
extends PreparedStatement {
    protected static final int BLOB_STREAM_READ_BUF_SIZE = 8192;
    private static final byte MAX_DATE_REP_LENGTH = 5;
    private static final byte MAX_DATETIME_REP_LENGTH = 12;
    private static final byte MAX_TIME_REP_LENGTH = 13;
    private Calendar dateTimeBindingCal = null;
    private boolean detectedLongParameterSwitch = false;
    private int fieldCount;
    private boolean invalid = false;
    private SQLException invalidationException;
    private boolean isSelectQuery;
    private Buffer outByteBuffer;
    private BindValue[] parameterBindings;
    private Field[] parameterFields;
    private Field[] resultFields;
    private boolean sendTypesToServer = false;
    private long serverStatementId;
    private int stringTypeCode = 254;
    private boolean serverNeedsResetBeforeEachExecution;
    protected boolean isCached = false;

    private static void storeTime(Buffer intoBuf, Time tm) throws SQLException {
        intoBuf.ensureCapacity(9);
        intoBuf.writeByte((byte)8);
        intoBuf.writeByte((byte)0);
        intoBuf.writeLong(0L);
        Calendar cal = Calendar.getInstance();
        cal.setTime(tm);
        intoBuf.writeByte((byte)cal.get(11));
        intoBuf.writeByte((byte)cal.get(12));
        intoBuf.writeByte((byte)cal.get(13));
    }

    public ServerPreparedStatement(Connection conn, String sql, String catalog) throws SQLException {
        super(conn, catalog);
        this.checkNullOrEmptyQuery(sql);
        this.isSelectQuery = StringUtils.startsWithIgnoreCaseAndWs(sql, "SELECT");
        this.serverNeedsResetBeforeEachExecution = this.connection.versionMeetsMinimum(5, 0, 0) ? !this.connection.versionMeetsMinimum(5, 0, 3) : !this.connection.versionMeetsMinimum(4, 1, 10);
        this.useTrueBoolean = this.connection.versionMeetsMinimum(3, 21, 23);
        this.hasLimitClause = StringUtils.indexOfIgnoreCase(sql, "LIMIT") != -1;
        this.firstCharOfStmt = StringUtils.firstNonWsCharUc(sql);
        this.originalSql = sql;
        this.stringTypeCode = this.connection.versionMeetsMinimum(4, 1, 2) ? 253 : 254;
        try {
            this.serverPrepare(sql);
        }
        catch (SQLException sqlEx) {
            this.realClose(false);
            throw sqlEx;
        }
        catch (Exception ex) {
            this.realClose(false);
            throw new SQLException(ex.toString(), "S1000");
        }
    }

    public synchronized void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        this.batchedArgs.add(new BatchedBindValues(this.parameterBindings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String asSql(boolean quoteStreamsAndUnknowns) throws SQLException {
        String string;
        block16: {
            if (this.isClosed) {
                return "statement has been closed, no further internal information available";
            }
            PreparedStatement pStmtForSub = null;
            try {
                pStmtForSub = new PreparedStatement(this.connection, this.originalSql, this.currentCatalog);
                int numParameters = pStmtForSub.parameterCount;
                int ourNumParameters = this.parameterCount;
                block13: for (int i2 = 0; i2 < numParameters && i2 < ourNumParameters; ++i2) {
                    if (this.parameterBindings[i2] == null) continue;
                    if (this.parameterBindings[i2].isNull) {
                        pStmtForSub.setNull(i2 + 1, 0);
                        continue;
                    }
                    BindValue bindValue = this.parameterBindings[i2];
                    switch (bindValue.bufferType) {
                        case 1: {
                            pStmtForSub.setByte(i2 + 1, bindValue.byteBinding);
                            continue block13;
                        }
                        case 2: {
                            pStmtForSub.setShort(i2 + 1, bindValue.shortBinding);
                            continue block13;
                        }
                        case 3: {
                            pStmtForSub.setInt(i2 + 1, bindValue.intBinding);
                            continue block13;
                        }
                        case 8: {
                            pStmtForSub.setLong(i2 + 1, bindValue.longBinding);
                            continue block13;
                        }
                        case 4: {
                            pStmtForSub.setFloat(i2 + 1, bindValue.floatBinding);
                            continue block13;
                        }
                        case 5: {
                            pStmtForSub.setDouble(i2 + 1, bindValue.doubleBinding);
                            continue block13;
                        }
                        default: {
                            pStmtForSub.setObject(i2 + 1, this.parameterBindings[i2].value);
                        }
                    }
                }
                string = pStmtForSub.asSql(quoteStreamsAndUnknowns);
                Object var8_8 = null;
                if (pStmtForSub == null) break block16;
            }
            catch (Throwable throwable) {
                block17: {
                    Object var8_9 = null;
                    if (pStmtForSub == null) break block17;
                    try {
                        pStmtForSub.close();
                    }
                    catch (SQLException sqlEx) {}
                }
                throw throwable;
            }
            try {
                pStmtForSub.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        return string;
    }

    protected void checkClosed() throws SQLException {
        if (this.invalid) {
            throw this.invalidationException;
        }
        super.checkClosed();
    }

    public synchronized void clearParameters() throws SQLException {
        this.checkClosed();
        this.clearParametersInternal(true);
    }

    private void clearParametersInternal(boolean clearServerParameters) throws SQLException {
        boolean hadLongData = false;
        if (this.parameterBindings != null) {
            for (int i2 = 0; i2 < this.parameterCount; ++i2) {
                if (this.parameterBindings[i2] != null && this.parameterBindings[i2].isLongData) {
                    hadLongData = true;
                }
                this.parameterBindings[i2].reset();
            }
        }
        if (clearServerParameters && hadLongData) {
            this.serverResetStatement();
            this.detectedLongParameterSwitch = false;
        }
    }

    protected void setClosed(boolean flag) {
        this.isClosed = flag;
    }

    public void close() throws SQLException {
        if (this.isCached) {
            this.isClosed = true;
            this.connection.recachePreparedStatement(this);
            return;
        }
        this.realClose(true);
    }

    private void dumpCloseForTestcase() {
        StringBuffer buf = new StringBuffer();
        this.connection.generateConnectionCommentBlock(buf);
        buf.append("DEALLOCATE PREPARE debug_stmt_");
        buf.append(this.statementId);
        buf.append(";\n");
        this.connection.dumpTestcaseQuery(buf.toString());
    }

    private void dumpExecuteForTestcase() throws SQLException {
        int i2;
        StringBuffer buf = new StringBuffer();
        for (i2 = 0; i2 < this.parameterCount; ++i2) {
            this.connection.generateConnectionCommentBlock(buf);
            buf.append("SET @debug_stmt_param");
            buf.append(this.statementId);
            buf.append("_");
            buf.append(i2);
            buf.append("=");
            if (this.parameterBindings[i2].isNull) {
                buf.append("NULL");
            } else {
                buf.append(this.parameterBindings[i2].toString(true));
            }
            buf.append(";\n");
        }
        this.connection.generateConnectionCommentBlock(buf);
        buf.append("EXECUTE debug_stmt_");
        buf.append(this.statementId);
        if (this.parameterCount > 0) {
            buf.append(" USING ");
            for (i2 = 0; i2 < this.parameterCount; ++i2) {
                if (i2 > 0) {
                    buf.append(", ");
                }
                buf.append("@debug_stmt_param");
                buf.append(this.statementId);
                buf.append("_");
                buf.append(i2);
            }
        }
        buf.append(";\n");
        this.connection.dumpTestcaseQuery(buf.toString());
    }

    private void dumpPrepareForTestcase() throws SQLException {
        StringBuffer buf = new StringBuffer(this.originalSql.length() + 64);
        this.connection.generateConnectionCommentBlock(buf);
        buf.append("PREPARE debug_stmt_");
        buf.append(this.statementId);
        buf.append(" FROM \"");
        buf.append(this.originalSql);
        buf.append("\";\n");
        this.connection.dumpTestcaseQuery(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int[] executeBatch() throws SQLException {
        if (this.connection.isReadOnly()) {
            throw new SQLException(Messages.getString("ServerPreparedStatement.2") + Messages.getString("ServerPreparedStatement.3"), "S1009");
        }
        this.checkClosed();
        Object object = this.connection.getMutex();
        synchronized (object) {
            int[] nArray;
            this.clearWarnings();
            BindValue[] oldBindValues = this.parameterBindings;
            try {
                int[] updateCounts = null;
                if (this.batchedArgs != null) {
                    int nbrCommands = this.batchedArgs.size();
                    updateCounts = new int[nbrCommands];
                    if (this.retrieveGeneratedKeys) {
                        this.batchedGeneratedKeys = new ArrayList(nbrCommands);
                    }
                    for (int i2 = 0; i2 < nbrCommands; ++i2) {
                        updateCounts[i2] = -3;
                    }
                    Throwable sqlEx = null;
                    int commandIndex = 0;
                    BindValue[] previousBindValuesForBatch = null;
                    for (commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                        Object arg = this.batchedArgs.get(commandIndex);
                        if (arg instanceof String) {
                            updateCounts[commandIndex] = this.executeUpdate((String)arg);
                            continue;
                        }
                        this.parameterBindings = ((BatchedBindValues)arg).batchedParameterValues;
                        try {
                            if (previousBindValuesForBatch != null) {
                                for (int j2 = 0; j2 < this.parameterBindings.length; ++j2) {
                                    if (this.parameterBindings[j2].bufferType == previousBindValuesForBatch[j2].bufferType) continue;
                                    this.sendTypesToServer = true;
                                    break;
                                }
                            }
                            try {
                                updateCounts[commandIndex] = this.executeUpdate(false);
                            }
                            finally {
                                previousBindValuesForBatch = this.parameterBindings;
                            }
                            if (!this.retrieveGeneratedKeys) continue;
                            java.sql.ResultSet rs = null;
                            try {
                                rs = this.getGeneratedKeysInternal();
                                while (rs.next()) {
                                    this.batchedGeneratedKeys.add(new byte[][]{rs.getBytes(1)});
                                }
                                continue;
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        catch (SQLException ex) {
                            updateCounts[commandIndex] = -3;
                            if (!this.continueBatchOnError) {
                                int[] newUpdateCounts = new int[commandIndex];
                                System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                                throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                            }
                            sqlEx = ex;
                        }
                    }
                    if (sqlEx != null) {
                        throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                    }
                }
                nArray = updateCounts != null ? updateCounts : new int[]{};
                Object var13_17 = null;
                this.parameterBindings = oldBindValues;
                this.sendTypesToServer = true;
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                this.parameterBindings = oldBindValues;
                this.sendTypesToServer = true;
                this.clearBatch();
                throw throwable;
            }
            this.clearBatch();
            return nArray;
        }
    }

    protected ResultSet executeInternal(int maxRowsToRetrieve, Buffer sendPacket, boolean createStreamingResultSet, boolean queryIsSelectOnly, boolean unpackFields, boolean isBatch) throws SQLException {
        ++this.numberOfExecutions;
        try {
            return this.serverExecute(maxRowsToRetrieve, createStreamingResultSet);
        }
        catch (SQLException sqlEx) {
            if (this.connection.getEnablePacketDebug()) {
                this.connection.getIO().dumpPacketRingBuffer();
            }
            if (this.connection.getDumpQueriesOnException()) {
                String extractedSql = this.toString();
                StringBuffer messageBuf = new StringBuffer(extractedSql.length() + 32);
                messageBuf.append("\n\nQuery being executed when exception was thrown:\n\n");
                messageBuf.append(extractedSql);
                sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
            }
            throw sqlEx;
        }
        catch (Exception ex) {
            if (this.connection.getEnablePacketDebug()) {
                this.connection.getIO().dumpPacketRingBuffer();
            }
            SQLException sqlEx = new SQLException(ex.toString(), "S1000");
            if (this.connection.getDumpQueriesOnException()) {
                String extractedSql = this.toString();
                StringBuffer messageBuf = new StringBuffer(extractedSql.length() + 32);
                messageBuf.append("\n\nQuery being executed when exception was thrown:\n\n");
                messageBuf.append(extractedSql);
                sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
            }
            throw sqlEx;
        }
    }

    protected Buffer fillSendPacket() throws SQLException {
        return null;
    }

    protected Buffer fillSendPacket(byte[][] batchedParameterStrings, InputStream[] batchedParameterStreams, boolean[] batchedIsStream, int[] batchedStreamLengths) throws SQLException {
        return null;
    }

    private BindValue getBinding(int parameterIndex, boolean forLongData) throws SQLException {
        this.checkClosed();
        if (this.parameterBindings.length == 0) {
            throw new SQLException(Messages.getString("ServerPreparedStatement.8"), "S1009");
        }
        if (--parameterIndex < 0 || parameterIndex >= this.parameterBindings.length) {
            throw new SQLException(Messages.getString("ServerPreparedStatement.9") + (parameterIndex + 1) + Messages.getString("ServerPreparedStatement.10") + this.parameterBindings.length, "S1009");
        }
        if (this.parameterBindings[parameterIndex] == null) {
            this.parameterBindings[parameterIndex] = new BindValue();
        } else if (this.parameterBindings[parameterIndex].isLongData && !forLongData) {
            this.detectedLongParameterSwitch = true;
        }
        this.parameterBindings[parameterIndex].isSet = true;
        this.parameterBindings[parameterIndex].boundBeforeExecutionNum = this.numberOfExecutions;
        return this.parameterBindings[parameterIndex];
    }

    synchronized byte[] getBytes(int parameterIndex) throws SQLException {
        BindValue bindValue = this.getBinding(parameterIndex, false);
        if (bindValue.isNull) {
            return null;
        }
        if (bindValue.isLongData) {
            throw new NotImplemented();
        }
        if (this.outByteBuffer == null) {
            this.outByteBuffer = Buffer.allocateNew(this.connection.getNetBufferLength(), false);
        }
        this.outByteBuffer.clear();
        int originalPosition = this.outByteBuffer.getPosition();
        this.storeBinding(this.outByteBuffer, bindValue, this.connection.getIO());
        int newPosition = this.outByteBuffer.getPosition();
        int length = newPosition - originalPosition;
        byte[] valueAsBytes = new byte[length];
        System.arraycopy(this.outByteBuffer.getByteBuffer(), originalPosition, valueAsBytes, 0, length);
        return valueAsBytes;
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.resultFields == null) {
            return null;
        }
        return new ResultSetMetaData(this.resultFields);
    }

    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.parameterMetaData == null) {
            this.parameterMetaData = new MysqlParameterMetadata(this.parameterFields, this.parameterCount);
        }
        return this.parameterMetaData;
    }

    boolean isNull(int paramIndex) {
        throw new IllegalArgumentException(Messages.getString("ServerPreparedStatement.7"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void realClose(boolean calledExplicitly) throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.connection != null) {
            if (this.connection.getAutoGenerateTestcaseScript()) {
                this.dumpCloseForTestcase();
            }
            Connection connection = this.connection;
            synchronized (connection) {
                Object object = this.connection.getMutex();
                synchronized (object) {
                    SQLException exceptionDuringClose = null;
                    if (calledExplicitly) {
                        try {
                            MysqlIO mysql = this.connection.getIO();
                            Buffer packet = mysql.getSharedSendPacket();
                            packet.writeByte((byte)25);
                            packet.writeLong(this.serverStatementId);
                            mysql.sendCommand(25, null, packet, true, null);
                        }
                        catch (SQLException sqlEx) {
                            exceptionDuringClose = sqlEx;
                        }
                    }
                    super.realClose(calledExplicitly);
                    this.clearParametersInternal(false);
                    this.parameterBindings = null;
                    this.parameterFields = null;
                    this.resultFields = null;
                    if (exceptionDuringClose != null) {
                        throw exceptionDuringClose;
                    }
                }
            }
        }
    }

    protected void rePrepare() throws SQLException {
        this.invalidationException = null;
        try {
            this.serverPrepare(this.originalSql);
        }
        catch (SQLException sqlEx) {
            this.invalidationException = sqlEx;
        }
        catch (Exception ex) {
            this.invalidationException = new SQLException(ex.toString(), "S1000");
        }
        if (this.invalidationException != null) {
            this.invalid = true;
            this.parameterBindings = null;
            this.parameterFields = null;
            this.resultFields = null;
            if (this.results != null) {
                try {
                    this.results.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.connection != null) {
                if (this.maxRowsChanged) {
                    this.connection.unsetMaxRows(this);
                }
                if (!this.connection.getDontTrackOpenResources()) {
                    this.connection.unregisterStatement(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet serverExecute(int maxRowsToRetrieve, boolean createStreamingResultSet) throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            int i2;
            int i3;
            if (this.detectedLongParameterSwitch) {
                boolean firstFound = false;
                long boundTimeToCheck = 0L;
                for (int i4 = 0; i4 < this.parameterCount - 1; ++i4) {
                    if (!this.parameterBindings[i4].isLongData) continue;
                    if (firstFound && boundTimeToCheck != this.parameterBindings[i4].boundBeforeExecutionNum) {
                        throw new SQLException(Messages.getString("ServerPreparedStatement.11") + Messages.getString("ServerPreparedStatement.12"), "S1C00");
                    }
                    firstFound = true;
                    boundTimeToCheck = this.parameterBindings[i4].boundBeforeExecutionNum;
                }
                this.serverResetStatement();
            }
            for (i3 = 0; i3 < this.parameterCount; ++i3) {
                if (this.parameterBindings[i3].isSet) continue;
                throw new SQLException(Messages.getString("ServerPreparedStatement.13") + (i3 + 1) + Messages.getString("ServerPreparedStatement.14"), "S1009");
            }
            for (i3 = 0; i3 < this.parameterCount; ++i3) {
                if (!this.parameterBindings[i3].isLongData) continue;
                this.serverLongData(i3, this.parameterBindings[i3]);
            }
            if (this.connection.getAutoGenerateTestcaseScript()) {
                this.dumpExecuteForTestcase();
            }
            MysqlIO mysql = this.connection.getIO();
            Buffer packet = mysql.getSharedSendPacket();
            packet.clear();
            packet.writeByte((byte)23);
            packet.writeLong(this.serverStatementId);
            if (this.connection.versionMeetsMinimum(4, 1, 2)) {
                packet.writeByte((byte)0);
                packet.writeLong(1L);
            }
            int nullCount = (this.parameterCount + 7) / 8;
            int nullBitsPosition = packet.getPosition();
            for (int i5 = 0; i5 < nullCount; ++i5) {
                packet.writeByte((byte)0);
            }
            byte[] nullBitsBuffer = new byte[nullCount];
            packet.writeByte(this.sendTypesToServer ? (byte)1 : 0);
            if (this.sendTypesToServer) {
                for (i2 = 0; i2 < this.parameterCount; ++i2) {
                    packet.writeInt(this.parameterBindings[i2].bufferType);
                }
            }
            for (i2 = 0; i2 < this.parameterCount; ++i2) {
                if (this.parameterBindings[i2].isLongData) continue;
                if (!this.parameterBindings[i2].isNull) {
                    this.storeBinding(packet, this.parameterBindings[i2], mysql);
                    continue;
                }
                int n2 = i2 / 8;
                nullBitsBuffer[n2] = (byte)(nullBitsBuffer[n2] | 1 << (i2 & 7));
            }
            int endPosition = packet.getPosition();
            packet.setPosition(nullBitsPosition);
            packet.writeBytesNoNull(nullBitsBuffer);
            packet.setPosition(endPosition);
            long begin = 0L;
            if (this.connection.getProfileSql() || this.connection.getLogSlowQueries() || this.connection.getGatherPerformanceMetrics()) {
                begin = System.currentTimeMillis();
            }
            Buffer resultPacket = mysql.sendCommand(23, null, packet, false, null);
            this.connection.incrementNumberOfPreparedExecutes();
            if (this.connection.getProfileSql()) {
                this.eventSink = ProfileEventSink.getInstance(this.connection);
                this.eventSink.consumeEvent(new ProfilerEvent(4, "", this.currentCatalog, this.connection.getId(), this.statementId, -1, System.currentTimeMillis(), (int)(System.currentTimeMillis() - begin), null, new Throwable(), this.truncateQueryToLog(this.asSql(true))));
            }
            ResultSet rs = mysql.readAllResults(this, maxRowsToRetrieve, this.resultSetType, this.resultSetConcurrency, createStreamingResultSet, this.currentCatalog, resultPacket, true, this.fieldCount, true);
            if (!createStreamingResultSet && this.serverNeedsResetBeforeEachExecution) {
                this.serverResetStatement();
            }
            this.sendTypesToServer = false;
            this.results = rs;
            if (this.connection.getLogSlowQueries() || this.connection.getGatherPerformanceMetrics()) {
                long elapsedTime = System.currentTimeMillis() - begin;
                if (this.connection.getLogSlowQueries() && elapsedTime >= (long)this.connection.getSlowQueryThresholdMillis()) {
                    StringBuffer mesgBuf = new StringBuffer(48 + this.originalSql.length());
                    mesgBuf.append(Messages.getString("ServerPreparedStatement.15"));
                    mesgBuf.append(this.connection.getSlowQueryThresholdMillis());
                    mesgBuf.append(Messages.getString("ServerPreparedStatement.15a"));
                    mesgBuf.append(elapsedTime);
                    mesgBuf.append(Messages.getString("ServerPreparedStatement.16"));
                    mesgBuf.append("as prepared: ");
                    mesgBuf.append(this.originalSql);
                    mesgBuf.append("\n\n with parameters bound:\n\n");
                    mesgBuf.append(this.asSql(true));
                    this.connection.getLog().logWarn(mesgBuf.toString());
                    if (this.connection.getExplainSlowQueries()) {
                        String queryAsString = this.asSql(true);
                        mysql.explainSlowQuery(queryAsString.getBytes(), queryAsString);
                    }
                }
                if (this.connection.getGatherPerformanceMetrics()) {
                    this.connection.registerQueryExecutionTime(elapsedTime);
                }
            }
            if (mysql.hadWarnings()) {
                mysql.scanForAndThrowDataTruncation();
            }
            return rs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverLongData(int parameterIndex, BindValue longData) throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            MysqlIO mysql = this.connection.getIO();
            Buffer packet = mysql.getSharedSendPacket();
            Object value = longData.value;
            if (value instanceof byte[]) {
                packet.clear();
                packet.writeByte((byte)24);
                packet.writeLong(this.serverStatementId);
                packet.writeInt(parameterIndex);
                packet.writeBytesNoNull((byte[])longData.value);
                mysql.sendCommand(24, null, packet, true, null);
            } else if (value instanceof InputStream) {
                this.storeStream(mysql, parameterIndex, packet, (InputStream)value);
            } else if (value instanceof Blob) {
                this.storeStream(mysql, parameterIndex, packet, ((Blob)value).getBinaryStream());
            } else if (value instanceof Reader) {
                this.storeReader(mysql, parameterIndex, packet, (Reader)value);
            } else {
                throw new SQLException(Messages.getString("ServerPreparedStatement.18") + value.getClass().getName() + "'", "S1009");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverPrepare(String sql) throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            MysqlIO mysql = this.connection.getIO();
            if (this.connection.getAutoGenerateTestcaseScript()) {
                this.dumpPrepareForTestcase();
            }
            try {
                int i2;
                long begin = 0L;
                this.isLoadDataQuery = StringUtils.startsWithIgnoreCaseAndWs(sql, "LOAD DATA");
                if (this.connection.getProfileSql()) {
                    begin = System.currentTimeMillis();
                }
                String characterEncoding = null;
                String connectionEncoding = this.connection.getEncoding();
                if (!this.isLoadDataQuery && this.connection.getUseUnicode() && connectionEncoding != null) {
                    characterEncoding = connectionEncoding;
                }
                Buffer prepareResultPacket = mysql.sendCommand(22, sql, null, false, characterEncoding);
                if (this.connection.versionMeetsMinimum(4, 1, 1)) {
                    prepareResultPacket.setPosition(1);
                } else {
                    prepareResultPacket.setPosition(0);
                }
                this.serverStatementId = prepareResultPacket.readLong();
                this.fieldCount = prepareResultPacket.readInt();
                this.parameterCount = prepareResultPacket.readInt();
                this.parameterBindings = new BindValue[this.parameterCount];
                for (int i3 = 0; i3 < this.parameterCount; ++i3) {
                    this.parameterBindings[i3] = new BindValue();
                }
                this.connection.incrementNumberOfPrepares();
                if (this.connection.getProfileSql()) {
                    this.eventSink = ProfileEventSink.getInstance(this.connection);
                    this.eventSink.consumeEvent(new ProfilerEvent(2, "", this.currentCatalog, this.connection.getId(), this.statementId, -1, System.currentTimeMillis(), (int)(System.currentTimeMillis() - begin), null, new Throwable(), this.truncateQueryToLog(sql)));
                }
                if (this.parameterCount > 0 && this.connection.versionMeetsMinimum(4, 1, 2) && !mysql.isVersion(5, 0, 0)) {
                    this.parameterFields = new Field[this.parameterCount];
                    Buffer metaDataPacket = mysql.readPacket();
                    i2 = 0;
                    while (!metaDataPacket.isLastDataPacket() && i2 < this.parameterCount) {
                        this.parameterFields[i2++] = mysql.unpackField(metaDataPacket, false);
                        metaDataPacket = mysql.readPacket();
                    }
                }
                if (this.fieldCount > 0) {
                    this.resultFields = new Field[this.fieldCount];
                    Buffer fieldPacket = mysql.readPacket();
                    i2 = 0;
                    while (!fieldPacket.isLastDataPacket() && i2 < this.fieldCount) {
                        this.resultFields[i2++] = mysql.unpackField(fieldPacket, false);
                        fieldPacket = mysql.readPacket();
                    }
                }
            }
            catch (SQLException sqlEx) {
                if (this.connection.getDumpQueriesOnException()) {
                    StringBuffer messageBuf = new StringBuffer(this.originalSql.length() + 32);
                    messageBuf.append("\n\nQuery being prepared when exception was thrown:\n\n");
                    messageBuf.append(this.originalSql);
                    sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
                }
                throw sqlEx;
            }
            finally {
                this.connection.getIO().clearInputStream();
            }
        }
    }

    private String truncateQueryToLog(String sql) {
        String query = null;
        if (sql.length() > this.connection.getMaxQuerySizeToLog()) {
            StringBuffer queryBuf = new StringBuffer(this.connection.getMaxQuerySizeToLog() + 12);
            queryBuf.append(sql.substring(0, this.connection.getMaxQuerySizeToLog()));
            queryBuf.append(Messages.getString("MysqlIO.25"));
            query = queryBuf.toString();
        } else {
            query = sql;
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverResetStatement() throws SQLException {
        Object object = this.connection.getMutex();
        synchronized (object) {
            MysqlIO mysql = this.connection.getIO();
            Buffer packet = mysql.getSharedSendPacket();
            packet.clear();
            packet.writeByte((byte)26);
            packet.writeLong(this.serverStatementId);
            try {
                mysql.sendCommand(26, null, packet, !this.connection.versionMeetsMinimum(4, 1, 2), null);
            }
            catch (SQLException sqlEx) {
                throw sqlEx;
            }
            catch (Exception ex) {
                throw new SQLException(ex.toString(), "S1000");
            }
            finally {
                mysql.clearInputStream();
            }
        }
    }

    public void setArray(int i2, Array x2) throws SQLException {
        throw new NotImplemented();
    }

    public void setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.checkClosed();
        if (x2 == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x2;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : -1L;
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        this.checkClosed();
        if (x2 == null) {
            this.setNull(parameterIndex, 3);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            if (this.connection.versionMeetsMinimum(5, 0, 3)) {
                this.setType(binding, 246);
            } else {
                this.setType(binding, this.stringTypeCode);
            }
            binding.value = StringUtils.fixDecimalExponent(x2.toString());
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.checkClosed();
        if (x2 == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x2;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : -1L;
        }
    }

    public void setBlob(int parameterIndex, Blob x2) throws SQLException {
        this.checkClosed();
        if (x2 == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x2;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? x2.length() : -1L;
        }
    }

    public void setBoolean(int parameterIndex, boolean x2) throws SQLException {
        this.setByte(parameterIndex, x2 ? (byte)1 : 0);
    }

    public void setByte(int parameterIndex, byte x2) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 1);
        binding.value = null;
        binding.byteBinding = x2;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setBytes(int parameterIndex, byte[] x2) throws SQLException {
        this.checkClosed();
        if (x2 == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 253);
            binding.value = x2;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkClosed();
        if (reader == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = reader;
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? (long)length : -1L;
        }
    }

    public void setClob(int parameterIndex, Clob x2) throws SQLException {
        this.checkClosed();
        if (x2 == null) {
            this.setNull(parameterIndex, -2);
        } else {
            BindValue binding = this.getBinding(parameterIndex, true);
            this.setType(binding, 252);
            binding.value = x2.getCharacterStream();
            binding.isNull = false;
            binding.isLongData = true;
            binding.bindLength = this.connection.getUseStreamLengthsInPrepStmts() ? x2.length() : -1L;
        }
    }

    public void setDate(int parameterIndex, Date x2) throws SQLException {
        this.setDate(parameterIndex, x2, null);
    }

    public void setDate(int parameterIndex, Date x2, Calendar cal) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 91);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 10);
            binding.value = x2;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setDouble(int parameterIndex, double x2) throws SQLException {
        this.checkClosed();
        if (!this.connection.getAllowNanAndInf() && (x2 == Double.POSITIVE_INFINITY || x2 == Double.NEGATIVE_INFINITY || Double.isNaN(x2))) {
            throw new SQLException("'" + x2 + "' is not a valid numeric or approximate numeric value", "S1009");
        }
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 5);
        binding.value = null;
        binding.doubleBinding = x2;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setFloat(int parameterIndex, float x2) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 4);
        binding.value = null;
        binding.floatBinding = x2;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setInt(int parameterIndex, int x2) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 3);
        binding.value = null;
        binding.intBinding = x2;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setLong(int parameterIndex, long x2) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 8);
        binding.value = null;
        binding.longBinding = x2;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        if (binding.bufferType == 0) {
            this.setType(binding, 6);
        }
        binding.value = null;
        binding.isNull = true;
        binding.isLongData = false;
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        if (binding.bufferType == 0) {
            this.setType(binding, 6);
        }
        binding.value = null;
        binding.isNull = true;
        binding.isLongData = false;
    }

    public void setRef(int i2, Ref x2) throws SQLException {
        throw new NotImplemented();
    }

    public void setShort(int parameterIndex, short x2) throws SQLException {
        this.checkClosed();
        BindValue binding = this.getBinding(parameterIndex, false);
        this.setType(binding, 2);
        binding.value = null;
        binding.shortBinding = x2;
        binding.isNull = false;
        binding.isLongData = false;
    }

    public void setString(int parameterIndex, String x2) throws SQLException {
        this.checkClosed();
        if (x2 == null) {
            this.setNull(parameterIndex, 1);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, this.stringTypeCode);
            binding.value = x2;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setTime(int parameterIndex, Time x2) throws SQLException {
        this.setTimeInternal(parameterIndex, x2, TimeZone.getDefault(), false);
    }

    public void setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        this.setTimeInternal(parameterIndex, x2, cal.getTimeZone(), true);
    }

    public void setTimeInternal(int parameterIndex, Time x2, TimeZone tz, boolean rollForward) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 92);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 11);
            binding.value = TimeUtil.changeTimezone(this.connection, x2, tz, this.connection.getServerTimezoneTZ(), rollForward);
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        this.setTimestampInternal(parameterIndex, x2, TimeZone.getDefault(), false);
    }

    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        this.setTimestampInternal(parameterIndex, x2, cal.getTimeZone(), true);
    }

    protected void setTimestampInternal(int parameterIndex, Timestamp x2, TimeZone tz, boolean rollForward) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 93);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 12);
            binding.value = TimeUtil.changeTimezone(this.connection, x2, tz, this.connection.getServerTimezoneTZ(), rollForward);
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    private void setType(BindValue oldValue, int bufferType) {
        if (oldValue.bufferType != bufferType) {
            this.sendTypesToServer = true;
        }
        oldValue.bufferType = bufferType;
    }

    public void setUnicodeStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.checkClosed();
        throw new NotImplemented();
    }

    public void setURL(int parameterIndex, URL x2) throws SQLException {
        this.checkClosed();
        this.setString(parameterIndex, x2.toString());
    }

    private void storeBinding(Buffer packet, BindValue bindValue, MysqlIO mysql) throws SQLException {
        try {
            Object value = bindValue.value;
            switch (bindValue.bufferType) {
                case 1: {
                    packet.writeByte(bindValue.byteBinding);
                    return;
                }
                case 2: {
                    packet.ensureCapacity(2);
                    packet.writeInt(bindValue.shortBinding);
                    return;
                }
                case 3: {
                    packet.ensureCapacity(4);
                    packet.writeLong(bindValue.intBinding);
                    return;
                }
                case 8: {
                    packet.ensureCapacity(8);
                    packet.writeLongLong(bindValue.longBinding);
                    return;
                }
                case 4: {
                    packet.ensureCapacity(4);
                    packet.writeFloat(bindValue.floatBinding);
                    return;
                }
                case 5: {
                    packet.ensureCapacity(8);
                    packet.writeDouble(bindValue.doubleBinding);
                    return;
                }
                case 11: {
                    ServerPreparedStatement.storeTime(packet, (Time)value);
                    return;
                }
                case 7: 
                case 10: 
                case 12: {
                    this.storeDateTime(packet, (java.util.Date)value, mysql);
                    return;
                }
                case 0: 
                case 15: 
                case 246: 
                case 253: 
                case 254: {
                    if (value instanceof byte[]) {
                        packet.writeLenBytes((byte[])value);
                    } else if (!this.isLoadDataQuery) {
                        packet.writeLenString((String)value, this.charEncoding, this.connection.getServerCharacterEncoding(), this.charConverter, this.connection.parserKnowsUnicode());
                    } else {
                        packet.writeLenBytes(((String)value).getBytes());
                    }
                    return;
                }
            }
        }
        catch (UnsupportedEncodingException uEE) {
            throw new SQLException(Messages.getString("ServerPreparedStatement.22") + this.connection.getEncoding() + "'", "S1000");
        }
    }

    private void storeDataTime412AndOlder(Buffer intoBuf, java.util.Date dt) throws SQLException {
        if (this.dateTimeBindingCal == null) {
            this.dateTimeBindingCal = Calendar.getInstance();
        }
        this.dateTimeBindingCal.setTime(dt);
        intoBuf.ensureCapacity(8);
        intoBuf.writeByte((byte)7);
        int year = this.dateTimeBindingCal.get(1);
        int month = this.dateTimeBindingCal.get(2) + 1;
        int date = this.dateTimeBindingCal.get(5);
        intoBuf.writeInt(year);
        intoBuf.writeByte((byte)month);
        intoBuf.writeByte((byte)date);
        if (dt instanceof Date) {
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
        } else {
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(11));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(12));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(13));
        }
    }

    private void storeDateTime(Buffer intoBuf, java.util.Date dt, MysqlIO mysql) throws SQLException {
        if (this.connection.versionMeetsMinimum(4, 1, 3)) {
            this.storeDateTime413AndNewer(intoBuf, dt);
        } else {
            this.storeDataTime412AndOlder(intoBuf, dt);
        }
    }

    private void storeDateTime413AndNewer(Buffer intoBuf, java.util.Date dt) throws SQLException {
        if (this.dateTimeBindingCal == null) {
            this.dateTimeBindingCal = Calendar.getInstance();
        }
        this.dateTimeBindingCal.setTime(dt);
        byte length = 7;
        intoBuf.ensureCapacity(length);
        if (dt instanceof Timestamp) {
            length = 11;
        }
        intoBuf.writeByte(length);
        int year = this.dateTimeBindingCal.get(1);
        int month = this.dateTimeBindingCal.get(2) + 1;
        int date = this.dateTimeBindingCal.get(5);
        intoBuf.writeInt(year);
        intoBuf.writeByte((byte)month);
        intoBuf.writeByte((byte)date);
        if (dt instanceof Date) {
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
        } else {
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(11));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(12));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(13));
        }
        if (length == 11) {
            intoBuf.writeLong(((Timestamp)dt).getNanos());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeReader(MysqlIO mysql, int parameterIndex, Buffer packet, Reader inStream) throws SQLException {
        int maxBytesChar = 2;
        if (this.connection.getEncoding() != null && (maxBytesChar = this.connection.getMaxBytesPerChar(this.connection.getEncoding())) == 1) {
            maxBytesChar = 2;
        }
        char[] buf = new char[8192 / maxBytesChar];
        int numRead = 0;
        int bytesInPacket = 0;
        int totalBytesRead = 0;
        int bytesReadAtLastSend = 0;
        int packetIsFullAt = this.connection.getBlobSendChunkSize();
        try {
            try {
                packet.clear();
                packet.writeByte((byte)24);
                packet.writeLong(this.serverStatementId);
                packet.writeInt(parameterIndex);
                boolean readAny = false;
                while ((numRead = inStream.read(buf)) != -1) {
                    readAny = true;
                    byte[] valueAsBytes = StringUtils.getBytes(buf, null, this.connection.getEncoding(), this.connection.getServerCharacterEncoding(), 0, numRead, this.connection.parserKnowsUnicode());
                    packet.writeBytesNoNull(valueAsBytes, 0, valueAsBytes.length);
                    totalBytesRead += valueAsBytes.length;
                    if ((bytesInPacket += valueAsBytes.length) < packetIsFullAt) continue;
                    bytesReadAtLastSend = totalBytesRead;
                    mysql.sendCommand(24, null, packet, true, null);
                    bytesInPacket = 0;
                    packet.clear();
                    packet.writeByte((byte)24);
                    packet.writeLong(this.serverStatementId);
                    packet.writeInt(parameterIndex);
                }
                if (totalBytesRead != bytesReadAtLastSend) {
                    mysql.sendCommand(24, null, packet, true, null);
                }
                if (!readAny) {
                    mysql.sendCommand(24, null, packet, true, null);
                }
            }
            catch (IOException ioEx) {
                throw new SQLException(Messages.getString("ServerPreparedStatement.24") + ioEx.toString(), "S1000");
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (!this.connection.getAutoClosePStmtStreams()) throw throwable;
            if (inStream == null) throw throwable;
            try {
                inStream.close();
                throw throwable;
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            throw throwable;
        }
        if (!this.connection.getAutoClosePStmtStreams()) return;
        if (inStream == null) return;
        try {}
        catch (IOException ioEx) {}
        inStream.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeStream(MysqlIO mysql, int parameterIndex, Buffer packet, InputStream inStream) throws SQLException {
        byte[] buf = new byte[8192];
        int numRead = 0;
        try {
            try {
                int bytesInPacket = 0;
                int totalBytesRead = 0;
                int bytesReadAtLastSend = 0;
                int packetIsFullAt = this.connection.getBlobSendChunkSize();
                packet.clear();
                packet.writeByte((byte)24);
                packet.writeLong(this.serverStatementId);
                packet.writeInt(parameterIndex);
                boolean readAny = false;
                while ((numRead = inStream.read(buf)) != -1) {
                    readAny = true;
                    packet.writeBytesNoNull(buf, 0, numRead);
                    totalBytesRead += numRead;
                    if ((bytesInPacket += numRead) < packetIsFullAt) continue;
                    bytesReadAtLastSend = totalBytesRead;
                    mysql.sendCommand(24, null, packet, true, null);
                    bytesInPacket = 0;
                    packet.clear();
                    packet.writeByte((byte)24);
                    packet.writeLong(this.serverStatementId);
                    packet.writeInt(parameterIndex);
                }
                if (totalBytesRead != bytesReadAtLastSend) {
                    mysql.sendCommand(24, null, packet, true, null);
                }
                if (!readAny) {
                    mysql.sendCommand(24, null, packet, true, null);
                }
            }
            catch (IOException ioEx) {
                throw new SQLException(Messages.getString("ServerPreparedStatement.25") + ioEx.toString(), "S1000");
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (!this.connection.getAutoClosePStmtStreams()) throw throwable;
            if (inStream == null) throw throwable;
            try {
                inStream.close();
                throw throwable;
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            throw throwable;
        }
        if (!this.connection.getAutoClosePStmtStreams()) return;
        if (inStream == null) return;
        try {}
        catch (IOException ioEx) {}
        inStream.close();
        return;
    }

    public String toString() {
        StringBuffer toStringBuf = new StringBuffer();
        toStringBuf.append("com.mysql.jdbc.ServerPreparedStatement[");
        toStringBuf.append(this.serverStatementId);
        toStringBuf.append("] - ");
        try {
            toStringBuf.append(this.asSql());
        }
        catch (SQLException sqlEx) {
            toStringBuf.append(Messages.getString("ServerPreparedStatement.6"));
            toStringBuf.append(sqlEx);
        }
        return toStringBuf.toString();
    }

    static class BindValue {
        long boundBeforeExecutionNum = 0L;
        long bindLength;
        int bufferType;
        byte byteBinding;
        double doubleBinding;
        float floatBinding;
        int intBinding;
        boolean isLongData;
        boolean isNull;
        boolean isSet = false;
        long longBinding;
        short shortBinding;
        Object value;

        BindValue() {
        }

        BindValue(BindValue copyMe) {
            this.value = copyMe.value;
            this.isSet = copyMe.isSet;
            this.isLongData = copyMe.isLongData;
            this.isNull = copyMe.isNull;
            this.bufferType = copyMe.bufferType;
            this.bindLength = copyMe.bindLength;
            this.byteBinding = copyMe.byteBinding;
            this.shortBinding = copyMe.shortBinding;
            this.intBinding = copyMe.intBinding;
            this.longBinding = copyMe.longBinding;
            this.floatBinding = copyMe.floatBinding;
            this.doubleBinding = copyMe.doubleBinding;
        }

        void reset() {
            this.isSet = false;
            this.value = null;
            this.isLongData = false;
            this.byteBinding = 0;
            this.shortBinding = 0;
            this.intBinding = 0;
            this.longBinding = 0L;
            this.floatBinding = 0.0f;
            this.doubleBinding = 0.0;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean quoteIfNeeded) {
            if (this.isLongData) {
                return "' STREAM DATA '";
            }
            switch (this.bufferType) {
                case 1: {
                    return String.valueOf(this.byteBinding);
                }
                case 2: {
                    return String.valueOf(this.shortBinding);
                }
                case 3: {
                    return String.valueOf(this.intBinding);
                }
                case 8: {
                    return String.valueOf(this.longBinding);
                }
                case 4: {
                    return String.valueOf(this.floatBinding);
                }
                case 5: {
                    return String.valueOf(this.doubleBinding);
                }
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 253: 
                case 254: {
                    if (quoteIfNeeded) {
                        return "'" + String.valueOf(this.value) + "'";
                    }
                    return String.valueOf(this.value);
                }
            }
            if (this.value instanceof byte[]) {
                return "byte data";
            }
            if (quoteIfNeeded) {
                return "'" + String.valueOf(this.value) + "'";
            }
            return String.valueOf(this.value);
        }
    }

    static class BatchedBindValues {
        BindValue[] batchedParameterValues;

        BatchedBindValues(BindValue[] paramVals) {
            int numParams = paramVals.length;
            this.batchedParameterValues = new BindValue[numParams];
            for (int i2 = 0; i2 < numParams; ++i2) {
                this.batchedParameterValues[i2] = new BindValue(paramVals[i2]);
            }
        }
    }
}

