/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObject;
import org.bson.BSONObject;

public class ServerError {
    final String _err;
    final int _code;

    ServerError(DBObject o2) {
        this._err = ServerError.getMsg(o2, null);
        if (this._err == null) {
            throw new IllegalArgumentException("need to have $err");
        }
        this._code = ServerError.getCode(o2);
    }

    static String getMsg(BSONObject o2, String def) {
        Object e2 = o2.get("$err");
        if (e2 == null) {
            e2 = o2.get("err");
        }
        if (e2 == null) {
            e2 = o2.get("errmsg");
        }
        if (e2 == null) {
            return def;
        }
        return e2.toString();
    }

    static int getCode(BSONObject o2) {
        Object c2 = o2.get("code");
        if (c2 == null) {
            c2 = o2.get("$code");
        }
        if (c2 == null) {
            c2 = o2.get("assertionCode");
        }
        if (c2 == null) {
            return -5;
        }
        return ((Number)c2).intValue();
    }

    public String getError() {
        return this._err;
    }

    public int getCode() {
        return this._code;
    }

    public boolean isNotMasterError() {
        switch (this._code) {
            case 10054: 
            case 10056: 
            case 10058: 
            case 10107: 
            case 13435: 
            case 13436: {
                return true;
            }
        }
        return this._err.startsWith("not master");
    }

    public String toString() {
        if (this._code > 0) {
            return this._code + " " + this._err;
        }
        return this._err;
    }
}

