/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public class EclipseUtils {
    private static final BasicStroke DOTTED_STROKE = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);
    static final double RATIO1 = 0.67;
    static final double RATIO2 = 0.78;
    static final double RATIO3 = 0.86;

    static Color getLighterColor(Color backColor) {
        int r2 = EclipseUtils.getLighterColor(backColor.getRed());
        int g2 = EclipseUtils.getLighterColor(backColor.getGreen());
        int b2 = EclipseUtils.getLighterColor(backColor.getBlue());
        if (r2 >= 255) {
            r2 = 255;
        }
        if (g2 >= 255) {
            g2 = 255;
        }
        if (b2 >= 255) {
            b2 = 255;
        }
        return new Color(r2, g2, b2);
    }

    static int getLighterColor(int x2) {
        return (int)((double)x2 * 36.0 / 255.0 + 219.5);
    }

    static Color getMenuSelectionColor(Color backColor) {
        int r2 = EclipseUtils.getMenuSelectionValue(backColor.getRed());
        int g2 = EclipseUtils.getMenuSelectionValue(backColor.getGreen());
        int b2 = EclipseUtils.getMenuSelectionValue(backColor.getBlue());
        if (r2 >= 255) {
            r2 = 255;
        }
        if (g2 >= 255) {
            g2 = 255;
        }
        if (b2 >= 255) {
            b2 = 255;
        }
        return new Color(r2, g2, b2);
    }

    static int getMenuSelectionValue(int x2) {
        return (int)((double)x2 * 76.0 / 255.0 + 179.5);
    }

    static Color getMenuBackgroundColor(Color backColor) {
        int r2 = EclipseUtils.getMenuValue(backColor.getRed());
        int g2 = EclipseUtils.getMenuValue(backColor.getGreen());
        int b2 = EclipseUtils.getMenuValue(backColor.getBlue());
        if (r2 >= 255) {
            r2 = 255;
        }
        if (g2 >= 255) {
            g2 = 255;
        }
        if (b2 >= 255) {
            b2 = 255;
        }
        return new Color(r2, g2, b2);
    }

    static int getMenuValue(int x2) {
        return (int)((double)x2 * 36.0 / 255.0 + 219.5);
    }

    static Color getDefaultBackgroundColor(Color backColor) {
        Color backIDE;
        if (backColor.getRed() == 212 && backColor.getGreen() == 208 && backColor.getBlue() == 200) {
            backIDE = new Color(247, 243, 233);
        } else if (backColor.getRed() == 236 && backColor.getGreen() == 233 && backColor.getBlue() == 216) {
            backIDE = new Color(255, 251, 233);
        } else {
            int r2 = backColor.getRed() + 35;
            int g2 = backColor.getGreen() + 35;
            int b2 = backColor.getBlue() + 35;
            if (r2 >= 255) {
                r2 = 255;
            }
            if (g2 >= 255) {
                g2 = 255;
            }
            if (b2 >= 255) {
                b2 = 255;
            }
            backIDE = new Color(r2, g2, b2);
        }
        return backIDE;
    }

    public static void fillRectWithHatch(Graphics2D g2, Rectangle rect, Color color) {
        Stroke oldStroke = g2.getStroke();
        g2.setColor(Color.white);
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        g2.setColor(color);
        g2.setStroke(DOTTED_STROKE);
        for (int i2 = 0; i2 < rect.width; ++i2) {
            if (i2 % 2 == 0) {
                g2.drawLine(rect.x + i2, rect.y, rect.x + i2, rect.y + rect.height - 1);
                continue;
            }
            g2.drawLine(rect.x + i2, rect.y + 1, rect.x + i2, rect.y + rect.height - 1);
        }
        g2.setStroke(oldStroke);
    }

    static int getLightColor(int x2, double ratio) {
        return (int)((double)(255 - x2) * ratio + (double)x2);
    }

    static Color getLighterColor(Color backColor, double ratio) {
        int r2 = EclipseUtils.getLightColor(backColor.getRed(), ratio);
        int g2 = EclipseUtils.getLightColor(backColor.getGreen(), ratio) + 1;
        int b2 = EclipseUtils.getLightColor(backColor.getBlue(), ratio);
        if (r2 >= 255) {
            r2 = 255;
        }
        if (g2 >= 255) {
            g2 = 255;
        }
        if (b2 >= 255) {
            b2 = 255;
        }
        return new Color(r2, g2, b2);
    }

    static Color getSelectedAndFocusedButtonColor(Color backColor) {
        return EclipseUtils.getLighterColor(backColor, 0.67);
    }

    static Color getFocusedButtonColor(Color backColor) {
        return EclipseUtils.getLighterColor(backColor, 0.78);
    }

    static Color getSelectedButtonColor(Color backColor) {
        return EclipseUtils.getLighterColor(backColor, 0.86);
    }
}

