/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;

public class FeatureDensityRenderer
extends DataRenderer {
    public String getDisplayName() {
        return "Feature Density";
    }

    @Override
    public void renderScores(Track track, List<LocusScore> scores, RenderContext context, Rectangle rect) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        double maxValue = track.getDataRange().getMaximum();
        double yScaleFactor = rect.getHeight() / maxValue;
        int pX = -1;
        Graphics2D g2 = context.getGraphics();
        for (LocusScore score : scores) {
            pX = (int)(((double)score.getStart() - origin) / locScale);
            if (pX < 0) continue;
            float dataY = (float)((double)(score.getScore() * 1000000.0f) / locScale);
            if (Float.isNaN(dataY)) {
                g2.setColor(Color.LIGHT_GRAY.brighter());
                g2.drawLine(pX, (int)rect.getY(), pX, (int)rect.getMaxY());
            } else {
                g2.setColor(Color.CYAN.darker());
                double scaledY = (double)dataY * yScaleFactor;
                int pY = (int)Math.max(rect.getY(), rect.getMaxY() - scaledY);
                g2.drawLine(pX, (int)rect.getMaxY(), pX, pY);
            }
            if ((double)pX > rect.getMaxX()) break;
            g2.setColor(Color.BLACK);
            g2.drawLine((int)rect.getX(), (int)rect.getMaxY(), (int)rect.getMaxX(), (int)rect.getMaxY());
        }
    }
}

