/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.peaks.Peak;
import org.broad.igv.util.CompressionUtils;
import org.broad.igv.util.stream.IGVSeekableBufferedStream;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class PeakParser {
    Map<String, Long> chrIndex;
    int nTimePoints;
    String path;
    String trackLine;
    int[] times;
    String signalsPath;
    String[] timeSignalsPath;
    private final CompressionUtils compressionUtils;

    public PeakParser(String path) throws IOException {
        this.path = path;
        this.loadHeader();
        this.compressionUtils = new CompressionUtils();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHeader() throws IOException {
        SeekableStream ss = null;
        try {
            int t2;
            ss = IGVSeekableStreamFactory.getInstance().getStreamFor(this.path);
            LittleEndianInputStream is = new LittleEndianInputStream(new BufferedInputStream(ss));
            long indexPosition = is.readLong();
            this.trackLine = is.readString();
            this.nTimePoints = is.readInt();
            this.times = new int[this.nTimePoints];
            for (t2 = 0; t2 < this.nTimePoints; ++t2) {
                this.times[t2] = is.readInt();
            }
            this.signalsPath = is.readString();
            this.timeSignalsPath = new String[this.nTimePoints];
            for (t2 = 0; t2 < this.nTimePoints; ++t2) {
                this.timeSignalsPath[t2] = is.readString();
            }
            this.chrIndex = new HashMap<String, Long>();
            ss.seek(indexPosition);
            is = new LittleEndianInputStream(new BufferedInputStream(ss));
            int nChrs = is.readInt();
            for (int i2 = 0; i2 < nChrs; ++i2) {
                String chr = is.readString();
                long pos = is.readLong();
                this.chrIndex.put(chr, pos);
            }
        }
        finally {
            if (ss != null) {
                ss.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Peak> loadPeaks(String chr) throws IOException {
        Long chrPos = this.chrIndex.get(chr);
        if (chrPos == null) {
            return new ArrayList<Peak>();
        }
        ArrayList<Peak> peaks = new ArrayList<Peak>(10000);
        LittleEndianInputStream reader = null;
        SeekableStream ss = null;
        try {
            ss = IGVSeekableStreamFactory.getInstance().getStreamFor(this.path);
            int bufferSize = 512000;
            long contentLength = ss.length();
            if (contentLength > 0L) {
                bufferSize = (int)Math.min(contentLength, (long)bufferSize);
            }
            IGVSeekableBufferedStream bufferedStream = new IGVSeekableBufferedStream(ss, bufferSize);
            bufferedStream.seek(chrPos);
            reader = new LittleEndianInputStream(bufferedStream);
            int nBytes = reader.readInt();
            byte[] compressedBytes = new byte[nBytes];
            bufferedStream.readFully(compressedBytes);
            byte[] bytes = this.compressionUtils.decompress(compressedBytes);
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            reader = new LittleEndianInputStream(bis);
            String chrRecorded = reader.readString();
            if (!chrRecorded.equals(chr)) {
                throw new RuntimeException("Error paring peak file: " + this.path + "<br>Expected: " + chr + "  found: " + chrRecorded);
            }
            int nDataPoints = reader.readInt();
            for (int n2 = 0; n2 < nDataPoints; ++n2) {
                int start = reader.readInt();
                int end = reader.readInt();
                float combinedScore = reader.readFloat();
                float[] timePointScores = new float[this.nTimePoints];
                for (int i2 = 0; i2 < this.nTimePoints; ++i2) {
                    timePointScores[i2] = reader.readFloat();
                }
                peaks.add(new Peak(chr, start, end, "", combinedScore, timePointScores));
            }
            ArrayList<Peak> arrayList = peaks;
            return arrayList;
        }
        finally {
            if (ss != null) {
                ss.close();
            }
        }
    }
}

