/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.transform;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.transform.FastFourierTransformer;
import org.apache.commons.math.transform.RealTransformer;
import org.apache.commons.math.util.FastMath;

public class FastCosineTransformer
implements RealTransformer {
    public double[] transform(double[] f2) throws IllegalArgumentException {
        return this.fct(f2);
    }

    public double[] transform(UnivariateRealFunction f2, double min, double max, int n2) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f2, min, max, n2);
        return this.fct(data);
    }

    public double[] transform2(double[] f2) throws IllegalArgumentException {
        double scaling_coefficient = FastMath.sqrt(2.0 / (double)(f2.length - 1));
        return FastFourierTransformer.scaleArray(this.fct(f2), scaling_coefficient);
    }

    public double[] transform2(UnivariateRealFunction f2, double min, double max, int n2) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f2, min, max, n2);
        double scaling_coefficient = FastMath.sqrt(2.0 / (double)(n2 - 1));
        return FastFourierTransformer.scaleArray(this.fct(data), scaling_coefficient);
    }

    public double[] inversetransform(double[] f2) throws IllegalArgumentException {
        double scaling_coefficient = 2.0 / (double)(f2.length - 1);
        return FastFourierTransformer.scaleArray(this.fct(f2), scaling_coefficient);
    }

    public double[] inversetransform(UnivariateRealFunction f2, double min, double max, int n2) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f2, min, max, n2);
        double scaling_coefficient = 2.0 / (double)(n2 - 1);
        return FastFourierTransformer.scaleArray(this.fct(data), scaling_coefficient);
    }

    public double[] inversetransform2(double[] f2) throws IllegalArgumentException {
        return this.transform2(f2);
    }

    public double[] inversetransform2(UnivariateRealFunction f2, double min, double max, int n2) throws FunctionEvaluationException, IllegalArgumentException {
        return this.transform2(f2, min, max, n2);
    }

    protected double[] fct(double[] f2) throws IllegalArgumentException {
        double[] transformed = new double[f2.length];
        int n2 = f2.length - 1;
        if (!FastFourierTransformer.isPowerOf2(n2)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_PLUS_ONE, f2.length);
        }
        if (n2 == 1) {
            transformed[0] = 0.5 * (f2[0] + f2[1]);
            transformed[1] = 0.5 * (f2[0] - f2[1]);
            return transformed;
        }
        double[] x2 = new double[n2];
        x2[0] = 0.5 * (f2[0] + f2[n2]);
        x2[n2 >> 1] = f2[n2 >> 1];
        double t1 = 0.5 * (f2[0] - f2[n2]);
        for (int i2 = 1; i2 < n2 >> 1; ++i2) {
            double a2 = 0.5 * (f2[i2] + f2[n2 - i2]);
            double b2 = FastMath.sin((double)i2 * Math.PI / (double)n2) * (f2[i2] - f2[n2 - i2]);
            double c2 = FastMath.cos((double)i2 * Math.PI / (double)n2) * (f2[i2] - f2[n2 - i2]);
            x2[i2] = a2 - b2;
            x2[n2 - i2] = a2 + b2;
            t1 += c2;
        }
        FastFourierTransformer transformer = new FastFourierTransformer();
        Complex[] y = transformer.transform(x2);
        transformed[0] = y[0].getReal();
        transformed[1] = t1;
        for (int i3 = 1; i3 < n2 >> 1; ++i3) {
            transformed[2 * i3] = y[i3].getReal();
            transformed[2 * i3 + 1] = transformed[2 * i3 - 1] - y[i3].getImaginary();
        }
        transformed[n2] = y[n2 >> 1].getReal();
        return transformed;
    }
}

