/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.BivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math.analysis.interpolation.BivariateRealGridInterpolator;
import org.apache.commons.math.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.MathUtils;

@Deprecated
public class SmoothingBicubicSplineInterpolator
implements BivariateRealGridInterpolator {
    public BivariateRealFunction interpolate(double[] xval, double[] yval, double[][] zval) throws MathException, IllegalArgumentException {
        int i2;
        if (xval.length == 0 || yval.length == 0 || zval.length == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NO_DATA, new Object[0]);
        }
        if (xval.length != zval.length) {
            throw new DimensionMismatchException(xval.length, zval.length);
        }
        MathUtils.checkOrder(xval, MathUtils.OrderDirection.INCREASING, true);
        MathUtils.checkOrder(yval, MathUtils.OrderDirection.INCREASING, true);
        int xLen = xval.length;
        int yLen = yval.length;
        double[][] zX = new double[yLen][xLen];
        for (int i3 = 0; i3 < xLen; ++i3) {
            if (zval[i3].length != yLen) {
                throw new DimensionMismatchException(zval[i3].length, yLen);
            }
            for (int j2 = 0; j2 < yLen; ++j2) {
                zX[j2][i3] = zval[i3][j2];
            }
        }
        SplineInterpolator spInterpolator = new SplineInterpolator();
        PolynomialSplineFunction[] ySplineX = new PolynomialSplineFunction[yLen];
        for (int j3 = 0; j3 < yLen; ++j3) {
            ySplineX[j3] = spInterpolator.interpolate(xval, zX[j3]);
        }
        double[][] zY_1 = new double[xLen][yLen];
        for (int j4 = 0; j4 < yLen; ++j4) {
            PolynomialSplineFunction f2 = ySplineX[j4];
            for (i2 = 0; i2 < xLen; ++i2) {
                zY_1[i2][j4] = f2.value(xval[i2]);
            }
        }
        PolynomialSplineFunction[] xSplineY = new PolynomialSplineFunction[xLen];
        for (int i4 = 0; i4 < xLen; ++i4) {
            xSplineY[i4] = spInterpolator.interpolate(yval, zY_1[i4]);
        }
        double[][] zY_2 = new double[xLen][yLen];
        for (i2 = 0; i2 < xLen; ++i2) {
            PolynomialSplineFunction f3 = xSplineY[i2];
            for (int j5 = 0; j5 < yLen; ++j5) {
                zY_2[i2][j5] = f3.value(yval[j5]);
            }
        }
        double[][] dZdX = new double[xLen][yLen];
        for (int j6 = 0; j6 < yLen; ++j6) {
            UnivariateRealFunction f4 = ySplineX[j6].derivative();
            for (int i5 = 0; i5 < xLen; ++i5) {
                dZdX[i5][j6] = f4.value(xval[i5]);
            }
        }
        double[][] dZdY = new double[xLen][yLen];
        for (int i6 = 0; i6 < xLen; ++i6) {
            UnivariateRealFunction f5 = xSplineY[i6].derivative();
            for (int j7 = 0; j7 < yLen; ++j7) {
                dZdY[i6][j7] = f5.value(yval[j7]);
            }
        }
        double[][] dZdXdY = new double[xLen][yLen];
        for (int i7 = 0; i7 < xLen; ++i7) {
            int nI = this.nextIndex(i7, xLen);
            int pI = this.previousIndex(i7);
            for (int j8 = 0; j8 < yLen; ++j8) {
                int nJ = this.nextIndex(j8, yLen);
                int pJ = this.previousIndex(j8);
                dZdXdY[i7][j8] = (zY_2[nI][nJ] - zY_2[nI][pJ] - zY_2[pI][nJ] + zY_2[pI][pJ]) / ((xval[nI] - xval[pI]) * (yval[nJ] - yval[pJ]));
            }
        }
        return new BicubicSplineInterpolatingFunction(xval, yval, zY_2, dZdX, dZdY, dZdXdY);
    }

    private int nextIndex(int i2, int max) {
        int index = i2 + 1;
        return index < max ? index : index - 1;
    }

    private int previousIndex(int i2) {
        int index = i2 - 1;
        return index >= 0 ? index : 0;
    }
}

