/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

public class TriplyIndexedTable {
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;

    public TriplyIndexedTable() {
        this.table = new Entry[11];
    }

    public TriplyIndexedTable(int c2) {
        this.table = new Entry[c2];
    }

    public int size() {
        return this.count;
    }

    public Object put(Object o1, Object o2, Object o3, Object value) {
        Entry e2;
        int hash = this.hashCode(o1, o2, o3) & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e3 = this.table[index];
        while (e3 != null) {
            if (e3.hash == hash && e3.match(o1, o2, o3)) {
                Object old = e3.value;
                e3.value = value;
                return old;
            }
            e3 = e3.next;
        }
        int len = this.table.length;
        if (this.count++ >= len - (len >> 2)) {
            this.rehash();
            index = hash % this.table.length;
        }
        this.table[index] = e2 = new Entry(hash, o1, o2, o3, value, this.table[index]);
        return null;
    }

    public Object get(Object o1, Object o2, Object o3) {
        int hash = this.hashCode(o1, o2, o3) & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == hash && e2.match(o1, o2, o3)) {
                return e2.value;
            }
            e2 = e2.next;
        }
        return null;
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        this.table = new Entry[oldTable.length * 2 + 1];
        int i2 = oldTable.length - 1;
        while (i2 >= 0) {
            Entry old = oldTable[i2];
            while (old != null) {
                Entry e2 = old;
                old = old.next;
                int index = e2.hash % this.table.length;
                e2.next = this.table[index];
                this.table[index] = e2;
            }
            --i2;
        }
    }

    protected int hashCode(Object o1, Object o2, Object o3) {
        return (o1 == null ? 0 : o1.hashCode()) ^ (o2 == null ? 0 : o2.hashCode()) ^ (o3 == null ? 0 : o3.hashCode());
    }

    protected static class Entry {
        public int hash;
        public Object key1;
        public Object key2;
        public Object key3;
        public Object value;
        public Entry next;

        public Entry(int hash, Object key1, Object key2, Object key3, Object value, Entry next) {
            this.hash = hash;
            this.key1 = key1;
            this.key2 = key2;
            this.key3 = key3;
            this.value = value;
            this.next = next;
        }

        public boolean match(Object o1, Object o2, Object o3) {
            if (this.key1 != null ? !this.key1.equals(o1) : o1 != null) {
                return false;
            }
            if (this.key2 != null ? !this.key2.equals(o2) : o2 != null) {
                return false;
            }
            if (this.key3 != null) {
                return this.key3.equals(o3);
            }
            return o3 == null;
        }
    }
}

