/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBApiLayer;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoder;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.QueryOpBuilder;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCursor
implements Iterator<DBObject>,
Iterable<DBObject>,
Closeable {
    private final DBCollection _collection;
    private final DBObject _query;
    private final DBObject _keysWanted;
    private DBObject _orderBy = null;
    private String _hint = null;
    private DBObject _hintDBObj = null;
    private boolean _explain = false;
    private int _limit = 0;
    private int _batchSize = 0;
    private int _skip = 0;
    private boolean _snapshot = false;
    private int _options = 0;
    private ReadPreference _readPref;
    private DBDecoderFactory _decoderFact;
    private DBObject _specialFields;
    private Iterator<DBObject> _it = null;
    private CursorType _cursorType = null;
    private DBObject _cur = null;
    private int _num = 0;
    private final ArrayList<DBObject> _all = new ArrayList();

    public DBCursor(DBCollection collection, DBObject q2, DBObject k2, ReadPreference preference) {
        if (collection == null) {
            throw new IllegalArgumentException("collection is null");
        }
        this._collection = collection;
        this._query = q2 == null ? new BasicDBObject() : q2;
        this._keysWanted = k2;
        this._options = this._collection.getOptions();
        this._readPref = preference;
        this._decoderFact = collection.getDBDecoderFactory();
    }

    public DBCursor copy() {
        DBCursor c2 = new DBCursor(this._collection, this._query, this._keysWanted, this._readPref);
        c2._orderBy = this._orderBy;
        c2._hint = this._hint;
        c2._hintDBObj = this._hintDBObj;
        c2._limit = this._limit;
        c2._skip = this._skip;
        c2._options = this._options;
        c2._batchSize = this._batchSize;
        c2._snapshot = this._snapshot;
        c2._explain = this._explain;
        if (this._specialFields != null) {
            c2._specialFields = new BasicDBObject(this._specialFields.toMap());
        }
        return c2;
    }

    @Override
    public Iterator<DBObject> iterator() {
        return this.copy();
    }

    public DBCursor sort(DBObject orderBy) {
        if (this._it != null) {
            throw new IllegalStateException("can't sort after executing query");
        }
        this._orderBy = orderBy;
        return this;
    }

    public DBCursor addSpecial(String name, Object o2) {
        if (this._specialFields == null) {
            this._specialFields = new BasicDBObject();
        }
        this._specialFields.put(name, o2);
        return this;
    }

    public DBCursor hint(DBObject indexKeys) {
        if (this._it != null) {
            throw new IllegalStateException("can't hint after executing query");
        }
        this._hintDBObj = indexKeys;
        return this;
    }

    public DBCursor hint(String indexName) {
        if (this._it != null) {
            throw new IllegalStateException("can't hint after executing query");
        }
        this._hint = indexName;
        return this;
    }

    public DBCursor snapshot() {
        if (this._it != null) {
            throw new IllegalStateException("can't snapshot after executing the query");
        }
        this._snapshot = true;
        return this;
    }

    public DBObject explain() {
        DBCursor c2 = this.copy();
        c2._explain = true;
        if (c2._limit > 0) {
            c2._batchSize = c2._limit * -1;
            c2._limit = 0;
        }
        return c2.next();
    }

    public DBCursor limit(int n2) {
        if (this._it != null) {
            throw new IllegalStateException("can't set limit after executing query");
        }
        if (n2 > 0) {
            this._limit = n2;
        } else if (n2 < 0) {
            this.batchSize(n2);
        }
        return this;
    }

    public DBCursor batchSize(int n2) {
        if (n2 == 1) {
            n2 = 2;
        }
        if (this._it != null && this._it instanceof DBApiLayer.Result) {
            ((DBApiLayer.Result)this._it).setBatchSize(n2);
        }
        this._batchSize = n2;
        return this;
    }

    public DBCursor skip(int n2) {
        if (this._it != null) {
            throw new IllegalStateException("can't set skip after executing query");
        }
        this._skip = n2;
        return this;
    }

    public long getCursorId() {
        if (this._it instanceof DBApiLayer.Result) {
            return ((DBApiLayer.Result)this._it).getCursorId();
        }
        return 0L;
    }

    @Override
    public void close() {
        if (this._it instanceof DBApiLayer.Result) {
            ((DBApiLayer.Result)this._it).close();
        }
    }

    @Deprecated
    public DBCursor slaveOk() {
        return this.addOption(4);
    }

    public DBCursor addOption(int option) {
        if (option == 64) {
            throw new IllegalArgumentException("The exhaust option is not user settable.");
        }
        this._options |= option;
        return this;
    }

    public DBCursor setOptions(int options) {
        this._options = options;
        return this;
    }

    public DBCursor resetOptions() {
        this._options = 0;
        return this;
    }

    public int getOptions() {
        return this._options;
    }

    private void _check() {
        if (this._it != null) {
            return;
        }
        this._lookForHints();
        QueryOpBuilder builder = new QueryOpBuilder().addQuery(this._query).addOrderBy(this._orderBy).addHint(this._hintDBObj).addHint(this._hint).addExplain(this._explain).addSnapshot(this._snapshot).addSpecialFields(this._specialFields);
        if (this._collection.getDB().getMongo().isMongosConnection()) {
            builder.addReadPreference(this._readPref);
        }
        this._it = this._collection.__find(builder.get(), this._keysWanted, this._skip, this._batchSize, this._limit, this._options, this._readPref, this.getDecoder());
    }

    private DBDecoder getDecoder() {
        return this._decoderFact != null ? this._decoderFact.create() : null;
    }

    private void _lookForHints() {
        if (this._hint != null) {
            return;
        }
        if (this._collection._hintFields == null) {
            return;
        }
        Set<String> mykeys = this._query.keySet();
        for (DBObject o2 : this._collection._hintFields) {
            Set<String> hintKeys = o2.keySet();
            if (!mykeys.containsAll(hintKeys)) continue;
            this.hint(o2);
            return;
        }
    }

    void _checkType(CursorType type) {
        if (this._cursorType == null) {
            this._cursorType = type;
            return;
        }
        if (type == this._cursorType) {
            return;
        }
        throw new IllegalArgumentException("can't switch cursor access methods");
    }

    private DBObject _next() {
        if (this._cursorType == null) {
            this._checkType(CursorType.ITERATOR);
        }
        this._check();
        this._cur = this._it.next();
        ++this._num;
        if (this._keysWanted != null && this._keysWanted.keySet().size() > 0) {
            this._cur.markAsPartialObject();
        }
        if (this._cursorType == CursorType.ARRAY) {
            this._all.add(this._cur);
        }
        return this._cur;
    }

    public int numGetMores() {
        if (this._it instanceof DBApiLayer.Result) {
            return ((DBApiLayer.Result)this._it).numGetMores();
        }
        throw new IllegalArgumentException("_it not a real result");
    }

    public List<Integer> getSizes() {
        if (this._it instanceof DBApiLayer.Result) {
            return ((DBApiLayer.Result)this._it).getSizes();
        }
        throw new IllegalArgumentException("_it not a real result");
    }

    private boolean _hasNext() {
        this._check();
        if (this._limit > 0 && this._num >= this._limit) {
            return false;
        }
        return this._it.hasNext();
    }

    public int numSeen() {
        return this._num;
    }

    @Override
    public boolean hasNext() {
        this._checkType(CursorType.ITERATOR);
        return this._hasNext();
    }

    @Override
    public DBObject next() {
        this._checkType(CursorType.ITERATOR);
        return this._next();
    }

    public DBObject curr() {
        this._checkType(CursorType.ITERATOR);
        return this._cur;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("can't remove from a cursor");
    }

    void _fill(int n2) {
        this._checkType(CursorType.ARRAY);
        while (n2 >= this._all.size() && this._hasNext()) {
            this._next();
        }
    }

    public int length() {
        this._checkType(CursorType.ARRAY);
        this._fill(Integer.MAX_VALUE);
        return this._all.size();
    }

    public List<DBObject> toArray() {
        return this.toArray(Integer.MAX_VALUE);
    }

    public List<DBObject> toArray(int max) {
        this._checkType(CursorType.ARRAY);
        this._fill(max - 1);
        return this._all;
    }

    public int itcount() {
        int n2 = 0;
        while (this.hasNext()) {
            this.next();
            ++n2;
        }
        return n2;
    }

    public int count() {
        if (this._collection == null) {
            throw new IllegalArgumentException("why is _collection null");
        }
        if (this._collection._db == null) {
            throw new IllegalArgumentException("why is _collection._db null");
        }
        return (int)this._collection.getCount(this._query, this._keysWanted, this.getReadPreference());
    }

    public int size() {
        if (this._collection == null) {
            throw new IllegalArgumentException("why is _collection null");
        }
        if (this._collection._db == null) {
            throw new IllegalArgumentException("why is _collection._db null");
        }
        return (int)this._collection.getCount(this._query, this._keysWanted, this._limit, this._skip, this.getReadPreference());
    }

    public DBObject getKeysWanted() {
        return this._keysWanted;
    }

    public DBObject getQuery() {
        return this._query;
    }

    public DBCollection getCollection() {
        return this._collection;
    }

    public ServerAddress getServerAddress() {
        if (this._it != null && this._it instanceof DBApiLayer.Result) {
            return ((DBApiLayer.Result)this._it).getServerAddress();
        }
        return null;
    }

    public DBCursor setReadPreference(ReadPreference preference) {
        this._readPref = preference;
        return this;
    }

    public ReadPreference getReadPreference() {
        return this._readPref;
    }

    public DBCursor setDecoderFactory(DBDecoderFactory fact) {
        this._decoderFact = fact;
        return this;
    }

    public DBDecoderFactory getDecoderFactory() {
        return this._decoderFact;
    }

    public String toString() {
        ServerAddress addr;
        StringBuilder sb = new StringBuilder();
        sb.append("Cursor id=").append(this.getCursorId());
        sb.append(", ns=").append(this.getCollection().getFullName());
        sb.append(", query=").append(this.getQuery());
        if (this.getKeysWanted() != null) {
            sb.append(", fields=").append(this.getKeysWanted());
        }
        sb.append(", numIterated=").append(this._num);
        if (this._skip != 0) {
            sb.append(", skip=").append(this._skip);
        }
        if (this._limit != 0) {
            sb.append(", limit=").append(this._limit);
        }
        if (this._batchSize != 0) {
            sb.append(", batchSize=").append(this._batchSize);
        }
        if ((addr = this.getServerAddress()) != null) {
            sb.append(", addr=").append(addr);
        }
        if (this._readPref != null) {
            sb.append(", readPreference=").append(this._readPref.toString());
        }
        return sb.toString();
    }

    boolean hasFinalizer() {
        if (this._it == null || !(this._it instanceof DBApiLayer.Result)) {
            return false;
        }
        return ((DBApiLayer.Result)this._it).hasFinalizer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CursorType {
        ITERATOR,
        ARRAY;

    }
}

