/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.equivalence;

import java.util.HashSet;
import java.util.Set;
import org.jgrapht.experimental.equivalence.EquivalenceComparator;

public class EquivalenceSet<E, C> {
    protected EquivalenceComparator<? super E, ? super C> eqComparator;
    protected C comparatorContext;
    protected Set<E> elementsSet;

    public EquivalenceSet(E e2, EquivalenceComparator<? super E, ? super C> equivalenceComparator, C c2) {
        this.eqComparator = equivalenceComparator;
        this.comparatorContext = c2;
        this.elementsSet = new HashSet();
        this.elementsSet.add(e2);
    }

    public E getRepresentative() {
        return this.elementsSet.iterator().next();
    }

    public C getContext() {
        return this.comparatorContext;
    }

    public int size() {
        return this.elementsSet.size();
    }

    public void add(E e2) {
        this.elementsSet.add(e2);
    }

    public boolean equivalentTo(E e2, C c2) {
        boolean bl = this.eqComparator.equivalenceCompare(this.getRepresentative(), e2, this.comparatorContext, c2);
        return bl;
    }

    public boolean equals(Object object) {
        Object e2 = null;
        Object c2 = null;
        if (!(object instanceof EquivalenceSet)) {
            throw new ClassCastException("can check equal() only of EqualityGroup");
        }
        e2 = ((EquivalenceSet)object).getRepresentative();
        c2 = ((EquivalenceSet)object).getContext();
        boolean bl = this.eqComparator.equivalenceCompare(this.getRepresentative(), e2, this.comparatorContext, c2);
        return bl;
    }

    public int hashCode() {
        int n2 = this.eqComparator.equivalenceHashcode(this.getRepresentative(), this.comparatorContext);
        return n2;
    }

    public String toString() {
        return "Eq.Group=" + this.elementsSet.toString();
    }

    public Object[] toArray() {
        return this.elementsSet.toArray();
    }
}

