/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.ChromosomeCoordinate;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.event.ViewChange;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;

public class RulerPanel
extends JPanel {
    private static Logger log = Logger.getLogger(RulerPanel.class);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat();
    private static Color grey1 = new Color(120, 120, 120);
    private static Color grey2 = new Color(200, 200, 200);
    private static Color gene1 = new Color(0, 0, 150, 150);
    private static Color gene2 = new Color(0, 150, 0, 150);
    boolean drawSpan = true;
    boolean drawEllipsis = false;
    private Font tickFont = FontManager.getFont(1, 9);
    private Font spanFont = FontManager.getFont(1, 12);
    private List<ClickLink> chromosomeRects = new ArrayList<ClickLink>();
    private List<MouseRect> mouseRects = new ArrayList<MouseRect>();
    private static Color dragColor = new Color(0.5f, 0.5f, 1.0f, 0.3f);
    private static Color zoomBoundColor = new Color(0.5f, 0.5f, 0.5f);
    boolean dragging = false;
    int dragStart;
    int dragEnd;
    public static final String WHOLE_GENOME_TOOLTIP = "<html>Click on a chromosome number to jump to that chromosome,<br>or click and drag to zoom in.";
    public static final String CHROM_TOOLTIP = "Click and drag to zoom in.";
    ReferenceFrame frame;

    public RulerPanel(ReferenceFrame frame) {
        this.frame = frame;
        this.init();
    }

    private boolean isWholeGenomeView() {
        return this.frame.getChrName().equals("All");
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (PreferenceManager.getInstance().getAsBoolean("ENABLE_ANTIALIASING")) {
            ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.render(g2);
        if (this.dragging) {
            g2.setColor(dragColor);
            int start = Math.min(this.dragStart, this.dragEnd);
            int w2 = Math.abs(this.dragEnd - this.dragStart);
            int height = this.getHeight();
            g2.fillRect(start, 0, w2, height);
            g2.setColor(zoomBoundColor);
            g2.drawLine(this.dragStart, 0, this.dragStart, height);
            g2.drawLine(this.dragEnd, 0, this.dragEnd, height);
        }
        ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
    }

    private void render(Graphics g2) {
        g2.setColor(Color.black);
        if (this.isWholeGenomeView()) {
            this.drawChromosomeTicks(g2);
        } else {
            this.drawTicks(g2);
            if (this.drawSpan) {
                this.drawSpan(g2);
            }
            if (this.drawEllipsis) {
                this.drawEllipsis(g2);
            }
        }
    }

    private void drawSpan(Graphics g2) {
        int w2 = this.getWidth();
        g2.setFont(this.spanFont);
        int range = (int)(this.frame.getScale() * (double)w2) + 1;
        boolean scaleInKB = this.frame.getChrName().equals("All");
        TickSpacing ts = RulerPanel.findSpacing(range, scaleInKB);
        String rangeString = RulerPanel.formatNumber((double)range / (double)ts.getUnitMultiplier()) + " " + ts.getMajorUnit();
        int strWidth = g2.getFontMetrics().stringWidth(rangeString);
        int strHeight = g2.getFontMetrics().getAscent();
        int strPosition = (w2 - strWidth) / 2;
        int lineY = this.getHeight() - 35 - strHeight / 2;
        g2.drawLine(0, lineY, (w2 - strWidth) / 2 - 10, lineY);
        int[] arrowX = new int[]{0, 10, 10};
        int[] arrowY = new int[]{lineY, lineY + 3, lineY - 3};
        g2.fillPolygon(arrowX, arrowY, arrowX.length);
        g2.drawLine((w2 + strWidth) / 2 + 10, lineY, w2, lineY);
        arrowX = new int[]{w2, w2 - 10, w2 - 10};
        g2.fillPolygon(arrowX, arrowY, arrowX.length);
        g2.drawString(rangeString, strPosition, this.getHeight() - 35);
    }

    private void drawEllipsis(Graphics g2) {
        double cytobandScale = (double)this.frame.getChromosomeLength() / (double)this.getWidth();
        double maxPixel = this.frame.getMaxPixel();
        int start = (int)(this.frame.getOrigin() / cytobandScale);
        int span = (int)((double)this.getWidth() * this.frame.getScale() / cytobandScale);
        int end = start + span;
        g2.drawLine(start, 0, 0, this.getHeight());
        g2.drawLine(end, 0, this.getWidth(), this.getHeight());
    }

    private void drawTicks(Graphics g2) {
        int w2 = this.getWidth();
        if (w2 < 200) {
            return;
        }
        g2.setFont(this.tickFont);
        boolean scaleInKB = this.frame.getChrName().equals("All");
        int range = (int)((double)w2 * this.frame.getScale());
        TickSpacing ts = RulerPanel.findSpacing(range, scaleInKB);
        double spacing = ts.getMajorTick();
        int nTick = (int)(this.frame.getOrigin() / spacing) - 1;
        int l2 = (int)((double)nTick * spacing);
        int x2 = this.frame.getScreenPosition((double)(l2 - 1) + 0.5);
        while (x2 < this.getWidth()) {
            l2 = (int)((double)nTick * spacing);
            x2 = this.frame.getScreenPosition((double)(l2 - 1) + 0.5);
            String chrPosition = RulerPanel.formatNumber((double)l2 / (double)ts.getUnitMultiplier()) + " " + ts.getMajorUnit();
            int strWidth = g2.getFontMetrics().stringWidth(chrPosition);
            int strPosition = x2 - strWidth / 2;
            int height = this.getHeight();
            if (nTick % 2 == 0) {
                g2.drawString(chrPosition, strPosition, height - 15);
            }
            g2.drawLine(x2, height - 10, x2, height - 2);
            ++nTick;
        }
    }

    private void drawChromosomeTicks(Graphics g2) {
        Font chrFont = FontManager.getFont(10);
        this.setLayout(null);
        int locationUnit = 1000;
        g2.setFont(chrFont);
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        if (genome == null) {
            log.warn("No genome found");
            PreferenceManager.getInstance().remove("DEFAULT_GENOME_KEY");
            return;
        }
        boolean even = true;
        long offset = 0L;
        this.chromosomeRects.clear();
        List<String> chrNames = genome.getLongChromosomeNames();
        if (chrNames == null) {
            log.info("No chromosomes found for genome: " + PreferenceManager.getInstance().getDefaultGenome());
            PreferenceManager.getInstance().remove("DEFAULT_GENOME_KEY");
        }
        if (chrNames.size() > 500) {
            return;
        }
        FontMetrics fontMetrics = g2.getFontMetrics();
        for (String chrName : chrNames) {
            Chromosome c2 = genome.getChromosome(chrName);
            if (c2 == null) {
                log.info("Chromosome '" + chrName + "' not found");
                continue;
            }
            int chrLength = c2.getLength();
            double scale = this.frame.getScale();
            int gStart = genome.getGenomeCoordinate(chrName, 0);
            int x2 = (int)((double)gStart / scale);
            int dw = (int)((double)chrLength / ((double)locationUnit * scale));
            g2.drawLine(x2, this.getHeight() - 10, x2, this.getHeight() - 2);
            if (dw > 5) {
                int center = x2 + dw / 2;
                String displayName = null;
                displayName = chrName.startsWith("gi|") ? Genome.getNCBIName(chrName) : chrName.replace("chr", "");
                int strWidth = fontMetrics.stringWidth(displayName);
                int strPosition = center - strWidth / 2;
                int y = even ? this.getHeight() - 35 : this.getHeight() - 25;
                g2.drawString(displayName, strPosition, y);
                int sw = (int)fontMetrics.getStringBounds(displayName, g2).getWidth();
                Rectangle clickRect = new Rectangle(strPosition, y - 15, sw, 15);
                String tooltipText = "Jump to chromosome: " + chrName;
                this.chromosomeRects.add(new ClickLink(clickRect, chrName, tooltipText));
                even = !even;
            }
            offset += (long)chrLength;
        }
    }

    public static String formatNumber(double position) {
        return DECIMAL_FORMAT.format((int)position);
    }

    public static TickSpacing findSpacing(long maxValue, boolean scaleInKB) {
        if (maxValue < 10L) {
            return new TickSpacing(1.0, "bp", 1);
        }
        int nZeroes = (int)Math.log10(maxValue);
        String majorUnit = scaleInKB ? "kb" : "bp";
        int unitMultiplier = 1;
        if (nZeroes > 9) {
            majorUnit = scaleInKB ? "tb" : "gb";
            unitMultiplier = 1000000000;
        }
        if (nZeroes > 6) {
            majorUnit = scaleInKB ? "gb" : "mb";
            unitMultiplier = 1000000;
        } else if (nZeroes > 3) {
            majorUnit = scaleInKB ? "mb" : "kb";
            unitMultiplier = 1000;
        }
        double nMajorTicks = (double)maxValue / Math.pow(10.0, nZeroes - 1);
        if (nMajorTicks < 25.0) {
            return new TickSpacing(Math.pow(10.0, nZeroes - 1), majorUnit, unitMultiplier);
        }
        return new TickSpacing(Math.pow(10.0, nZeroes) / 2.0, majorUnit, unitMultiplier);
    }

    private void init() {
        this.setBorder(BorderFactory.createLineBorder(UIConstants.TRACK_BORDER_GRAY));
        this.setCursor(Cursor.getDefaultCursor());
        if (this.isWholeGenomeView()) {
            this.setToolTipText(WHOLE_GENOME_TOOLTIP);
        } else {
            this.setToolTipText("Click and drag to zoom");
        }
        MouseInputAdapter mouseAdapter = new MouseInputAdapter(){
            int lastMousePressX;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent evt) {
                MouseEvent e2 = evt;
                RulerPanel.this.setCursor(Cursor.getDefaultCursor());
                WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                try {
                    if (!RulerPanel.this.isWholeGenomeView()) {
                        double newLocation = RulerPanel.this.frame.getChromosomePosition(e2.getX());
                        RulerPanel.this.frame.centerOnLocation(newLocation);
                    } else {
                        for (ClickLink link : RulerPanel.this.chromosomeRects) {
                            if (!link.region.contains(e2.getPoint())) continue;
                            String chrName = link.value;
                            RulerPanel.this.frame.getEventBus().post(new ViewChange.ChromosomeChangeCause(RulerPanel.this, chrName));
                        }
                    }
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e2) {
                if (RulerPanel.this.isWholeGenomeView()) {
                    for (ClickLink link : RulerPanel.this.chromosomeRects) {
                        if (!link.region.contains(e2.getPoint())) continue;
                        RulerPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                        RulerPanel.this.setToolTipText(link.tooltipText);
                        return;
                    }
                    RulerPanel.this.setCursor(Cursor.getDefaultCursor());
                    RulerPanel.this.setToolTipText(RulerPanel.WHOLE_GENOME_TOOLTIP);
                } else {
                    for (MouseRect mr : RulerPanel.this.mouseRects) {
                        if (!mr.containsPoint(e2.getPoint())) continue;
                        RulerPanel.this.setToolTipText(mr.getText());
                        return;
                    }
                    RulerPanel.this.setToolTipText(RulerPanel.CHROM_TOOLTIP);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
                RulerPanel.this.setCursor(Cursor.getDefaultCursor());
                if (RulerPanel.this.isWholeGenomeView()) {
                    RulerPanel.this.setToolTipText(RulerPanel.WHOLE_GENOME_TOOLTIP);
                } else {
                    RulerPanel.this.setToolTipText(RulerPanel.CHROM_TOOLTIP);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e2) {
                if (Math.abs(e2.getPoint().getX() - (double)RulerPanel.this.dragStart) > 1.0) {
                    RulerPanel.this.dragEnd = e2.getX();
                    RulerPanel.this.dragging = true;
                    RulerPanel.this.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                RulerPanel.this.dragStart = e2.getX();
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (RulerPanel.this.dragging) {
                    RulerPanel.this.dragEnd = e2.getX();
                    RulerPanel.this.dragging = false;
                    RulerPanel.this.zoom();
                }
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    private void zoom() {
        NamedRunnable runnable = new NamedRunnable(){

            @Override
            public void run() {
                double s2 = RulerPanel.this.frame.getChromosomePosition(RulerPanel.this.dragStart);
                double e2 = RulerPanel.this.frame.getChromosomePosition(RulerPanel.this.dragEnd);
                if (e2 < s2) {
                    double tmp = s2;
                    s2 = e2;
                    e2 = tmp;
                }
                if (e2 - s2 < 40.0) {
                    double c2 = (s2 + e2) / 2.0;
                    s2 = c2 - 20.0;
                    e2 = c2 + 20.0;
                }
                s2 = Math.max(0.0, s2);
                String chr = null;
                if (RulerPanel.this.isWholeGenomeView()) {
                    Genome genome = GenomeManager.getInstance().getCurrentGenome();
                    ChromosomeCoordinate start = genome.getChromosomeCoordinate((int)s2);
                    ChromosomeCoordinate end = genome.getChromosomeCoordinate((int)e2);
                    chr = start.getChr();
                    s2 = start.getCoordinate();
                    e2 = end.getCoordinate();
                    if (end.getChr() != start.getChr()) {
                        e2 = genome.getChromosome(start.getChr()).getLength();
                    }
                } else {
                    chr = RulerPanel.this.frame.getChrName();
                }
                RulerPanel.this.frame.jumpTo(chr, (int)Math.min(s2, e2), (int)Math.max(s2, e2));
                RulerPanel.this.frame.recordHistory();
            }

            @Override
            public String getName() {
                return "Rule panel zoom";
            }
        };
        LongRunningTask.submit(runnable);
    }

    static class MouseRect {
        Rectangle bounds;
        String text;

        MouseRect(Rectangle bounds, String text) {
            this.bounds = bounds;
            this.text = text;
        }

        boolean containsPoint(Point p2) {
            return this.bounds.contains(p2);
        }

        String getText() {
            return this.text;
        }

        public int width() {
            return this.bounds.width;
        }
    }

    class ClickLink {
        Rectangle region;
        String value;
        String tooltipText;

        ClickLink(Rectangle region, String value, String tooltipText) {
            this.region = region;
            this.value = value;
            this.tooltipText = tooltipText;
        }
    }

    public static class TickSpacing {
        private double majorTick;
        private double minorTick;
        private String majorUnit = "";
        private int unitMultiplier = 1;

        TickSpacing(double majorTick, String majorUnit, int unitMultiplier) {
            this.majorTick = majorTick;
            this.minorTick = majorTick / 10.0;
            this.majorUnit = majorUnit;
            this.unitMultiplier = unitMultiplier;
        }

        public double getMajorTick() {
            return this.majorTick;
        }

        public double getMinorTick() {
            return this.minorTick;
        }

        public String getMajorUnit() {
            return this.majorUnit;
        }

        public void setMajorUnit(String majorUnit) {
            this.majorUnit = majorUnit;
        }

        public int getUnitMultiplier() {
            return this.unitMultiplier;
        }

        public void setUnitMultiplier(int unitMultiplier) {
            this.unitMultiplier = unitMultiplier;
        }
    }
}

