/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.Collection;
import org.broad.igv.feature.Range;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.IAlignmentDataManager;
import org.broad.igv.sam.PositionCache;
import org.broad.igv.sam.SpliceJunctionHelper;

public class MemoryAlignmentDataManager
implements IAlignmentDataManager {
    private SpliceJunctionHelper.LoadOptions loadOptions;
    private PositionCache<AlignmentInterval> loadedIntervalCache = new PositionCache();

    public MemoryAlignmentDataManager(AlignmentDataManager alignmentDataManager, SpliceJunctionHelper.LoadOptions loadOptions) {
        this.loadOptions = loadOptions;
        this.loadedIntervalCache = new PositionCache(alignmentDataManager.getCache());
    }

    @Override
    public AlignmentInterval getLoadedInterval(Range range) {
        return this.loadedIntervalCache.getForRange(range);
    }

    @Override
    public SpliceJunctionHelper.LoadOptions getSpliceJunctionLoadOptions() {
        return this.loadOptions;
    }

    @Override
    public void setMinJunctionCoverage(int minJunctionCoverage) {
        this.loadOptions = new SpliceJunctionHelper.LoadOptions(minJunctionCoverage, this.loadOptions.minReadFlankingWidth);
        for (AlignmentInterval interval : this.getLoadedIntervals()) {
            interval.getSpliceJunctionHelper().setLoadOptions(this.loadOptions);
        }
    }

    @Override
    public Collection<AlignmentInterval> getLoadedIntervals() {
        return this.loadedIntervalCache.values();
    }
}

