/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util.management.jmx;

import com.mongodb.util.management.JMException;
import com.mongodb.util.management.MBeanServer;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class JMXMBeanServer
implements MBeanServer {
    private final javax.management.MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    public boolean isRegistered(String mBeanName) throws JMException {
        return this.server.isRegistered(this.createObjectName(mBeanName));
    }

    public void unregisterMBean(String mBeanName) throws JMException {
        try {
            this.server.unregisterMBean(this.createObjectName(mBeanName));
        }
        catch (InstanceNotFoundException e2) {
            throw new JMException(e2);
        }
        catch (MBeanRegistrationException e3) {
            throw new JMException(e3);
        }
    }

    public void registerMBean(Object mBean, String mBeanName) throws JMException {
        try {
            this.server.registerMBean(mBean, this.createObjectName(mBeanName));
        }
        catch (InstanceAlreadyExistsException e2) {
            throw new JMException(e2);
        }
        catch (MBeanRegistrationException e3) {
            throw new JMException(e3);
        }
        catch (NotCompliantMBeanException e4) {
            throw new JMException(e4);
        }
    }

    private ObjectName createObjectName(String mBeanName) throws JMException {
        try {
            return new ObjectName(mBeanName);
        }
        catch (MalformedObjectNameException e2) {
            throw new JMException(e2);
        }
    }
}

