/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.ArrayList;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;
import org.jgrapht.generate.RingGraphGenerator;

public class WheelGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    public static final String HUB_VERTEX = "Hub Vertex";
    private boolean inwardSpokes;
    private int size;

    public WheelGraphGenerator(int n2) {
        this(n2, true);
    }

    public WheelGraphGenerator(int n2, boolean bl) {
        if (n2 < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.size = n2;
        this.inwardSpokes = bl;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, final VertexFactory<V> vertexFactory, Map<String, V> map) {
        if (this.size < 1) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        VertexFactory vertexFactory2 = new VertexFactory<V>(){

            @Override
            public V createVertex() {
                Object v2 = vertexFactory.createVertex();
                arrayList.add(v2);
                return v2;
            }
        };
        RingGraphGenerator ringGraphGenerator = new RingGraphGenerator(this.size - 1);
        ringGraphGenerator.generateGraph(graph, vertexFactory2, map);
        V v2 = vertexFactory.createVertex();
        graph.addVertex(v2);
        if (map != null) {
            map.put(HUB_VERTEX, v2);
        }
        for (Object e2 : arrayList) {
            if (this.inwardSpokes) {
                graph.addEdge(e2, v2);
                continue;
            }
            graph.addEdge(v2, e2);
        }
    }
}

