/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.KShortestPathsIterator;
import org.jgrapht.alg.RankingPathElement;
import org.jgrapht.alg.RankingPathElementList;

public class KShortestPaths<V, E> {
    private Graph<V, E> graph;
    private int nMaxHops;
    private int nPaths;
    private V startVertex;

    public KShortestPaths(Graph<V, E> graph, V v2, int n2) {
        this(graph, v2, n2, graph.vertexSet().size() - 1);
    }

    public KShortestPaths(Graph<V, E> graph, V v2, int n2, int n3) {
        this.assertKShortestPathsFinder(graph, v2, n2, n3);
        this.graph = graph;
        this.startVertex = v2;
        this.nPaths = n2;
        this.nMaxHops = n3;
    }

    public List<GraphPath<V, E>> getPaths(V v2) {
        this.assertGetPaths(v2);
        KShortestPathsIterator<V, E> kShortestPathsIterator = new KShortestPathsIterator<V, E>(this.graph, this.startVertex, v2, this.nPaths);
        for (int i2 = 1; i2 <= this.nMaxHops && kShortestPathsIterator.hasNext(); ++i2) {
            kShortestPathsIterator.next();
        }
        RankingPathElementList<V, E> rankingPathElementList = kShortestPathsIterator.getPathElements(v2);
        if (rankingPathElementList == null) {
            return null;
        }
        ArrayList<GraphPath<V, PathWrapper>> arrayList = new ArrayList<GraphPath<V, PathWrapper>>();
        for (RankingPathElement rankingPathElement : rankingPathElementList) {
            arrayList.add(new PathWrapper(rankingPathElement));
        }
        return arrayList;
    }

    private void assertGetPaths(V v2) {
        if (v2 == null) {
            throw new NullPointerException("endVertex is null");
        }
        if (v2.equals(this.startVertex)) {
            throw new IllegalArgumentException("The end vertex is the same as the start vertex!");
        }
        if (!this.graph.vertexSet().contains(v2)) {
            throw new IllegalArgumentException("Graph must contain the end vertex!");
        }
    }

    private void assertKShortestPathsFinder(Graph<V, E> graph, V v2, int n2, int n3) {
        if (graph == null) {
            throw new NullPointerException("graph is null");
        }
        if (v2 == null) {
            throw new NullPointerException("startVertex is null");
        }
        if (n2 <= 0) {
            throw new NullPointerException("nPaths is negative or 0");
        }
        if (n3 <= 0) {
            throw new NullPointerException("nMaxHops is negative or 0");
        }
    }

    private class PathWrapper
    implements GraphPath<V, E> {
        private RankingPathElement<V, E> rankingPathElement;
        private List<E> edgeList;

        PathWrapper(RankingPathElement<V, E> rankingPathElement) {
            this.rankingPathElement = rankingPathElement;
        }

        @Override
        public Graph<V, E> getGraph() {
            return KShortestPaths.this.graph;
        }

        @Override
        public V getStartVertex() {
            return KShortestPaths.this.startVertex;
        }

        @Override
        public V getEndVertex() {
            return this.rankingPathElement.getVertex();
        }

        @Override
        public List<E> getEdgeList() {
            if (this.edgeList == null) {
                this.edgeList = this.rankingPathElement.createEdgeListPath();
            }
            return this.edgeList;
        }

        @Override
        public double getWeight() {
            return this.rankingPathElement.getWeight();
        }

        public String toString() {
            return this.getEdgeList().toString();
        }
    }
}

