/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bson.BSONException;

public class BSONByteBuffer {
    protected ByteBuffer buf;

    private BSONByteBuffer(ByteBuffer buf) {
        this.buf = buf;
        buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static BSONByteBuffer wrap(byte[] bytes, int offset, int length) {
        return new BSONByteBuffer(ByteBuffer.wrap(bytes, offset, length));
    }

    public static BSONByteBuffer wrap(byte[] bytes) {
        return new BSONByteBuffer(ByteBuffer.wrap(bytes));
    }

    public byte get(int i2) {
        return this.buf.get(i2);
    }

    public ByteBuffer get(byte[] bytes, int offset, int length) {
        return this.buf.get(bytes, offset, length);
    }

    public ByteBuffer get(byte[] bytes) {
        return this.buf.get(bytes);
    }

    public byte[] array() {
        return this.buf.array();
    }

    public String toString() {
        return this.buf.toString();
    }

    public int hashCode() {
        return this.buf.hashCode();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        BSONByteBuffer that = (BSONByteBuffer)o2;
        return !(this.buf != null ? !this.buf.equals(that.buf) : that.buf != null);
    }

    public int getInt(int i2) {
        return this.getIntLE(i2);
    }

    public int getIntLE(int i2) {
        int x2 = 0;
        x2 |= (0xFF & this.buf.get(i2 + 0)) << 0;
        x2 |= (0xFF & this.buf.get(i2 + 1)) << 8;
        x2 |= (0xFF & this.buf.get(i2 + 2)) << 16;
        return x2 |= (0xFF & this.buf.get(i2 + 3)) << 24;
    }

    public int getIntBE(int i2) {
        int x2 = 0;
        x2 |= (0xFF & this.buf.get(i2 + 0)) << 24;
        x2 |= (0xFF & this.buf.get(i2 + 1)) << 16;
        x2 |= (0xFF & this.buf.get(i2 + 2)) << 8;
        return x2 |= (0xFF & this.buf.get(i2 + 3)) << 0;
    }

    public long getLong(int i2) {
        return this.buf.getLong(i2);
    }

    public String getCString(int offset) {
        int end = offset;
        while (this.get(end) != 0) {
            ++end;
        }
        int len = end - offset;
        return new String(this.array(), offset, len);
    }

    public String getUTF8String(int valueOffset) {
        int size = this.getInt(valueOffset) - 1;
        try {
            return new String(this.array(), valueOffset + 4, size, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new BSONException("Cannot decode string as UTF-8.");
        }
    }

    public Buffer position(int i2) {
        return this.buf.position(i2);
    }

    public Buffer reset() {
        return this.buf.reset();
    }

    public int size() {
        return this.getInt(0);
    }
}

