/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.bson.BSONDecoder;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.Transformer;
import org.bson.util.ClassMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BSON {
    static final Logger LOGGER = Logger.getLogger("org.bson.BSON");
    public static final byte EOO = 0;
    public static final byte NUMBER = 1;
    public static final byte STRING = 2;
    public static final byte OBJECT = 3;
    public static final byte ARRAY = 4;
    public static final byte BINARY = 5;
    public static final byte UNDEFINED = 6;
    public static final byte OID = 7;
    public static final byte BOOLEAN = 8;
    public static final byte DATE = 9;
    public static final byte NULL = 10;
    public static final byte REGEX = 11;
    public static final byte REF = 12;
    public static final byte CODE = 13;
    public static final byte SYMBOL = 14;
    public static final byte CODE_W_SCOPE = 15;
    public static final byte NUMBER_INT = 16;
    public static final byte TIMESTAMP = 17;
    public static final byte NUMBER_LONG = 18;
    public static final byte MINKEY = -1;
    public static final byte MAXKEY = 127;
    public static final byte B_GENERAL = 0;
    public static final byte B_FUNC = 1;
    public static final byte B_BINARY = 2;
    public static final byte B_UUID = 3;
    private static final int GLOBAL_FLAG = 256;
    private static boolean _encodeHooks = false;
    private static boolean _decodeHooks = false;
    static ClassMap<List<Transformer>> _encodingHooks = new ClassMap();
    static ClassMap<List<Transformer>> _decodingHooks = new ClassMap();
    protected static Charset _utf8 = Charset.forName("UTF-8");
    static ThreadLocal<BSONEncoder> _staticEncoder = new ThreadLocal<BSONEncoder>(){

        @Override
        protected BSONEncoder initialValue() {
            return new BasicBSONEncoder();
        }
    };
    static ThreadLocal<BSONDecoder> _staticDecoder = new ThreadLocal<BSONDecoder>(){

        @Override
        protected BSONDecoder initialValue() {
            return new BasicBSONDecoder();
        }
    };

    public static int regexFlags(String flags) {
        int fint = 0;
        if (flags == null || flags.length() == 0) {
            return fint;
        }
        flags = flags.toLowerCase();
        for (int i2 = 0; i2 < flags.length(); ++i2) {
            RegexFlag flag = RegexFlag.getByCharacter(flags.charAt(i2));
            if (flag != null) {
                fint |= flag.javaFlag;
                if (flag.unsupported == null) continue;
                BSON._warnUnsupportedRegex(flag.unsupported);
                continue;
            }
            throw new IllegalArgumentException("unrecognized flag [" + flags.charAt(i2) + "] " + flags.charAt(i2));
        }
        return fint;
    }

    public static int regexFlag(char c2) {
        RegexFlag flag = RegexFlag.getByCharacter(c2);
        if (flag == null) {
            throw new IllegalArgumentException("unrecognized flag [" + c2 + "]");
        }
        if (flag.unsupported != null) {
            BSON._warnUnsupportedRegex(flag.unsupported);
            return 0;
        }
        return flag.javaFlag;
    }

    public static String regexFlags(int flags) {
        StringBuilder buf = new StringBuilder();
        for (RegexFlag flag : RegexFlag.values()) {
            if ((flags & flag.javaFlag) <= 0) continue;
            buf.append(flag.flagChar);
            flags -= flag.javaFlag;
        }
        if (flags > 0) {
            throw new IllegalArgumentException("some flags could not be recognized.");
        }
        return buf.toString();
    }

    private static void _warnUnsupportedRegex(String flag) {
        LOGGER.info("flag " + flag + " not supported by db.");
    }

    public static boolean hasDecodeHooks() {
        return _decodeHooks;
    }

    public static void addEncodingHook(Class c2, Transformer t2) {
        _encodeHooks = true;
        List<Transformer> l2 = _encodingHooks.get(c2);
        if (l2 == null) {
            l2 = new CopyOnWriteArrayList<Transformer>();
            _encodingHooks.put(c2, l2);
        }
        l2.add(t2);
    }

    public static void addDecodingHook(Class c2, Transformer t2) {
        _decodeHooks = true;
        List<Transformer> l2 = _decodingHooks.get(c2);
        if (l2 == null) {
            l2 = new CopyOnWriteArrayList<Transformer>();
            _decodingHooks.put(c2, l2);
        }
        l2.add(t2);
    }

    public static Object applyEncodingHooks(Object o2) {
        if (!BSON._anyHooks()) {
            return o2;
        }
        if (_encodingHooks.size() == 0 || o2 == null) {
            return o2;
        }
        List<Transformer> l2 = _encodingHooks.get(o2.getClass());
        if (l2 != null) {
            for (Transformer t2 : l2) {
                o2 = t2.transform(o2);
            }
        }
        return o2;
    }

    public static Object applyDecodingHooks(Object o2) {
        if (!BSON._anyHooks() || o2 == null) {
            return o2;
        }
        List<Transformer> l2 = _decodingHooks.get(o2.getClass());
        if (l2 != null) {
            for (Transformer t2 : l2) {
                o2 = t2.transform(o2);
            }
        }
        return o2;
    }

    public static List<Transformer> getEncodingHooks(Class c2) {
        return _encodingHooks.get(c2);
    }

    public static void clearEncodingHooks() {
        _encodeHooks = false;
        _encodingHooks.clear();
    }

    public static void removeEncodingHooks(Class c2) {
        _encodingHooks.remove(c2);
    }

    public static void removeEncodingHook(Class c2, Transformer t2) {
        BSON.getEncodingHooks(c2).remove(t2);
    }

    public static List<Transformer> getDecodingHooks(Class c2) {
        return _decodingHooks.get(c2);
    }

    public static void clearDecodingHooks() {
        _decodeHooks = false;
        _decodingHooks.clear();
    }

    public static void removeDecodingHooks(Class c2) {
        _decodingHooks.remove(c2);
    }

    public static void removeDecodingHook(Class c2, Transformer t2) {
        BSON.getDecodingHooks(c2).remove(t2);
    }

    public static void clearAllHooks() {
        BSON.clearEncodingHooks();
        BSON.clearDecodingHooks();
    }

    private static boolean _anyHooks() {
        return _encodeHooks || _decodeHooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encode(BSONObject o2) {
        BSONEncoder e2 = _staticEncoder.get();
        try {
            byte[] byArray = e2.encode(o2);
            return byArray;
        }
        finally {
            e2.done();
        }
    }

    public static BSONObject decode(byte[] b2) {
        BSONDecoder d2 = _staticDecoder.get();
        return d2.readObject(b2);
    }

    public static int toInt(Object o2) {
        if (o2 == null) {
            throw new NullPointerException("can't be null");
        }
        if (o2 instanceof Number) {
            return ((Number)o2).intValue();
        }
        if (o2 instanceof Boolean) {
            return (Boolean)o2 != false ? 1 : 0;
        }
        throw new IllegalArgumentException("can't convert: " + o2.getClass().getName() + " to int");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RegexFlag {
        CANON_EQ(128, 'c', "Pattern.CANON_EQ"),
        UNIX_LINES(1, 'd', "Pattern.UNIX_LINES"),
        GLOBAL(256, 'g', null),
        CASE_INSENSITIVE(2, 'i', null),
        MULTILINE(8, 'm', null),
        DOTALL(32, 's', "Pattern.DOTALL"),
        LITERAL(16, 't', "Pattern.LITERAL"),
        UNICODE_CASE(64, 'u', "Pattern.UNICODE_CASE"),
        COMMENTS(4, 'x', null);

        private static final Map<Character, RegexFlag> byCharacter;
        public final int javaFlag;
        public final char flagChar;
        public final String unsupported;

        public static RegexFlag getByCharacter(char ch) {
            return byCharacter.get(Character.valueOf(ch));
        }

        private RegexFlag(int f2, char ch, String u2) {
            this.javaFlag = f2;
            this.flagChar = ch;
            this.unsupported = u2;
        }

        static {
            byCharacter = new HashMap<Character, RegexFlag>();
            for (RegexFlag flag : RegexFlag.values()) {
                byCharacter.put(Character.valueOf(flag.flagChar), flag);
            }
        }
    }
}

