/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.haplotypeBAMWriter;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMReadGroupRecord;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.gatk.engine.io.GATKSAMFileWriter;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public abstract class ReadDestination {
    private final SAMFileHeader bamHeader;

    public abstract void add(GATKSAMRecord var1);

    public SAMFileHeader getHeader() {
        return this.bamHeader;
    }

    protected ReadDestination(SAMFileHeader header, String readGroupID) {
        if (header == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        this.bamHeader = new SAMFileHeader();
        this.bamHeader.setSequenceDictionary(header.getSequenceDictionary());
        this.bamHeader.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        ArrayList<SAMReadGroupRecord> readGroups = new ArrayList<SAMReadGroupRecord>(header.getReadGroups());
        SAMReadGroupRecord rg = new SAMReadGroupRecord(readGroupID);
        rg.setSample("HC");
        rg.setSequencingCenter("BI");
        readGroups.add(rg);
        this.bamHeader.setReadGroups(readGroups);
    }

    public static class ToList
    extends ReadDestination {
        final List<GATKSAMRecord> reads = new LinkedList<GATKSAMRecord>();

        public ToList(SAMFileHeader header, String readGroupID) {
            super(header, readGroupID);
        }

        @Override
        public void add(GATKSAMRecord read) {
            this.reads.add(read);
        }

        public List<GATKSAMRecord> getReads() {
            return this.reads;
        }
    }

    public static class ToBAM
    extends ReadDestination {
        final SAMFileWriter bamWriter;

        public ToBAM(GATKSAMFileWriter stingSAMWriter, SAMFileHeader header, String readGroupID) {
            super(header, readGroupID);
            if (stingSAMWriter == null) {
                throw new IllegalArgumentException("writer cannot be null");
            }
            this.bamWriter = stingSAMWriter;
            stingSAMWriter.setPresorted(false);
            stingSAMWriter.writeHeader(this.getHeader());
        }

        @Override
        public void add(GATKSAMRecord read) {
            this.bamWriter.addAlignment(read);
        }
    }
}

