/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.codecs.table;

import htsjdk.tribble.Feature;
import java.util.List;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.Utils;

public class TableFeature
implements Feature {
    private final List<String> values;
    private final List<String> keys;
    private final GenomeLoc position;

    public TableFeature(GenomeLoc position, List<String> values, List<String> keys) {
        this.values = values;
        this.keys = keys;
        this.position = position;
    }

    @Override
    public String getChr() {
        return this.position.getContig();
    }

    @Override
    public int getStart() {
        return this.position.getStart();
    }

    @Override
    public int getEnd() {
        return this.position.getStop();
    }

    public String getValue(int columnPosition) {
        if (columnPosition >= this.values.size()) {
            throw new IllegalArgumentException("We only have " + this.values.size() + "columns, the requested column = " + columnPosition);
        }
        return this.values.get(columnPosition);
    }

    public String toString() {
        return String.format("%s\t%s", this.position.toString(), Utils.join("\t", this.values));
    }

    public String get(String columnName) {
        int position = this.keys.indexOf(columnName);
        if (position < 0) {
            throw new IllegalArgumentException("We don't have a column named " + columnName);
        }
        return this.values.get(position);
    }

    public GenomeLoc getLocation() {
        return this.position;
    }

    public List<String> getAllValues() {
        return this.getValuesTo(this.values.size());
    }

    public List<String> getValuesTo(int columnPosition) {
        return this.values.subList(0, columnPosition);
    }

    public List<String> getHeader() {
        return this.keys;
    }
}

