/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools.walkers.na12878kb.core;

import htsjdk.samtools.reference.FastaSequenceFile;
import java.io.File;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.MongoVariantContext;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.NA12878DBArgumentCollection;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.NA12878KnowledgeBase;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.SiteManager;
import org.broadinstitute.gatk.utils.GenomeLocParser;

public class NA12878KBMain {
    public static void main(String[] args) throws Exception {
        FastaSequenceFile fasta = new FastaSequenceFile(new File(args[0]), false);
        GenomeLocParser parser = new GenomeLocParser(fasta.getSequenceDictionary());
        NA12878DBArgumentCollection dbArgumentCollection = new NA12878DBArgumentCollection();
        NA12878KnowledgeBase db = new NA12878KnowledgeBase(parser, dbArgumentCollection);
        System.out.printf("Printing consensus%n", new Object[0]);
        int n2 = 0;
        for (MongoVariantContext mvc : db.getConsensusSites(new SiteManager(parser))) {
            if (n2++ % 10 == 0) {
                System.out.printf("mvc + " + mvc.getChr() + ":" + mvc.getStart() + "%n", new Object[0]);
            }
            if (n2 <= 100) continue;
            break;
        }
        db.close();
    }
}

