/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.util.FileUtils;

public class OpenSessionMenuAction
extends MenuAction {
    private static Logger log = Logger.getLogger(OpenSessionMenuAction.class);
    private IGV mainFrame;
    private String sessionFile = null;
    private boolean autoload = false;

    public OpenSessionMenuAction(String label, String sessionFile, IGV mainFrame) {
        super(label);
        this.sessionFile = sessionFile;
        this.mainFrame = mainFrame;
        this.autoload = true;
    }

    public OpenSessionMenuAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (this.sessionFile == null || !this.autoload) {
            File lastSessionDirectory = PreferenceManager.getInstance().getLastSessionDirectory();
            File tmpFile = FileDialogUtils.chooseFile("Open Session", lastSessionDirectory, 0);
            if (tmpFile == null) {
                return;
            }
            this.sessionFile = tmpFile.getAbsolutePath();
        }
        this.doRestoreSession();
    }

    public final void doRestoreSession() {
        if (IGV.getInstance().getAllTracks().size() > 0) {
            OpenSessionMenuAction openSessionMenuAction = this;
            int status = JOptionPane.showConfirmDialog(openSessionMenuAction.mainFrame.getMainFrame(), "<html>Opening a session will unload all current data. <br>Are you sure you wish to continue?", null, 2, -1, null);
            if (status == 2 || status == -1) {
                return;
            }
        }
        if (this.sessionFile != null) {
            if (FileUtils.isRemote(this.sessionFile)) {
                boolean merge = false;
                this.mainFrame.doRestoreSession(this.sessionFile, null, merge);
            } else {
                File f2 = new File(this.sessionFile);
                this.mainFrame.doRestoreSession(f2, null);
            }
        }
    }
}

