/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.util.Comparator;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;

public abstract class AttributeComparator<T>
implements Comparator<T> {
    private final String[] attributeNames;
    private final boolean[] ascending;

    AttributeComparator(String[] attributeNames, boolean[] ascending) {
        assert (attributeNames.length == ascending.length);
        this.attributeNames = attributeNames;
        this.ascending = ascending;
    }

    protected abstract String getAttributeValue(T var1, String var2);

    @Override
    public int compare(T t1, T t2) {
        for (int i2 = 0; i2 < this.attributeNames.length; ++i2) {
            String attName = this.attributeNames[i2];
            if (attName == null) continue;
            String value1 = this.getAttributeValue(t1, attName);
            String value2 = this.getAttributeValue(t2, attName);
            boolean isNumeric = AttributeManager.getInstance().isNumeric(attName);
            int c2 = 0;
            if (isNumeric) {
                double d2;
                double d1;
                try {
                    d1 = Double.parseDouble(value1);
                }
                catch (NumberFormatException e2) {
                    d1 = Double.MIN_VALUE;
                }
                try {
                    d2 = Double.parseDouble(value2);
                }
                catch (NumberFormatException e3) {
                    d2 = Double.MIN_VALUE;
                }
                c2 = Double.compare(d1, d2);
            } else {
                c2 = value1.compareTo(value2);
            }
            if (c2 == 0) continue;
            return this.ascending[i2] ? c2 : -c2;
        }
        return 0;
    }

    public static class SampleAttributeComparator
    extends AttributeComparator<String> {
        public SampleAttributeComparator(String[] attributeNames, boolean[] ascending) {
            super(attributeNames, ascending);
        }

        @Override
        protected String getAttributeValue(String sample, String attName) {
            String value = AttributeManager.getInstance().getAttribute(sample, attName);
            if (value == null) {
                value = "";
            }
            return value.toLowerCase();
        }
    }

    public static class TrackAttributeComparator
    extends AttributeComparator<Track> {
        public TrackAttributeComparator(String[] attributeNames, boolean[] ascending) {
            super(attributeNames, ascending);
        }

        @Override
        protected String getAttributeValue(Track track, String attName) {
            String value = track.getAttributeValue(attName);
            if (value == null) {
                value = "";
            }
            return value.toLowerCase();
        }
    }
}

