/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import htsjdk.samtools.util.CloseableIterator;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;

public class PairedUtils {
    public static void main(String[] args) {
        PairedUtils.extractInteractions(args[0], args[1], Integer.parseInt(args[2]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractInteractions(String alignmentFile, String outputFile, int binSize) {
        AlignmentReader reader = null;
        PrintWriter pw = null;
        CloseableIterator iter = null;
        HashMap<String, Integer> counts = new HashMap<String, Integer>(10000);
        try {
            reader = AlignmentReaderFactory.getReader(alignmentFile, false);
            iter = reader.iterator();
            while (iter != null && iter.hasNext()) {
                int o2;
                Alignment alignment = (Alignment)iter.next();
                if (!alignment.isPaired() || !alignment.getMate().isMapped() || alignment.getMappingQuality() <= 0 || Math.abs(alignment.getInferredInsertSize()) <= 100000 && alignment.getChr().equals(alignment.getMate().getChr())) continue;
                String chr1 = alignment.getChr();
                int bin1 = alignment.getAlignmentStart() / binSize;
                String chr2 = alignment.getMate().getChr();
                int bin2 = alignment.getMate().getStart() / binSize;
                int o1 = PairedUtils.getOrder(chr1);
                if (o1 > (o2 = PairedUtils.getOrder(chr2)) || o1 < 0 || o2 < 0) continue;
                String cell = chr1 + "_" + bin1 + ":" + chr2 + "_" + bin2;
                Integer count = (Integer)counts.get(cell);
                if (count == null) {
                    counts.put(cell, 1);
                    continue;
                }
                count = count + 1;
                counts.put(cell, count);
            }
            iter.close();
            Set entrySet = counts.entrySet();
            Iterator iter2 = entrySet.iterator();
            while (iter2.hasNext()) {
                if ((Integer)iter2.next().getValue() >= 5) continue;
                iter2.remove();
            }
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            for (Map.Entry entry : entrySet) {
                String cell = (String)entry.getKey();
                String[] tokens = cell.split(":");
                String[] t1 = tokens[0].split("_");
                String[] t2 = tokens[1].split("_");
                int bin1 = Integer.parseInt(t1[1]);
                int bin2 = Integer.parseInt(t2[1]);
                int gPos1 = (int)((double)bin1 + 0.5) * binSize;
                int gPos2 = (int)((double)bin2 + 0.5) * binSize;
                pw.println(cell + "\t" + t1[0] + "\t" + gPos1 + "\t" + t2[0] + "\t" + gPos2 + "\t" + (Integer)entry.getValue() / 2);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    private static int getOrder(String chr) {
        int order;
        try {
            order = Integer.parseInt(chr);
        }
        catch (NumberFormatException e2) {
            order = chr.contains("X") ? 23 : (chr.contains("Y") ? 24 : -1);
        }
        return order;
    }

    private static boolean passFilter(Alignment alignment) {
        return alignment.isPaired() && alignment.getMate().isMapped() && (Math.abs(alignment.getInferredInsertSize()) > 100000 || !alignment.getChr().equals(alignment.getMate().getChr()));
    }
}

