/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.AbstractIndex;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.tribble.util.LittleEndianOutputStream;
import jargs.gnu.CmdLineParser;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.GFFParser;
import org.broad.igv.feature.genome.FastaUtils;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeDescriptor;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.feature.tribble.GFFCodec;
import org.broad.igv.feature.tribble.IGVBEDCodec;
import org.broad.igv.sam.reader.AlignmentIndexer;
import org.broad.igv.tdf.TDFUtils;
import org.broad.igv.tools.CoverageCounter;
import org.broad.igv.tools.IgvToolsGui;
import org.broad.igv.tools.PairedUtils;
import org.broad.igv.tools.PreprocessingException;
import org.broad.igv.tools.Preprocessor;
import org.broad.igv.tools.UCSCUtils;
import org.broad.igv.tools.WigSummer;
import org.broad.igv.tools.converters.BamToBed;
import org.broad.igv.tools.converters.ExpressionFormatter;
import org.broad.igv.tools.converters.GCTtoIGVConverter;
import org.broad.igv.tools.converters.WigToBed;
import org.broad.igv.tools.sort.Sorter;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.ReadmeParser;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.converters.DensitiesToBedGraph;
import org.broad.igv.variant.util.VCFtoBed;

public class IgvTools {
    public static final String CMD_WIGTOBED = "wigtobed";
    public static final String CMD_VCFTOBED = "vcftobed";
    public static final String CMD_DENSITIESTOBEDGRAPH = "densitiestobedgraph";
    public static final String CMD_GEN_GENOME_LIST = "genGenomeList";
    private static Logger log = Logger.getLogger(IgvTools.class);
    static final String CMD_TILE = "tile";
    static final String CMD_TOTDF = "totdf";
    static final String CMD_COUNT = "count";
    static final String CMD_SORT = "sort";
    static final String CMD_INDEX = "index";
    static final String CMD_FORMATEXP = "formatexp";
    static final String CMD_VERSION = "version";
    static final String CMD_GUI = "gui";
    static final String CMD_HELP = "help";
    static final String CMD_BAMTOBED = "bamtobed";
    static final String CMD_TDFTOBEDGRAPH = "tdftobedgraph";
    static final String CMD_CONTACTS = "contacts";
    static PrintStream userMessageWriter = System.out;
    private static final String CONSOLE_APPENDER_NAME = "console";
    static final String STDOUT_FILE_STR = "stdout";
    static String[] commandDocs = new String[]{"version print the version number", "sort    sort an alignment file by start position. ", "index   index an alignment file", "toTDF    convert an input file (cn, gct, wig) to tiled data format (tdf)", "count   compute coverage density for an alignment file", "formatexp  center, scale, and log2 normalize an expression file", "gui      Start the gui", "help <command>     display this help message, or help on a specific command", "See http://www.broadinstitute.org/software/igv/igvtools_commandline for more detailed help"};
    public static final int MAX_RECORDS_IN_RAM = 500000;
    public static final int MAX_ZOOM = 7;
    public static final int WINDOW_SIZE = 25;
    public static final int EXT_FACTOR = 0;
    public static final Object PROBE_FILE = null;
    public static final int LINEAR_BIN_SIZE = 16000;
    public static final int INTERVAL_SIZE = 1000;
    public static final int LINEAR_INDEX = 1;
    public static final int INTERVAL_INDEX = 2;
    private static CmdLineParser.Option windowFunctions = null;
    private static CmdLineParser.Option tmpDirOption = null;
    private static CmdLineParser.Option maxZoomOption = null;
    private static CmdLineParser.Option typeOption = null;
    private static CmdLineParser.Option maxRecordsOption = null;
    private static CmdLineParser.Option probeFileOption = null;
    private static CmdLineParser.Option windowSizeOption = null;
    private static CmdLineParser.Option extFactorOption = null;
    private static CmdLineParser.Option preExtFactorOption = null;
    private static CmdLineParser.Option postExtFactorOption = null;
    private static CmdLineParser.Option separateBasesOption = null;
    private static CmdLineParser.Option strandOption = null;
    private static CmdLineParser.Option queryStringOpt = null;
    private static CmdLineParser.Option minMapQualityOpt = null;
    private static CmdLineParser.Option includeDupsOpt = null;
    private static CmdLineParser.Option pairedCoverageOpt = null;
    private static CmdLineParser.Option indexTypeOption = null;
    private static CmdLineParser.Option binSizeOption = null;
    private static CmdLineParser.Option outputDirOption = null;
    private static CmdLineParser.Option colorOption = null;

    public static String getVersionString() {
        return Globals.applicationString();
    }

    static String usageString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\nProgram: igvtools. " + IgvTools.getVersionString() + "\n\n");
        buf.append("Usage: igvtools [command] [options] [input file/dir] [other arguments]\n\n");
        buf.append("Command:");
        for (String c2 : commandDocs) {
            buf.append(" " + c2 + "\n\t");
        }
        return buf.toString();
    }

    static String usageString(String command) {
        command = command.toLowerCase();
        ReadmeParser parser = new ReadmeParser();
        String help = parser.getDocForCommand(command);
        return help;
    }

    private static void initLogger() {
        if (Logger.getRootLogger().getAppender("R") == null) {
            RollingFileAppender fileAppender = new RollingFileAppender();
            PatternLayout fileLayout = new PatternLayout();
            fileLayout.setConversionPattern("%p [%d{ISO8601}] [%F:%L]  %m%n");
            fileAppender.setName("R");
            fileAppender.setFile("igv.log");
            fileAppender.setThreshold(Level.ALL);
            fileAppender.setMaxFileSize("10KB");
            fileAppender.setMaxBackupIndex(1);
            fileAppender.setAppend(true);
            fileAppender.activateOptions();
            fileAppender.setLayout(fileLayout);
        }
        if (Logger.getRootLogger().getAppender(CONSOLE_APPENDER_NAME) == null) {
            PatternLayout consoleLayout = new PatternLayout();
            consoleLayout.setConversionPattern("%m%n");
            ConsoleAppender consoleAppender = new ConsoleAppender();
            consoleAppender.setThreshold(Level.INFO);
            consoleAppender.setName(CONSOLE_APPENDER_NAME);
            consoleAppender.setFollow(true);
            consoleAppender.activateOptions();
            consoleAppender.setLayout(consoleLayout);
            Logger.getRootLogger().addAppender(consoleAppender);
        }
    }

    public static void main(String[] argv) {
        try {
            Globals.setHeadless(true);
            new IgvTools().run(argv);
            userMessageWriter.println("Done");
            System.exit(0);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), e2);
            System.exit(-1);
        }
    }

    void run(String[] argv) {
        block40: {
            IgvTools.initLogger();
            if (argv.length == 0) {
                userMessageWriter.println(IgvTools.usageString());
                userMessageWriter.println("Error: No arguments provided");
                return;
            }
            String command = argv[0].toLowerCase();
            if (command.equals(CMD_HELP)) {
                if (argv.length > 1) {
                    userMessageWriter.println(IgvTools.usageString(argv[1]));
                } else {
                    userMessageWriter.println(IgvTools.usageString());
                }
                return;
            }
            if (command.equals(CMD_GUI)) {
                IgvTools.launchGUI();
                Runtime.getRuntime().halt(0);
            }
            if (command.equals(CMD_VERSION)) {
                userMessageWriter.println(IgvTools.getVersionString());
                return;
            }
            CmdLineParser parser = this.initParser(command);
            try {
                parser.parse(argv);
            }
            catch (CmdLineParser.OptionException e2) {
                userMessageWriter.println(e2.getMessage());
                userMessageWriter.println("Enter igvtools help " + command + " for help on this command");
                return;
            }
            String tmpDirName = null;
            if (tmpDirOption != null) {
                tmpDirName = (String)parser.getOptionValue(tmpDirOption, null);
            }
            int maxRecords = 500000;
            if (maxRecordsOption != null) {
                maxRecords = (Integer)parser.getOptionValue(maxRecordsOption, 500000);
            }
            String[] nonOptionArgs = parser.getRemainingArgs();
            try {
                boolean isList;
                String basic_syntax = "Error in syntax. Enter igvtools help " + command + " for usage instructions.";
                this.validateArgsLength(nonOptionArgs, 2, "Error: No input file provided");
                String ifile = nonOptionArgs[1];
                boolean bl = isList = ifile.indexOf(",") > 0;
                if (!isList && !FileUtils.resourceExists(ifile)) {
                    throw new PreprocessingException("File not found: " + ifile);
                }
                String typeString = null;
                if (typeOption != null) {
                    typeString = (String)parser.getOptionValue(typeOption);
                }
                typeString = typeString == null || typeString.length() == 0 ? Preprocessor.getExtension(ifile).toLowerCase() : typeString.toLowerCase();
                if (command.equals(CMD_COUNT) || command.equals(CMD_TILE) || command.equals(CMD_TOTDF)) {
                    this.validateArgsLength(nonOptionArgs, 4, basic_syntax);
                    int maxZoomValue = (Integer)parser.getOptionValue(maxZoomOption, 7);
                    String ofile = nonOptionArgs[2];
                    this.setWriteToStdOout(ofile);
                    String genomeId = nonOptionArgs[3];
                    boolean isGCT = typeString.endsWith("gct") || typeString.equals("mage-tab");
                    String wfsString = (String)parser.getOptionValue(windowFunctions);
                    Collection<WindowFunction> wfList = IgvTools.parseWFS(wfsString, isGCT);
                    if (command.equals(CMD_COUNT)) {
                        String trackLine = null;
                        String color = (String)parser.getOptionValue(colorOption);
                        if (color != null) {
                            trackLine = "track color=\"" + color + "\"";
                        }
                        int extFactorValue = (Integer)parser.getOptionValue(extFactorOption, 0);
                        int preFactorValue = (Integer)parser.getOptionValue(preExtFactorOption, 0);
                        int posFactorValue = (Integer)parser.getOptionValue(postExtFactorOption, 0);
                        int countFlags = this.parseCountFlags(parser);
                        String queryString = (String)parser.getOptionValue(queryStringOpt);
                        int minMapQuality = (Integer)parser.getOptionValue(minMapQualityOpt, 0);
                        int windowSizeValue = (Integer)parser.getOptionValue(windowSizeOption, 25);
                        this.doCount(ifile, ofile, genomeId, maxZoomValue, wfList, windowSizeValue, extFactorValue, preFactorValue, posFactorValue, trackLine, queryString, minMapQuality, countFlags);
                    } else {
                        String probeFile = (String)parser.getOptionValue(probeFileOption, PROBE_FILE);
                        this.toTDF(typeString, ifile, ofile, probeFile, genomeId, maxZoomValue, wfList, tmpDirName, maxRecords);
                    }
                    break block40;
                }
                if (command.equals(CMD_SORT)) {
                    this.validateArgsLength(nonOptionArgs, 3, basic_syntax);
                    String ofile = nonOptionArgs[2];
                    this.doSort(ifile, ofile, tmpDirName, maxRecords);
                    break block40;
                }
                if (command.equals(CMD_INDEX)) {
                    int indexType = (Integer)parser.getOptionValue(indexTypeOption, 1);
                    int defaultBinSize = indexType == 1 ? 16000 : 1000;
                    int binSize = (Integer)parser.getOptionValue(binSizeOption, defaultBinSize);
                    String outputDir = (String)parser.getOptionValue(outputDirOption, null);
                    this.doIndex(ifile, typeString, outputDir, indexType, binSize);
                    break block40;
                }
                if (command.equals(CMD_FORMATEXP)) {
                    this.validateArgsLength(nonOptionArgs, 3, basic_syntax);
                    File inputFile = new File(nonOptionArgs[1]);
                    File outputFile = new File(nonOptionArgs[2]);
                    new ExpressionFormatter().convert(inputFile, outputFile);
                    break block40;
                }
                if (command.equals("wibtowig")) {
                    this.validateArgsLength(nonOptionArgs, 4, "Error in syntax. Expected: " + command + " [options] txtfile wibfile wigfile");
                    File txtFile = new File(nonOptionArgs[1]);
                    File wibFile = new File(nonOptionArgs[2]);
                    File wigFile = new File(nonOptionArgs[3]);
                    String trackLine = nonOptionArgs.length > 4 ? nonOptionArgs[4] : null;
                    this.doWIBtoWIG(txtFile, wibFile, wigFile, trackLine);
                    break block40;
                }
                if (command.equals("splitgff")) {
                    this.validateArgsLength(nonOptionArgs, 3, "Error in syntax. Expected: " + command + " [options] inputfile outputdir");
                    String outputDirectory = nonOptionArgs[2];
                    GFFParser.splitFileByType(ifile, outputDirectory);
                    break block40;
                }
                if (command.equals("gfftobed")) {
                    this.validateArgsLength(nonOptionArgs, 3, "Error in syntax. Expected: " + command + " inputfile outputfile");
                    String ofile = nonOptionArgs[2];
                    this.setWriteToStdOout(ofile);
                    this.GFFToBed(ifile, ofile);
                    break block40;
                }
                if (command.toLowerCase().equals("gcttoigv")) {
                    String genomeId;
                    Genome genome;
                    this.validateArgsLength(nonOptionArgs, 4, basic_syntax + " genomeId");
                    String ofile = nonOptionArgs[2];
                    if (!ofile.endsWith(".igv")) {
                        ofile = ofile + ".igv";
                    }
                    if ((genome = IgvTools.loadGenome(genomeId = nonOptionArgs[3])) == null) {
                        throw new PreprocessingException("Genome could not be loaded: " + genomeId);
                    }
                    String probeFile = (String)parser.getOptionValue(probeFileOption, PROBE_FILE);
                    this.doGCTtoIGV(typeString, ifile, new File(ofile), probeFile, maxRecords, tmpDirName, genome);
                    break block40;
                }
                if (command.toLowerCase().equals(CMD_TDFTOBEDGRAPH)) {
                    this.validateArgsLength(nonOptionArgs, 3, basic_syntax);
                    String ofile = nonOptionArgs[2];
                    TDFUtils.tdfToBedgraph(ifile, ofile);
                    break block40;
                }
                if (command.equals(CMD_WIGTOBED)) {
                    this.validateArgsLength(nonOptionArgs, 2, "Error in syntax. Expected: " + command + " [options] inputfile");
                    String inputFile = nonOptionArgs[1];
                    float hetThreshold = 0.17f;
                    if (nonOptionArgs.length > 2) {
                        hetThreshold = Float.parseFloat(nonOptionArgs[2]);
                    }
                    float homThreshold = 0.55f;
                    if (nonOptionArgs.length > 3) {
                        homThreshold = Float.parseFloat(nonOptionArgs[3]);
                    }
                    WigToBed.run(inputFile, hetThreshold, homThreshold);
                    break block40;
                }
                if (command.equals(CMD_VCFTOBED)) {
                    this.validateArgsLength(nonOptionArgs, 3, basic_syntax);
                    String inputFile = nonOptionArgs[1];
                    String outputFile = nonOptionArgs[2];
                    VCFtoBed.convert(inputFile, outputFile);
                    break block40;
                }
                if (command.equals(this.CMD_SUMWIGS())) {
                    this.sumWigs(nonOptionArgs[1], nonOptionArgs[2]);
                    break block40;
                }
                if (command.equals(CMD_DENSITIESTOBEDGRAPH)) {
                    this.validateArgsLength(nonOptionArgs, 3, "Error in syntax. Expected: " + command + " [options] inputdir outputdir");
                    File inputDir = new File(nonOptionArgs[1]);
                    File outputDir = new File(nonOptionArgs[2]);
                    if (inputDir.isDirectory() && outputDir.isDirectory()) {
                        DensitiesToBedGraph.convert(inputDir, outputDir);
                    } else if (inputDir.isFile() && outputDir.isFile()) {
                        DensitiesToBedGraph.convert(inputDir, outputDir);
                    }
                    break block40;
                }
                if (command.equals(CMD_BAMTOBED)) {
                    this.validateArgsLength(nonOptionArgs, 3, basic_syntax);
                    String ofile = nonOptionArgs[2];
                    Boolean pairOption = (Boolean)parser.getOptionValue(pairedCoverageOpt, false);
                    BamToBed.convert(new File(ifile), new File(ofile), pairOption);
                    break block40;
                }
                if (command.equalsIgnoreCase(CMD_GEN_GENOME_LIST)) {
                    File inDir = new File(ifile);
                    GenomeManager manager = GenomeManager.getInstance();
                    manager.generateGenomeList(inDir, nonOptionArgs[2], nonOptionArgs[3]);
                    break block40;
                }
                if (command.equalsIgnoreCase(CMD_CONTACTS)) {
                    PairedUtils.extractInteractions(ifile, nonOptionArgs[2], Integer.parseInt(nonOptionArgs[3]));
                    break block40;
                }
                throw new PreprocessingException("Unknown command: " + argv[0]);
            }
            catch (IOException e3) {
                throw new PreprocessingException("Unexpected IO error: ", e3);
            }
        }
    }

    private String CMD_SUMWIGS() {
        return "sumwigs";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void GFFToBed(String ifile, String ofile) throws FileNotFoundException {
        IGVBEDCodec outCodec = new IGVBEDCodec();
        GFFParser parser = new GFFParser();
        GFFCodec codec = null;
        try {
            codec = (GFFCodec)CodecFactory.getCodec(ifile, null);
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Input file is not recognized as a GFF");
        }
        BufferedReader reader = null;
        PrintStream outStream = System.out;
        if (!ofile.equals(STDOUT_FILE_STR)) {
            outStream = new PrintStream(new FileOutputStream(ofile));
        }
        try {
            reader = ParsingUtils.openBufferedReader(ifile);
            List<Feature> features = parser.loadFeatures(reader, null, codec);
            for (Feature feat : features) {
                String encoded = outCodec.encode(feat);
                outStream.print(encoded);
                outStream.print('\n');
            }
        }
        catch (IOException e3) {
            log.error(e3.getMessage(), e3);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e4) {
                    log.error(e4.getMessage(), e4);
                }
            }
            if (outStream != null) {
                outStream.flush();
                outStream.close();
            }
        }
    }

    private boolean setWriteToStdOout(String ofile) {
        if (ofile.equals(STDOUT_FILE_STR)) {
            userMessageWriter = System.err;
            ConsoleAppender appender = (ConsoleAppender)Logger.getRootLogger().getAppender(CONSOLE_APPENDER_NAME);
            appender.setTarget("System.err");
            appender.activateOptions();
            Logger.getRootLogger().removeAppender(STDOUT_FILE_STR);
            return true;
        }
        return false;
    }

    private CmdLineParser initParser(String command) {
        command = command.toLowerCase();
        CmdLineParser parser = new CmdLineParser();
        if (command.equals(CMD_SORT) || command.equals(CMD_TOTDF) || command.equals(CMD_TILE)) {
            maxRecordsOption = parser.addIntegerOption('m', "maxRecords");
            tmpDirOption = parser.addStringOption('t', "tmpDir");
        }
        if (command.equals(CMD_COUNT) || command.equals(CMD_TOTDF) || command.equals(CMD_TILE)) {
            windowFunctions = parser.addStringOption('f', "windowFunctions");
            maxZoomOption = parser.addIntegerOption('z', "maxZoom");
            if (command.equals(CMD_COUNT) || command.equals(CMD_BAMTOBED)) {
                extFactorOption = parser.addIntegerOption('e', "extFactor");
                preExtFactorOption = parser.addIntegerOption("preExtFactor");
                postExtFactorOption = parser.addIntegerOption("postExtFactor");
                windowSizeOption = parser.addIntegerOption('w', "windowSize");
                separateBasesOption = parser.addBooleanOption("bases");
                strandOption = parser.addStringOption("strands");
                queryStringOpt = parser.addStringOption("query");
                minMapQualityOpt = parser.addIntegerOption("minMapQuality");
                includeDupsOpt = parser.addBooleanOption("includeDuplicates");
                pairedCoverageOpt = parser.addBooleanOption("pairs");
                colorOption = parser.addStringOption("color");
            } else {
                probeFileOption = parser.addStringOption('p', "probeFile");
                typeOption = parser.addStringOption("fileType");
            }
        }
        if (command.equals(CMD_INDEX)) {
            indexTypeOption = parser.addIntegerOption("indexType");
            binSizeOption = parser.addIntegerOption("binSize");
            outputDirOption = parser.addStringOption("outputDir");
        }
        return parser;
    }

    private int parseCountFlags(CmdLineParser parser) {
        int countFlags = 0;
        countFlags += (Boolean)parser.getOptionValue(separateBasesOption, false) != false ? 8 : 0;
        countFlags += (Boolean)parser.getOptionValue(includeDupsOpt, false) != false ? 32 : 0;
        countFlags += (Boolean)parser.getOptionValue(pairedCoverageOpt, false) != false ? 64 : 0;
        String strandopt = (String)parser.getOptionValue(strandOption, "");
        if (strandopt.equals("read")) {
            ++countFlags;
        } else if (strandopt.equals("first")) {
            countFlags += 2;
        } else if (strandopt.equals("second")) {
            log.warn("Warning: 'second' Option undocumented and may be removed in the future. BE WARNED!");
            countFlags += 4;
        }
        return countFlags;
    }

    private void sumWigs(String inputString, String outputString) throws IOException {
        String[] tokens = inputString.split(",");
        ArrayList<File> in = new ArrayList<File>();
        for (String f2 : tokens) {
            in.add(new File(f2));
        }
        File out = new File(outputString);
        WigSummer.sumWigs(in, out);
    }

    private void doGCTtoIGV(String typeString, String ifile, File ofile, String probefile, int maxRecords, String tmpDirName, Genome genome) throws IOException {
        userMessageWriter.println("gct -> igv: " + ifile + " -> " + ofile.getAbsolutePath());
        File tmpDir = null;
        if (tmpDirName != null && tmpDirName.trim().length() > 0 && !(tmpDir = new File(tmpDirName)).exists()) {
            throw new PreprocessingException("Error: tmp directory: " + tmpDir.getAbsolutePath() + " does not exist.");
        }
        ResourceLocator locator = new ResourceLocator(ifile);
        locator.setType(typeString);
        GCTtoIGVConverter.convert(locator, ofile, probefile, maxRecords, tmpDir, genome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toTDF(String typeString, String ifile, String ofile, String probeFile, String genomeId, int maxZoomValue, Collection<WindowFunction> windowFunctions, String tmpDirName, int maxRecords) throws IOException, PreprocessingException {
        if (!ifile.endsWith(".affective.csv")) {
            IgvTools.validateIsTilable(typeString);
        }
        log.info("toTDF.  File = " + ifile);
        log.info("Max zoom = " + maxZoomValue);
        if (probeFile != null && probeFile.trim().length() > 0) {
            log.info("Probe file = " + probeFile);
        }
        String wfString = "Window functions: ";
        for (WindowFunction wf : windowFunctions) {
            wfString = wfString + wf.toString() + " ";
        }
        log.info(wfString);
        boolean isGCT = this.isGCT(typeString);
        Genome genome = IgvTools.loadGenome(genomeId);
        if (genome == null) {
            throw new PreprocessingException("Genome could not be loaded: " + genomeId);
        }
        File inputFileOrDir = new File(ifile);
        int nLines = this.estimateLineCount(inputFileOrDir);
        File deleteme = null;
        if (this.isGCT(typeString)) {
            File tmpDir = null;
            if (tmpDirName != null && tmpDirName.length() > 0) {
                tmpDir = new File(tmpDirName);
                if (!tmpDir.exists() || !tmpDir.isDirectory()) {
                    throw new PreprocessingException("Specified tmp directory does not exist or is not directory: " + tmpDirName);
                }
            } else {
                tmpDir = new File(System.getProperty("java.io.tmpdir"), System.getProperty("user.name"));
            }
            if (!tmpDir.exists()) {
                tmpDir.mkdir();
            }
            String baseName = new File(ifile).getName();
            File igvFile = new File(tmpDir, baseName + ".igv");
            igvFile.deleteOnExit();
            this.doGCTtoIGV(typeString, ifile, igvFile, probeFile, maxRecords, tmpDirName, genome);
            inputFileOrDir = igvFile;
            deleteme = igvFile;
            typeString = ".igv";
        }
        File outputFile = new File(ofile);
        try {
            Preprocessor p2 = new Preprocessor(outputFile, genome, windowFunctions, nLines, null);
            if (inputFileOrDir.isDirectory() || inputFileOrDir.getName().endsWith(".list")) {
                p2.setSizeEstimate(0);
                List<File> files = this.getFilesFromDirOrList(inputFileOrDir);
                for (File f2 : files) {
                    p2.preprocess(f2, maxZoomValue, typeString);
                }
            } else {
                p2.preprocess(inputFileOrDir, maxZoomValue, typeString);
            }
            p2.finish();
        }
        catch (IOException e2) {
            log.error(e2.getMessage(), e2);
            if (outputFile.exists()) {
                outputFile.delete();
            }
        }
        finally {
            if (deleteme != null && deleteme.exists()) {
                deleteme.delete();
            }
        }
        userMessageWriter.flush();
    }

    private List<File> getFilesFromDirOrList(File inputFileOrDir) {
        if (inputFileOrDir.isDirectory()) {
            File[] files = inputFileOrDir.listFiles();
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file, File file1) {
                    return file.getName().compareTo(file1.getName());
                }
            });
            return Arrays.asList(files);
        }
        BufferedReader br = null;
        try {
            String nextLine;
            ArrayList<File> files = new ArrayList<File>();
            br = new BufferedReader(new FileReader(inputFileOrDir));
            File parentDirectory = inputFileOrDir.getParentFile();
            while ((nextLine = br.readLine()) != null) {
                File f2 = new File(nextLine);
                if (f2.exists()) {
                    if (f2.isDirectory()) continue;
                    files.add(f2);
                    continue;
                }
                f2 = new File(parentDirectory, nextLine);
                if (f2.exists()) {
                    files.add(f2);
                    continue;
                }
                log.error("File not found: " + nextLine);
            }
            ArrayList<File> arrayList = files;
            return arrayList;
        }
        catch (IOException e2) {
            log.error(e2.getMessage(), e2);
            throw new RuntimeException("Error parsing input file: " + inputFileOrDir.getAbsolutePath() + " " + e2.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e3) {
                    log.error(e3.getMessage(), e3);
                }
            }
        }
    }

    private boolean isGCT(String tmp) {
        if (tmp.endsWith(".txt")) {
            tmp = tmp.substring(0, tmp.length() - 4);
        }
        if (tmp.endsWith(".gz")) {
            tmp = tmp.substring(0, tmp.length() - 3);
        }
        return tmp.endsWith(".gct") || tmp.endsWith(".tab") || tmp.equals("mage-tab");
    }

    public void doCount(String ifile, String ofile, String genomeId, int maxZoomValue, Collection<WindowFunction> windowFunctions, int windowSizeValue, int extFactorValue, int preExtFactorValue, int postExtFactorValue, String trackLine, String queryString, int minMapQuality, int countFlags) throws IOException {
        block9: {
            String[] files;
            log.info("Computing coverage.  File = " + ifile);
            log.info("Max zoom = " + maxZoomValue);
            log.info("Window size = " + windowSizeValue);
            String wfString = "Window functions: ";
            for (WindowFunction wf : windowFunctions) {
                wfString = wfString + wf.toString() + " ";
            }
            log.info(wfString);
            log.info("Ext factor = " + extFactorValue);
            Genome genome = IgvTools.loadGenome(genomeId);
            if (genome == null) {
                throw new PreprocessingException("Genome could not be loaded: " + genomeId);
            }
            File tdfFile = null;
            File wigFile = null;
            boolean wigStdOut = false;
            for (String fileTok : files = ofile.split(",")) {
                if (fileTok.endsWith("wig")) {
                    wigFile = new File(fileTok);
                    continue;
                }
                if (fileTok.endsWith("tdf")) {
                    tdfFile = new File(fileTok);
                    continue;
                }
                if (!fileTok.equals(STDOUT_FILE_STR)) continue;
                wigStdOut = true;
            }
            if (tdfFile != null && !tdfFile.getName().endsWith(".tdf")) {
                tdfFile = new File(tdfFile.getAbsolutePath() + ".tdf");
            }
            try {
                Preprocessor p2 = new Preprocessor(tdfFile, genome, windowFunctions, -1, null);
                p2.setSkipZeroes(true);
                CoverageCounter counter = new CoverageCounter(ifile, p2, windowSizeValue, extFactorValue, wigFile, genome, queryString, minMapQuality, countFlags);
                counter.setWriteStdOut(wigStdOut);
                counter.setPreExtFactor(preExtFactorValue);
                counter.setPosExtFactor(postExtFactorValue);
                String prefix = FilenameUtils.getName(ifile);
                String[] tracknames = counter.getTrackNames(prefix + " ");
                p2.setTrackParameters(TrackType.COVERAGE, trackLine, tracknames);
                p2.setSizeEstimate((int)(genome.getNominalLength() / (long)windowSizeValue));
                counter.parse();
                p2.finish();
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), e2);
                if (tdfFile != null && tdfFile.exists()) {
                    tdfFile.delete();
                }
                if (tdfFile == null || !wigFile.exists()) break block9;
                wigFile.delete();
            }
        }
        userMessageWriter.flush();
    }

    public void doWIBtoWIG(File txtFile, File wibFile, File wigFile, String trackLine) {
        UCSCUtils.convertWIBFile(txtFile, wibFile, wigFile, trackLine);
    }

    public String doIndex(String ifile, String outputDir, int indexType, int binSize) throws IOException {
        String typeString = Preprocessor.getExtension(ifile);
        return this.doIndex(ifile, typeString, outputDir, indexType, binSize);
    }

    public String doIndex(String ifile, String typeString, String outputDir, int indexType, int binSize) throws IOException {
        File inputFile = new File(ifile);
        if (outputDir == null) {
            outputDir = inputFile.getParent();
        }
        String outputFileName = new File(outputDir, inputFile.getName()).getAbsolutePath();
        if (typeString.endsWith("gz")) {
            log.error("Cannot index a gzipped file");
            throw new PreprocessingException("Cannot index a gzipped file");
        }
        if (typeString.endsWith("bam")) {
            String msg = "Cannot index a BAM file. Use the samtools package for sorting and indexing BAM files.";
            log.error(msg);
            throw new PreprocessingException(msg);
        }
        String[] fastaTypes = new String[]{"fa", "fna", "fasta"};
        boolean isFasta = false;
        if (typeString.endsWith("sam") && !outputFileName.endsWith(".sai")) {
            outputFileName = outputFileName + ".sai";
        } else if (typeString.endsWith("bam") && !outputFileName.endsWith(".bai")) {
            outputFileName = outputFileName + ".bai";
        } else {
            for (String ft : fastaTypes) {
                if (!typeString.endsWith(ft) || outputFileName.endsWith(".fai")) continue;
                outputFileName = outputFileName + ".fai";
                isFasta = true;
                break;
            }
            if (!isFasta && !outputFileName.endsWith(".idx")) {
                outputFileName = outputFileName + ".idx";
            }
        }
        File outputFile = new File(outputFileName);
        try {
            if (typeString.endsWith("sam")) {
                AlignmentIndexer indexer = AlignmentIndexer.getInstance(inputFile, null, null);
                indexer.createSamIndex(outputFile);
                return outputFileName;
            }
            if (isFasta) {
                FastaUtils.createIndexFile(inputFile.getAbsolutePath(), outputFileName);
                return outputFileName;
            }
        }
        catch (Exception e2) {
            if (outputFile.exists()) {
                outputFile.delete();
            }
            throw new RuntimeException(e2);
        }
        Genome genome = null;
        FeatureCodec codec = CodecFactory.getCodec(ifile, genome);
        if (codec != null) {
            try {
                this.createTribbleIndex(ifile, outputFile, indexType, binSize, codec);
            }
            catch (TribbleException.MalformedFeatureFile e3) {
                StringBuffer buf = new StringBuffer();
                buf.append("<html>Files must be sorted by start position prior to indexing.<br>");
                buf.append(e3.getMessage());
                buf.append("<br><br>Note: igvtools can be used to sort the file, select \"File > Run igvtools...\".");
                MessageUtils.showMessage(buf.toString());
            }
        } else {
            throw new DataLoadException("Unknown File Type", ifile);
        }
        userMessageWriter.flush();
        return outputFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTribbleIndex(Index idx, String idxFile) throws IOException {
        FilterOutputStream stream = null;
        try {
            stream = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(idxFile)));
            idx.write((LittleEndianOutputStream)stream);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), e2);
            File tmp = new File(idxFile);
            if (tmp.exists()) {
                tmp.delete();
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private void createTribbleIndex(String ifile, File outputFile, int indexType, int binSize, FeatureCodec codec) throws IOException {
        File inputFile = new File(ifile);
        AbstractIndex idx = null;
        idx = indexType == 1 ? IndexFactory.createLinearIndex(inputFile, codec, binSize) : IndexFactory.createIntervalIndex(inputFile, codec, binSize);
        if (idx != null) {
            String idxFile = outputFile != null ? outputFile.getAbsolutePath() : ifile + ".idx";
            IgvTools.writeTribbleIndex(idx, idxFile);
        }
    }

    public void doSort(String ifile, String ofile, String tmpDirName, int maxRecords) {
        block4: {
            userMessageWriter.println("Sorting " + ifile + "  -> " + ofile);
            File inputFile = new File(ifile);
            boolean writeStdOut = ofile.equals(STDOUT_FILE_STR);
            File outputFile = writeStdOut ? null : new File(ofile);
            Sorter sorter = Sorter.getSorter(inputFile, outputFile);
            if (tmpDirName != null && tmpDirName.trim().length() > 0) {
                File tmpDir = new File(tmpDirName);
                if (!tmpDir.exists()) {
                    log.error("Error: tmp directory: " + tmpDir.getAbsolutePath() + " does not exist.");
                    throw new PreprocessingException("Error: tmp directory: " + tmpDir.getAbsolutePath() + " does not exist.");
                }
                sorter.setTmpDir(tmpDir);
            }
            sorter.setMaxRecords(maxRecords);
            try {
                sorter.run();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                if (!writeStdOut || !outputFile.exists()) break block4;
                outputFile.delete();
            }
        }
        userMessageWriter.flush();
    }

    private void validateArgsLength(String[] nonOptionArgs, int len, String failMessage) throws PreprocessingException {
        if (nonOptionArgs.length < len) {
            throw new PreprocessingException(failMessage + "\n");
        }
    }

    public static Genome loadGenome(String genomeFileOrID) throws IOException {
        String rootDir = FileUtils.getInstallDirectory();
        GenomeManager genomeManager = GenomeManager.getInstance();
        Genome genome = genomeManager.getCurrentGenome();
        if (genome != null && genome.getId().equals(genomeFileOrID)) {
            return genome;
        }
        File genomeFile = new File(genomeFileOrID);
        if (!genomeFile.exists()) {
            genomeFile = new File(rootDir, "genomes" + File.separator + genomeFileOrID + ".genome");
        }
        if (!genomeFile.exists()) {
            genomeFile = new File(rootDir, "genomes" + File.separator + genomeFileOrID + ".chrom.sizes");
        }
        if (!genomeFile.exists()) {
            genomeFile = new File(rootDir, "genomes" + File.separator + genomeFileOrID);
        }
        if (!genomeFile.exists()) {
            throw new PreprocessingException("Genome definition file not found for: " + genomeFileOrID);
        }
        if (Globals.isTesting() && genomeFile.getAbsolutePath().endsWith(".genome")) {
            GenomeDescriptor genomeDescriptor = GenomeManager.parseGenomeArchiveFile(genomeFile);
            if (genome != null && genomeDescriptor.getId().equals(genome.getId())) {
                return genome;
            }
        }
        if ((genome = genomeManager.loadGenome(genomeFile.getAbsolutePath(), null)) == null) {
            throw new PreprocessingException("Error loading: " + genomeFileOrID);
        }
        return genome;
    }

    private static void validateIsTilable(String typeString) {
        if (!(typeString.endsWith("cn") || typeString.endsWith("igv") || typeString.endsWith("wig") || typeString.endsWith("ewig") || typeString.endsWith("map") || typeString.endsWith("cn") || typeString.endsWith("snp") || typeString.endsWith("xcn") || typeString.endsWith("gct") || typeString.endsWith("tab") || typeString.endsWith("mage-tab") || typeString.endsWith("bedgraph") || typeString.endsWith("ewig.list") || Preprocessor.isAlignmentFile(typeString))) {
            throw new PreprocessingException("Tile command not supported for files of type: " + typeString);
        }
    }

    private static Collection<WindowFunction> parseWFS(String string, boolean isGCT) {
        if (string == null || string.length() == 0) {
            return isGCT ? Arrays.asList(WindowFunction.min, WindowFunction.mean, WindowFunction.max) : Arrays.asList(WindowFunction.mean);
        }
        String[] tokens = string.split(",");
        ArrayList<WindowFunction> funcs = new ArrayList<WindowFunction>(tokens.length);
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String wf = tokens[i2];
            if (wf.matches("p\\d{1,2}")) {
                wf = wf.replaceFirst("p", "percentile");
            }
            try {
                funcs.add(WindowFunction.valueOf(wf));
                continue;
            }
            catch (Exception e2) {
                log.error("Unrecognized window function: " + tokens[i2]);
            }
        }
        return funcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int estimateLineCount(File file) throws IOException {
        int nLines = 0;
        if (file.isDirectory() || file.getName().endsWith(".list")) {
            List<File> files = this.getFilesFromDirOrList(file);
            for (File f2 : files) {
                if (f2.isDirectory()) continue;
                nLines += ParsingUtils.estimateLineCount(f2.getAbsolutePath());
            }
        } else if (file.getName().endsWith(".map")) {
            BufferedReader reader = null;
            try {
                String nextLine;
                reader = new BufferedReader(new FileReader(file));
                while ((nextLine = reader.readLine()) != null) {
                    String[] tokens = Globals.whitespacePattern.split(nextLine);
                    File f3 = new File(file.getParent(), tokens[1]);
                    nLines += ParsingUtils.estimateLineCount(f3.getAbsolutePath());
                }
                int n2 = nLines;
                return n2;
            }
            catch (Exception e2) {
                userMessageWriter.println("Error estimating line count: " + e2.getMessage());
                nLines = 0;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        } else {
            nLines = ParsingUtils.estimateLineCount(file.getAbsolutePath());
        }
        return nLines;
    }

    private static void launchGUI() {
        IgvToolsGui.main(null);
    }
}

